/***************************************************************************** 
* 
* File Name : dig_seg.c
* 
* Description: dig_seg 
* 
* Copyright (c) 2014 Winner Micro Electronic Design Co., Ltd. 
* All rights reserved. 
* 
* Author : 
* 
* Date : 2018-12-04
*****************************************************************************/ 
#include "wm_include.h"
#include <stdio.h>
#include <time.h>

typedef int8_t wifi_type;
#define WIFI_UNCONNECTED	0
#define WIFI_CONNECTED		1
volatile wifi_type g_wifi_connected = WIFI_UNCONNECTED;
volatile u32 ip_success = 0;
int connectflag = 0;

#define USER_TASK_SIZE	1024
#define TIME_PROCESS_TASK_PRIO  53
static OS_STK UserTaskStk_time[USER_TASK_SIZE];

#define DISP_TASK_SIZE 1024
#define DISP_TASK_PRIO 51
static OS_STK DisplaytimeTaskStk[DISP_TASK_SIZE];

int dig_seg[8] = {WM_IO_PA_15, WM_IO_PA_01, WM_IO_PA_03, WM_IO_PA_06, WM_IO_PA_09, WM_IO_PA_13, WM_IO_PA_02, WM_IO_PA_14};

int num[10][8] = {{0,1,2,3,4,5},{1,2},{0,1,3,4,6},{0,1,2,3,6},{1,2,5,6},{0,2,3,5,6},{0,2,3,4,5,6},{0,1,2},{0,1,2,3,4,5,6},{0,1,2,3,5,6}};

struct tm *tblock = NULL;

void dig_seg_init(void)
{
	int i;
	for(i=0; i<8; i++)
	{
		tls_gpio_cfg(dig_seg[i], WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);
	}
	
	tls_gpio_cfg(WM_IO_PB_00, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_PULLLOW);
	tls_gpio_cfg(WM_IO_PB_01, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_PULLLOW);
	tls_gpio_cfg(WM_IO_PB_02, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_PULLLOW);
	tls_gpio_cfg(WM_IO_PB_03, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_PULLLOW);
	tls_gpio_cfg(WM_IO_PB_27, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_PULLLOW);
	tls_gpio_write(WM_IO_PB_27, 0);
	tls_gpio_write(WM_IO_PB_00, 0);
	tls_gpio_write(WM_IO_PB_01, 0);
	tls_gpio_write(WM_IO_PB_02, 0);
	tls_gpio_write(WM_IO_PB_03, 0);
	
	return;
}

int arr_len(int num)
{
	int len = 0;
	switch(num)
	{
		case 0:
		case 6:
		case 9:
			len = 6;
			break;
		case 1:
			len = 2;
			break;
		case 2:
		case 3:
		case 5:
			len = 5;
			break;
		case 4:
			len = 4;
			break;
		case 7:
			len = 3;
			break;
		case 8:
			len = 7;
			break;
		default:
			break;
	}
	return len;
}

void con_net_status_changed_event_2(u8 status )
{
	switch(status)
	{
		case NETIF_WIFI_DISCONNECTED:
		case NETIF_WIFI_JOIN_FAILED:
			g_wifi_connected = 0;
			break;
		case NETIF_IP_NET_UP:
		{
			struct tls_ethif * tmpethif = tls_netif_get_ethif();
			connectflag = 0xAA;
			g_wifi_connected = 1;
#if TLS_CONFIG_LWIP_VER2_0_3
			print_ipaddr(&tmpethif->ip_addr);
#if TLS_CONFIG_IPV6
			print_ipaddr(&tmpethif->ip6_addr[0]);
			print_ipaddr(&tmpethif->ip6_addr[1]);
			print_ipaddr(&tmpethif->ip6_addr[2]);
#endif
#else
			//printf("net up ==> ip = %d.%d.%d.%d\n",ip4_addr1(&tmpethif->ip_addr.addr),ip4_addr2(&tmpethif->ip_addr.addr),
							 ip4_addr3(&tmpethif->ip_addr.addr),ip4_addr4(&tmpethif->ip_addr.addr));
#endif
			ip_success = 1;
		}
			break;
		default:
			break;
	}
}

int connect_net(char *ssid, char *pwd)
{
	struct tls_param_ip *ip_param = NULL;

	//if (!ssid)
	//{
	//	return WM_FAILED;
	//}
	//tls_wifi_disconnect();

	//tls_wifi_set_oneshot_flag(0);

	ip_param = tls_mem_alloc(sizeof(struct tls_param_ip));
	if (ip_param)
	{
		tls_param_get(TLS_PARAM_ID_IP, ip_param, FALSE);
		if (ip_param->dhcp_enable != TRUE)
		{
    		ip_param->dhcp_enable = TRUE;
    		tls_param_set(TLS_PARAM_ID_IP, ip_param, TRUE);
		}
		tls_mem_free(ip_param);
	}
	tls_netif_add_status_event(con_net_status_changed_event_2);
	//tls_wifi_connect((u8 *)ssid, strlen(ssid), (u8 *)pwd, strlen(pwd));
	//printf("\nplease wait connect net......\n");
	return WM_SUCCESS;
}

int connect_net_ntp(void)
{
	u8 autoconnect;
	char ssidname[] = "my-WiFi";
	char *pwd = "12345678";
	tls_cmd_set_wireless_mode(0, 1);

	tls_wifi_auto_connect_flag(WIFI_AUTO_CNT_FLAG_GET, &autoconnect);
 
	if(WIFI_AUTO_CNT_ON != autoconnect)
	{
		autoconnect = WIFI_AUTO_CNT_ON;
		tls_wifi_auto_connect_flag(WIFI_AUTO_CNT_FLAG_SET, &autoconnect);
	}
	g_wifi_connected = 0x2;
	if(connect_net(ssidname, pwd) == WM_SUCCESS){
		//USER_PRINT("CONNECT WIFI SUCCESS\n");
	}
	return 0;
}

int seg_num(int no)
{
	int i;
	for(i=0; i<8; i++)
	{
		tls_gpio_write(dig_seg[i], 1);
	}
	for(i=0; i<arr_len(no); i++)
	{
		tls_gpio_write(dig_seg[num[no][i]], 0);
	}
	
	return 0;
}

int seg_num2(void)
{
	int i;
	for(i=0; i<8; i++)
	{
		tls_gpio_write(dig_seg[i], 1);
	}
	//for(i=0; i<l; i++)
	//{
	//	tls_gpio_write(dig_seg[l], 0);
	//}
	
	return 0;
}

int seg_num3(int l)
{
	tls_gpio_write(dig_seg[l], 0);
	
	return 0;
}


void fresh_time(void)
{
    unsigned int t = 0;
    unsigned int l = 0;
	tls_os_time_delay(100);
	while(1)
	{
		t = tls_ntp_client();
		if (t > l)
		{
		    tblock=localtime(&t);
		    tls_set_rtc(tblock);
		    l = t;
            tls_os_time_delay(5 * 60 * HZ);
		}
		else
		{
		    tls_os_time_delay(15 * HZ);
		}
	}
}

void CreateTimeTask(void)
{
	tls_os_task_create(NULL, NULL,
			fresh_time,
                    NULL,
                    (void *)UserTaskStk_time,          
                    USER_TASK_SIZE * sizeof(u32), 
                    TIME_PROCESS_TASK_PRIO,
                    0);	
}

void test_dld(int a)
{
    int mi;
    //for (mi = 0; mi< 8;mi++)
    {
    tls_gpio_write(WM_IO_PB_03, 1);
	seg_num2();
	seg_num3(a);
	//tls_os_time_delay(2);
	//tls_gpio_write(WM_IO_PB_02, 0);
	tls_os_time_delay(2 * HZ);
	tls_gpio_write(WM_IO_PB_03, 0);
	
    }
}

int show_value = 1;
unsigned int last_time = 0;

void matrix_key_press(int no)
{
    printf("key S%d\r\n", no);
    show_value = no;
    beep_one();
    last_time = tls_os_get_time();
}

void time_delay_ms(u32 ms)
{
    ms = ms / portTICK_RATE_MS;
    if (!ms)
        ms = 1;
    tls_os_time_delay(ms);
}

#define BEEP_IO_NAME    WM_IO_PB_28

void beep_one(void)
{
    tls_gpio_write(BEEP_IO_NAME, 1);
    time_delay_ms(150);
    tls_gpio_write(BEEP_IO_NAME, 0);
}

void beep_init(void)
{
    tls_gpio_cfg(BEEP_IO_NAME, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);
    tls_gpio_write(BEEP_IO_NAME, 0);
}




/*

    beep PB_28


            5   PB_13 ----------S1----------S2----------S3----------S4
                SCL             |           |           |           |
 _____                          |           |           |           |
|     |     6   PB_14 ----------S5----------S6----------S7----------S8
|   1 |         SDA             |           |           |           |
|   2 |                         |           |           |           |
|   3 |     7   PB_15 ----------S9----------S10---------S11---------S12
|   4 |         SPI_CS          |           |           |           |
|   5 |                         |           |           |           |
|   6 |     8   PB_16 ----------S13---------S14---------S15---------S16
|   7 |         SPI_CK          |           |           |           |
|   8 |                         |           |           |           |
|_____|                         |           |           |           |
                                PB_17       PB_18       PB_19       PB_20
                                SPI_DI      SPI_DO      A1          A2
                                4           3           2           1


*/

#define         MATRIX_KEY_TASK_PRIO             52
#define         MATRIX_KEY_TASK_STK_SIZE         256
static OS_STK matrix_key_task_stk[MATRIX_KEY_TASK_STK_SIZE];

#define GPIOB_DATA_EN_ADDR                      (HR_GPIO_DATA_EN + TLS_IO_AB_OFFSET)
#define GPIOB_DATA_ADDR                         (HR_GPIO_DATA + TLS_IO_AB_OFFSET)

void matrix_key_init(void)
{
    /* row io */
    tls_gpio_cfg(WM_IO_PB_13, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);
    tls_gpio_cfg(WM_IO_PB_14, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);
    tls_gpio_cfg(WM_IO_PB_15, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);
    tls_gpio_cfg(WM_IO_PB_16, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);

    /* column io */
    tls_gpio_cfg(WM_IO_PB_17, WM_GPIO_DIR_INPUT, WM_GPIO_ATTR_PULLHIGH);
    tls_gpio_cfg(WM_IO_PB_18, WM_GPIO_DIR_INPUT, WM_GPIO_ATTR_PULLHIGH);
    tls_gpio_cfg(WM_IO_PB_19, WM_GPIO_DIR_INPUT, WM_GPIO_ATTR_PULLHIGH);
    tls_gpio_cfg(WM_IO_PB_20, WM_GPIO_DIR_INPUT, WM_GPIO_ATTR_PULLHIGH);
}

static void matrix_key_task(void *data)
{
    u32 reg;
	u32	reg_en;

    matrix_key_init();

    for( ; ; ) 
	{
	    /* set all row low */
		reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E000);
	    reg = tls_reg_read32(GPIOB_DATA_ADDR);
	    tls_reg_write32(GPIOB_DATA_ADDR, reg & 0xFFFE1FFF); /* write low */
	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);

	    time_delay_ms(1);

	    /* read column */
	    reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
    	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
    	reg = tls_reg_read32(GPIOB_DATA_ADDR);
    	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);

    	if ((reg & 0x1E0000) != 0x1E0000)
    	{
    	    /* avoid key jitter */
            time_delay_ms(20);

            /* read column again */
    	    reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
        	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
        	reg = tls_reg_read32(GPIOB_DATA_ADDR);
        	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);

        	if ((reg & 0x1E0000) != 0x1E0000) /* valid key */
    	    {
    	        /* check first row */

    	        /* set second & third & fourth row high */
    	        reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E000);
        	    reg = tls_reg_read32(GPIOB_DATA_ADDR);
        	    tls_reg_write32(GPIOB_DATA_ADDR, (reg & 0xFFFE1FFF) | 0x1C000); /* write high */
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);

        	    time_delay_ms(1);

                /* read column */
                reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
            	reg = tls_reg_read32(GPIOB_DATA_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
            	if ((reg & 0x1E0000) == 0x1C0000)
            	{
                    matrix_key_press(1);
            	}
            	if ((reg & 0x1E0000) == 0x1A0000)
            	{
                    matrix_key_press(2);
            	}
            	if ((reg & 0x1E0000) == 0x160000)
            	{
                    matrix_key_press(3);
            	}
            	if ((reg & 0x1E0000) == 0xE0000)
            	{
                    matrix_key_press(4);
            	}



                /* check second row */

                /* set first & third & fourth row high */
    	        reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E000);
        	    reg = tls_reg_read32(GPIOB_DATA_ADDR);
        	    tls_reg_write32(GPIOB_DATA_ADDR, (reg & 0xFFFE1FFF) | 0x1A000); /* write high */
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);

        	    time_delay_ms(1);

                /* read column */
                reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
            	reg = tls_reg_read32(GPIOB_DATA_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
            	if ((reg & 0x1E0000) == 0x1C0000)
            	{
                    matrix_key_press(5);
            	}
            	if ((reg & 0x1E0000) == 0x1A0000)
            	{
                    matrix_key_press(6);
            	}
            	if ((reg & 0x1E0000) == 0x160000)
            	{
                    matrix_key_press(7);
            	}
            	if ((reg & 0x1E0000) == 0xE0000)
            	{
                    matrix_key_press(8);
            	}



            	/* check third row */

                /* set first & second & fourth row high */
    	        reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E000);
        	    reg = tls_reg_read32(GPIOB_DATA_ADDR);
        	    tls_reg_write32(GPIOB_DATA_ADDR, (reg & 0xFFFE1FFF) | 0x16000); /* write high */
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);

        	    time_delay_ms(1);

                /* read column */
                reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
            	reg = tls_reg_read32(GPIOB_DATA_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
            	if ((reg & 0x1E0000) == 0x1C0000)
            	{
                    matrix_key_press(9);
            	}
            	if ((reg & 0x1E0000) == 0x1A0000)
            	{
                    matrix_key_press(10);
            	}
            	if ((reg & 0x1E0000) == 0x160000)
            	{
                    matrix_key_press(11);
            	}
            	if ((reg & 0x1E0000) == 0xE0000)
            	{
                    matrix_key_press(12);
            	}



            	/* check fourth row */

                /* set first & second & third row high */
    	        reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E000);
        	    reg = tls_reg_read32(GPIOB_DATA_ADDR);
        	    tls_reg_write32(GPIOB_DATA_ADDR, (reg & 0xFFFE1FFF) | 0xE000); /* write high */
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);

        	    time_delay_ms(1);

                /* read column */
                reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
            	reg = tls_reg_read32(GPIOB_DATA_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
            	if ((reg & 0x1E0000) == 0x1C0000)
            	{
                    matrix_key_press(13);
            	}
            	if ((reg & 0x1E0000) == 0x1A0000)
            	{
                    matrix_key_press(14);
            	}
            	if ((reg & 0x1E0000) == 0x160000)
            	{
                    matrix_key_press(15);
            	}
            	if ((reg & 0x1E0000) == 0xE0000)
            	{
                    matrix_key_press(16);
            	}
    	    }
    	}
        else
        {
    	    time_delay_ms(2);
    	}
	}
}


void matrix_task_init(void)
{
    tls_os_task_create(NULL, NULL, matrix_key_task,
                   (void *)0, (void *)matrix_key_task_stk,
                   MATRIX_KEY_TASK_STK_SIZE * sizeof(u32),
                   MATRIX_KEY_TASK_PRIO, 0);
}





int display_time(void)
{
	int i;
	int j;
	int t;
	struct tm tb;
	unsigned int curr_time = 0;

	dig_seg_init();

	connect_net_ntp();
#if 0
	tls_os_time_delay(500);
	t = tls_ntp_client();
	tblock=localtime(&t);	
	tls_set_rtc(tblock);
#endif
	CreateTimeTask();
    //tblock=localtime(&t);

    last_time = tls_os_get_time();

	while(1)
	{
        curr_time = tls_os_get_time();
        curr_time -= last_time;
        //if (ip_success && (curr_time >= (15 * 60 * HZ)))
        if (tblock && (curr_time >= (15 * 60 * HZ)))
        //if (tblock && (curr_time >= (15 * HZ * 1)))
        {
            tls_get_rtc(&tb);
            tls_gpio_write(WM_IO_PB_03, 1);
    		seg_num(tb.tm_min%10);
    		tls_os_time_delay(2);
    		tls_gpio_write(WM_IO_PB_03, 0);
    		tls_gpio_write(WM_IO_PB_02, 1);
    		seg_num(tb.tm_min/10);
    		tls_os_time_delay(2);
    		tls_gpio_write(WM_IO_PB_02, 0);
    		tls_gpio_write(WM_IO_PB_01, 1);
    		seg_num(tb.tm_hour%10);
    		tls_gpio_write(dig_seg[7],0);//.
    		tls_os_time_delay(2);
    		tls_gpio_write(WM_IO_PB_01, 0);
    		tls_gpio_write(WM_IO_PB_00, 1);
    		seg_num(tb.tm_hour/10);
    		tls_os_time_delay(2);
    		tls_gpio_write(WM_IO_PB_00, 0);
        }
        else
        {
            if ((show_value >= -9) && (show_value <= -1))
            {
                tls_gpio_write(WM_IO_PB_03, 1);
        		seg_num(-show_value);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_03, 0);

        		tls_gpio_write(WM_IO_PB_02, 1);
            	seg_num2();
            	seg_num3(6);
            	tls_os_time_delay(2);
            	tls_gpio_write(WM_IO_PB_02, 0);
            }
            else if ((show_value >= -99) && (show_value <= -10))
            {
                tls_gpio_write(WM_IO_PB_03, 1);
        		seg_num((-show_value) % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_03, 0);

        		tls_gpio_write(WM_IO_PB_02, 1);
        		seg_num((-show_value) / 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_02, 0);

        		tls_gpio_write(WM_IO_PB_01, 1);
            	seg_num2();
            	seg_num3(6);
            	tls_os_time_delay(2);
            	tls_gpio_write(WM_IO_PB_01, 0);
            }
            else if ((show_value >= -999) && (show_value <= -100))
            {
                i = (-show_value) % 100;
                t = (-show_value) / 100;

                tls_gpio_write(WM_IO_PB_03, 1);
        		seg_num(i % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_03, 0);

        		tls_gpio_write(WM_IO_PB_02, 1);
        		seg_num(i / 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_02, 0);

        		tls_gpio_write(WM_IO_PB_01, 1);
        		seg_num(t % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_01, 0);

        		tls_gpio_write(WM_IO_PB_00, 1);
            	seg_num2();
            	seg_num3(6);
            	tls_os_time_delay(2);
            	tls_gpio_write(WM_IO_PB_00, 0);
            }
            else if ((show_value >= -9999) && (show_value <= -1000))
            {
                i = (-show_value) % 100;
                t = (-show_value) / 100;

                tls_gpio_write(WM_IO_PB_03, 1);
        		seg_num(i % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_03, 0);

        		tls_gpio_write(WM_IO_PB_02, 1);
        		seg_num(i / 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_02, 0);

        		tls_gpio_write(WM_IO_PB_01, 1);
        		seg_num(t % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_01, 0);

        		tls_gpio_write(WM_IO_PB_00, 1);
        		seg_num(t / 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_00, 0);

        		tls_gpio_write(WM_IO_PB_27, 1);
            	seg_num2();
            	seg_num3(6);
            	tls_os_time_delay(2);
            	tls_gpio_write(WM_IO_PB_27, 0);
            }
            else if ((show_value >= 0) && (show_value <= 9))
            {
                tls_gpio_write(WM_IO_PB_03, 1);
        		seg_num(show_value);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_03, 0);
            }
            else if ((show_value >= 10) && (show_value <= 99))
            {
                tls_gpio_write(WM_IO_PB_03, 1);
        		seg_num(show_value % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_03, 0);

        		tls_gpio_write(WM_IO_PB_02, 1);
        		seg_num(show_value / 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_02, 0);
            }
            else if ((show_value >= 100) && (show_value <= 999))
            {
                i = show_value % 100;
                t = show_value / 100;

                tls_gpio_write(WM_IO_PB_03, 1);
        		seg_num(i % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_03, 0);

        		tls_gpio_write(WM_IO_PB_02, 1);
        		seg_num(i / 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_02, 0);

        		tls_gpio_write(WM_IO_PB_01, 1);
        		seg_num(t % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_01, 0);
            }
            else if ((show_value >= 1000) && (show_value <= 9999))
            {
                i = show_value % 100;
                t = show_value / 100;

                tls_gpio_write(WM_IO_PB_03, 1);
        		seg_num(i % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_03, 0);

        		tls_gpio_write(WM_IO_PB_02, 1);
        		seg_num(i / 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_02, 0);

        		tls_gpio_write(WM_IO_PB_01, 1);
        		seg_num(t % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_01, 0);

        		tls_gpio_write(WM_IO_PB_00, 1);
        		seg_num(t / 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_00, 0);
            }
            else if ((show_value >= 10000) && (show_value <= 99999))
            {
                i = show_value % 100;
                t = (show_value / 100) % 100;
                j = show_value / 10000;

                tls_gpio_write(WM_IO_PB_03, 1);
        		seg_num(i % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_03, 0);

        		tls_gpio_write(WM_IO_PB_02, 1);
        		seg_num(i / 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_02, 0);

        		tls_gpio_write(WM_IO_PB_01, 1);
        		seg_num(t % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_01, 0);

        		tls_gpio_write(WM_IO_PB_00, 1);
        		seg_num(t / 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_00, 0);

        		tls_gpio_write(WM_IO_PB_27, 1);
        		seg_num(j % 10);
        		tls_os_time_delay(2);
        		tls_gpio_write(WM_IO_PB_27, 0);
            }
            else
            {
                switch (show_value)
                {
                    case 100001:
                    {
                        tls_gpio_write(WM_IO_PB_02, 1);
                    	seg_num2();
                    	seg_num3(0);
                    	seg_num3(3);
                    	seg_num3(4);
                    	seg_num3(5);
                    	seg_num3(6);
                    	tls_os_time_delay(2);
                    	tls_gpio_write(WM_IO_PB_02, 0);

                    	tls_gpio_write(WM_IO_PB_03, 1);
                    	seg_num2();
                    	seg_num3(1);
                    	seg_num3(2);
                    	tls_os_time_delay(2);
                    	tls_gpio_write(WM_IO_PB_03, 0);
                        break;
                    }
                    case 100002:
                    {
                        tls_gpio_write(WM_IO_PB_02, 1);
                    	seg_num2();
                    	seg_num3(0);
                    	seg_num3(3);
                    	seg_num3(4);
                    	seg_num3(5);
                    	seg_num3(6);
                    	tls_os_time_delay(2);
                    	tls_gpio_write(WM_IO_PB_02, 0);

                    	tls_gpio_write(WM_IO_PB_03, 1);
                    	seg_num2();
                    	seg_num3(1);
                    	seg_num3(2);
                    	seg_num3(5);
                    	seg_num3(6);
                    	tls_os_time_delay(2);
                    	tls_gpio_write(WM_IO_PB_03, 0);
                        break;
                    }
                    case 100003:
                    {
                        tls_gpio_write(WM_IO_PB_02, 1);
                    	seg_num2();
                    	seg_num3(1);
                    	seg_num3(2);
                    	tls_os_time_delay(2);
                    	tls_gpio_write(WM_IO_PB_02, 0);

                    	tls_gpio_write(WM_IO_PB_03, 1);
                    	seg_num2();
                    	seg_num3(0);
                    	seg_num3(4);
                    	seg_num3(5);
                    	seg_num3(6);
                    	tls_os_time_delay(2);
                    	tls_gpio_write(WM_IO_PB_03, 0);
                        break;
                    }
                    default:
                    {
                        if (show_value > 99999)
                            show_value = 99999;
                        else if (show_value < -9999)
                            show_value = -9999;
                        printf("not here\n");
                        tls_os_time_delay(2);
                        break;
                    }
                }
            }
        }

		//tls_os_time_delay(2);
	}
}

void CreateDisplaytimeTask(void)
{
    beep_init();

	//tls_os_queue_create(&demo_q, DEMO_QUEUE_SIZE);
	tls_os_task_create(NULL, NULL,
			display_time,
                    NULL,
                    (void *)DisplaytimeTaskStk,          /* ջʼַ */
                    DISP_TASK_SIZE * sizeof(u32), /* ջĴС     */
                    DISP_TASK_PRIO,
                    0);

    matrix_task_init();
}

