#ifndef __SPI_SD_DRIVER__
#define __SPI_SD_DRIVER__

typedef enum sd_card_type {
    SD_TYPE_V2 = 0,
    SD_TYPE_V2HC = 1
}SD_TYPE_E;

u8 SD_GetCID(u8 *cid_data);

u8 SD_GetCSD(u8 *csd_data);

u32 SD_GetCapacity(void);

SD_TYPE_E SD_GetCardType(void);

u8 SD_ReadSingleBlock(u32 sector, u8 *buffer);

u8 SD_ReadMultiBlock(u32 sector, u8 *buffer, u8 count);

u8 SD_WriteSingleBlock(u32 sector, const u8 *data);

u8 SD_WriteMultiBlock(u32 sector, const u8 *data, u8 count);

u8 SD_Init(void);

#endif /* __SPI_SD_DRIVER__ */
