#include <stdio.h>
#include <string.h>
#include "wm_include.h"
#include "wm_gpio_afsel.h"
#include "wm_sdio_host.h"
#include "wm_cpu.h"
#include "my_vfs_fat.h"
#include "oodiskio.h"

#if DRV_USE_SDIO

#define BLOCK_SIZE  512
#define TRY_COUNT   10

static uint32_t sd_rca;

int my_vfs_fat_read (BYTE *buff, UINT sector, UINT count)
{
    DRESULT res;
	int ret = -1, i;
	int buflen = BLOCK_SIZE*count;
    BYTE *rdbuff = buff;

	if (((u32)buff)&0x3) /*non aligned 4*/
	{
	    rdbuff = tls_mem_alloc(buflen);
		if (rdbuff == NULL)
		{
		    printf("%s-%d: err\r\n", __func__, __LINE__);
			return RES_ERROR;
		}
	}

    //printf("%s-%d: %d\r\n", __func__, __LINE__, count);
	for( i=0; i<TRY_COUNT; i++ )
	{   
	    if(count == 1)
	    {
            //ret = wm_sd_card_block_read(sd_rca, sector, (char *)rdbuff);
            if (SDCardInfo.CardType == CardType_SDHC)
			{
				ret = wm_sd_card_block_read(sd_rca, sector, (char *)rdbuff);
			}
            else if ((SDCardInfo.CardType == CardType_SDSC) || (SDCardInfo.CardType == CardType_SD))
			{
				ret = wm_sd_card_block_read(sd_rca, sector * BLOCK_SIZE, (char *)rdbuff);
			}
        }
        else if(count > 1)
        {
		    //ret = wm_sd_card_blocks_read(sd_rca, sector, (char *)rdbuff, buflen);
		    if (SDCardInfo.CardType == CardType_SDHC)
			{
				ret = wm_sd_card_blocks_read(sd_rca, sector, (char *)rdbuff, buflen);
			}
            else if ((SDCardInfo.CardType == CardType_SDSC) || (SDCardInfo.CardType == CardType_SD))
			{
				for (int j = 0; j < count; j++)
				{
					ret = wm_sd_card_blocks_read(sd_rca, sector + j* BLOCK_SIZE, (char *)rdbuff, BLOCK_SIZE);
				}
			}
        }
		if( ret == 0 ) 
			break;
	}

    if(rdbuff != buff)
    {
        if(ret == 0)
        {
            memcpy(buff, rdbuff, buflen);
        }
        tls_mem_free(rdbuff);
    }

    if (ret)
		res = RES_ERROR;
	else
		res = RES_OK;

	return res;
}

int my_vfs_fat_write (const BYTE *buff, UINT sector, UINT count)
{
    DRESULT res;
	int ret = -1, i;
	int buflen = BLOCK_SIZE*count;
    BYTE *wrbuff = (BYTE *)buff;

	if (((u32)buff)&0x3)
	{
	    wrbuff = tls_mem_alloc(buflen);
		if (wrbuff == NULL) /*non aligned 4*/
		{
		    printf("%s-%d: err\r\n", __func__, __LINE__);
			return RES_ERROR;
		}
        memcpy(wrbuff, buff, buflen);
	}
	
	for( i = 0; i < TRY_COUNT; i++ )
	{
	    if(count == 1)
	    {
            //ret = wm_sd_card_block_write(sd_rca, sector, (char *)wrbuff);
            if (SDCardInfo.CardType == CardType_SDHC)
			{
				ret = wm_sd_card_block_write(sd_rca, sector, (char *)wrbuff);
			}
            else if ((SDCardInfo.CardType == CardType_SDSC) || (SDCardInfo.CardType == CardType_SD))
			{
				ret = wm_sd_card_block_write(sd_rca, sector * BLOCK_SIZE, (char *)wrbuff);
			}
        }
        else if(count > 1)
	    {
		    //ret = wm_sd_card_blocks_write(sd_rca, sector, (char *)wrbuff, buflen);
		    if (SDCardInfo.CardType == CardType_SDHC)
			{
				ret = wm_sd_card_blocks_write(sd_rca, sector, (char *)wrbuff, buflen);
			}
            else if ((SDCardInfo.CardType == CardType_SDSC) || (SDCardInfo.CardType == CardType_SD))
			{
				for (int j = 0; j < count; j++)
				{
					ret = wm_sd_card_blocks_write(sd_rca, sector + j* BLOCK_SIZE, (char *)wrbuff, BLOCK_SIZE);
				}
			}
	    }
		if( ret == 0 ) 
		{
			break;
		}
	}

    if(wrbuff != buff)
    {
        tls_mem_free(wrbuff);
    }

    if (ret)
		res = RES_ERROR;
	else
		res = RES_OK;

	return res;
}

int my_vfs_fat_ioctl(BYTE cmd, void *buff)
{
	//DRESULT res;
	//int result;

	switch (cmd) {
	        case CTRL_SYNC:
                return RES_OK;
			case GET_BLOCK_SIZE:
				*(DWORD *)buff = SDCardInfo.CardBlockSize;
				return RES_OK;
			case GET_SECTOR_SIZE:
				*(DWORD *)buff = BLOCK_SIZE;
				return RES_OK;
			case GET_SECTOR_COUNT:
				*(DWORD *)buff = SDCardInfo.CardCapacity / BLOCK_SIZE;
				return RES_OK;
			case MMC_GET_CSD:
				//SD_GetCSD(buff);
				//*(UINT *)buff = SDCardInfo.CSDVer;
                printf("%s-%d\n", __func__, __LINE__);
				return RES_OK;
			case MMC_GET_CID:
				//SD_GetCID(buff);
				printf("%s-%d\n", __func__, __LINE__);
				return RES_OK;
			case MMC_GET_TYPE:
			    printf("%s-%d\n", __func__, __LINE__);
				*(UINT *)buff = SDCardInfo.CardType;
				return RES_OK;
		    case IOCTL_INIT:
		    case IOCTL_STATUS:
                if (my_sd_inited)
                {
                    *(BYTE *)buff = 0;
		            return RES_OK;
		        }
		        else
		        {
                    *(BYTE *)buff = STA_NOINIT;
		            return RES_NOTRDY;
		        }
		}

    //printf("vfs_fat ioctl, cmd = %d\r\n", cmd);
	return RES_PARERR;
}

//0-success
u8 SDIO_SD_Init(void)
{
    int ret;

    wm_sdio_host_config(0);

	ret= sdh_card_init(&sd_rca);
	if(ret)
		goto end;
	ret = wm_sd_card_set_bus_width(sd_rca, 2);
	if(ret)
		goto end;
	ret = wm_sd_card_set_blocklen(BLOCK_SIZE); //512
	if(ret)
		goto end;
end:
	return ret;
}

void init_sdio_sd_mode2()
{
    tls_sys_clk sysclk;	

	tls_sys_clk_get(&sysclk);
	SDIO_HOST->MMC_CARDSEL = 0xC0 | (sysclk.cpuclk / 2 - 1);//0xd3; //enable module, enable mmcclk
	//SDIO_HOST->MMC_CTL = 0x13;//0xC3; //4bits, low speed, 1/4 divider, auto transfer, mmc mode.
	SDIO_HOST->MMC_INT_MASK = 0x100; //unmask sdio data interrupt.
	SDIO_HOST->MMC_CRCCTL = 0xC0; //
	SDIO_HOST->MMC_TIMEOUTCNT = 0xff;
	SDIO_HOST->MMC_IO_MBCTL |= 0xf0;

	SDIO_HOST->MMC_CTL = 0xD3;

    //bus_width: 0:1bit; 2:4bits
	SDIO_HOST->MMC_CTL |= (1 << 7);
}
#endif
