#ifndef __MY_VFS_FAT_H__
#define __MY_VFS_FAT_H__

#include "ooff.h"

#define DRV_USE_SDIO    0//0-spi,1-sdio

// these are the values for fs_user_mount_t.flags
#define FSUSER_NATIVE           (0x0001) // readblocks[2]/writeblocks[2] contain native func
#define FSUSER_FREE_OBJ         (0x0002) // fs_user_mount_t obj should be freed on umount
#define FSUSER_HAVE_IOCTL       (0x0004) // new protocol with ioctl
#define FSUSER_NO_FILESYSTEM    (0x0008) // the block device has no filesystem on it

typedef struct _fs_user_mount_t {
    uint16_t flags;
    int (*readblocks)(uint8_t*, uint32_t, uint32_t);
    int (*writeblocks)(const uint8_t*, uint32_t, uint32_t);
    int (*ioctl)(const uint8_t, void*);
    FATFS fatfs;
} fs_user_mount_t;

int my_vfs_fat_init(void);

fs_user_mount_t * my_vfs_fat_get_ctx(void);

void my_vfs_fat_deinit(void);

extern BYTE my_sd_inited;

#endif /* __MY_VFS_FAT_H__ */
