#include "wm_include.h"

#include "ooff.h"
#include "oodiskio.h"
#include "spi_sd_driver.h"
#include "my_vfs_fat.h"

#include "wm_sdio_host.h"
#include "sdio_sd_driver.h"

#define VFS_FAT_FS_BLOCK_SIZE         (4096)
#define VFS_FAT_FS_SECTOR_SIZE        (FF_MAX_SS)

#define MY_VFS_FAT_DBG printf

BYTE my_sd_inited = 0;
static fs_user_mount_t *my_sd_vfs_fat = NULL;

#if !DRV_USE_SDIO
static int my_vfs_fat_read (BYTE *buff, UINT sector, UINT count)
{
    DRESULT res;
	int result;

	if (count > 1)
		result = SD_ReadMultiBlock(sector, buff, count);
	else
		result = SD_ReadSingleBlock(sector, buff);

    if (result)
		res = RES_ERROR;
	else
		res = RES_OK;

	return res;
}

static int my_vfs_fat_write (const BYTE *buff, UINT sector, UINT count)
{
    DRESULT res;
	int result;

	if (count > 1)
		result = SD_WriteMultiBlock(sector, buff, count);
	else
		result = SD_WriteSingleBlock(sector, buff);

	// translate the reslut code here
	if (result)
		res = RES_ERROR;
	else
		res = RES_OK;

	return res;
}

static int my_vfs_fat_ioctl(BYTE cmd, void *buff)
{
	//DRESULT res;
	//int result;

	switch (cmd) {
	        case CTRL_SYNC:
                return RES_OK;
			case GET_BLOCK_SIZE:
				*(DWORD *)buff = VFS_FAT_FS_BLOCK_SIZE;
				return RES_OK;
			case GET_SECTOR_SIZE:
				*(DWORD *)buff = VFS_FAT_FS_SECTOR_SIZE;
				return RES_OK;
			case GET_SECTOR_COUNT:
				*(DWORD *)buff = SD_GetCapacity() / VFS_FAT_FS_SECTOR_SIZE;
				return RES_OK;
			case MMC_GET_CSD:
				SD_GetCSD(buff);
				return RES_OK;
			case MMC_GET_CID:
				SD_GetCID(buff);
				return RES_OK;
			case MMC_GET_TYPE:
				*(UINT *)buff = SD_GetCardType();
				return RES_OK;
		    case IOCTL_INIT:
		    case IOCTL_STATUS:
                if (my_sd_inited)
                {
                    *(BYTE *)buff = 0;
		            return RES_OK;
		        }
		        else
		        {
                    *(BYTE *)buff = STA_NOINIT;
		            return RES_NOTRDY;
		        }
		}

    //printf("vfs_fat ioctl, cmd = %d\r\n", cmd);
	return RES_PARERR;
}
#endif

int my_vfs_fat_init(void)
{
    // Initialise the local flash filesystem.
#if DRV_USE_SDIO
    if (SDIO_SD_Init()) {
#else
    if (SD_Init()) {
#endif
        MY_VFS_FAT_DBG("failed to init sdcard\r\n");
        return -1;
    }
    my_sd_inited = 1;

    // init the vfs object
    my_sd_vfs_fat = tls_mem_alloc(sizeof(*my_sd_vfs_fat));
    if (!my_sd_vfs_fat) {
        MY_VFS_FAT_DBG("failed to init filesystem\r\n");
        return -2;
    }

    fs_user_mount_t *vfs_fat = my_sd_vfs_fat;
    vfs_fat->flags = 0;

    vfs_fat->flags |= FSUSER_NATIVE | FSUSER_HAVE_IOCTL;
    vfs_fat->fatfs.drv = vfs_fat;
    vfs_fat->readblocks = my_vfs_fat_read; // native version
    vfs_fat->writeblocks = my_vfs_fat_write; // native version
    vfs_fat->ioctl = my_vfs_fat_ioctl;

    // Create it if needed, and mount in on /flash.
    FRESULT res = f_mount(&vfs_fat->fatfs);
    if (res == FR_NO_FILESYSTEM) {
        // no filesystem, so create a fresh one
        MY_VFS_FAT_DBG("create filesystem\r\n");
        uint8_t working_buf[FF_MAX_SS];
        res = f_mkfs(&vfs_fat->fatfs, FM_FAT, 0, working_buf, sizeof(working_buf));
        if (res == FR_OK) {
            // success creating fresh LFS
        } else {
            MY_VFS_FAT_DBG("failed to create filesystem, err = %d\r\n", res);
            return -3;
        }

        // set label
        //f_setlabel(&vfs_fat->fatfs, "my_fs");
    } else if (res == FR_OK) {
        // mount sucessful

    } else {
    //fail:
        MY_VFS_FAT_DBG("failed to mount flash, err = %d\r\n", res);
        return -4;
    }

    res = f_chdir(&vfs_fat->fatfs, "/");
    printf("my_vfs_fat_init res = %d\r\n", res);

    return 0;
}

fs_user_mount_t * my_vfs_fat_get_ctx(void)
{
    return my_sd_vfs_fat;
}

void my_vfs_fat_deinit(void)
{
    if (my_sd_vfs_fat)
    {
        tls_mem_free(my_sd_vfs_fat);
        my_sd_vfs_fat = NULL;
    }
}
