/*

            PB_13 ----------S1----------S2----------S3----------S4
            SCL             |           |           |           |
 _____                      |           |           |           |
|     |     PB_14 ----------S5----------S6----------S7----------S8
|   1 |     SDA             |           |           |           |
|   2 |                     |           |           |           |
|   3 |     PB_15 ----------S9----------S10---------S11---------S12
|   4 |     SPI_CS          |           |           |           |
|   5 |                     |           |           |           |
|   6 |     PB_16 ----------S13---------S14---------S15---------S16
|   7 |     SPI_CK          |           |           |           |
|   8 |                     |           |           |           |
|_____|                     |           |           |           |
                            PB_17       PB_18       PB_19       PB_20
                            SPI_DI      SPI_DO      A1          A2


*/

#define         MATRIX_KEY_TASK_PRIO             52
#define         MATRIX_KEY_TASK_STK_SIZE         256
static OS_STK matrix_key_task_stk[MATRIX_KEY_TASK_STK_SIZE];

#define GPIOB_DATA_EN_ADDR                      (HR_GPIO_DATA_EN + TLS_IO_AB_OFFSET)
#define GPIOB_DATA_ADDR                         (HR_GPIO_DATA + TLS_IO_AB_OFFSET)

#define GPIO_USE_PROTECT                        1

static void time_delay_ms(uint32_t ms)
{
	tls_os_time_delay(ms / (1000 / HZ));
}

static void matrix_key_init(void)
{
    /* row io */
    tls_gpio_cfg(WM_IO_PB_13, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);
    tls_gpio_cfg(WM_IO_PB_14, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);
    tls_gpio_cfg(WM_IO_PB_15, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);
    tls_gpio_cfg(WM_IO_PB_16, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);

    /* column io */
    tls_gpio_cfg(WM_IO_PB_17, WM_GPIO_DIR_INPUT, WM_GPIO_ATTR_PULLHIGH);
    tls_gpio_cfg(WM_IO_PB_18, WM_GPIO_DIR_INPUT, WM_GPIO_ATTR_PULLHIGH);
    tls_gpio_cfg(WM_IO_PB_19, WM_GPIO_DIR_INPUT, WM_GPIO_ATTR_PULLHIGH);
    tls_gpio_cfg(WM_IO_PB_20, WM_GPIO_DIR_INPUT, WM_GPIO_ATTR_PULLHIGH);
}

void matrix_key_press(int no)
{
    printf("key S%d\r\n", no);
}

static void matrix_key_task(void *data)
{
    u32 reg;
	u32	reg_en;

    matrix_key_init();

    for( ; ; ) 
	{
	    /* set all row low */
#if GPIO_USE_PROTECT
		reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E000);
#endif
	    reg = tls_reg_read32(GPIOB_DATA_ADDR);
	    tls_reg_write32(GPIOB_DATA_ADDR, reg & 0xFFFE1FFF); /* write low */
#if GPIO_USE_PROTECT
	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
#endif

	    time_delay_ms(1);

	    /* read column */
#if GPIO_USE_PROTECT
	    reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
    	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
#endif
    	reg = tls_reg_read32(GPIOB_DATA_ADDR);
#if GPIO_USE_PROTECT
    	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
#endif

    	if ((reg & 0x1E0000) != 0x1E0000)
    	{
    	    /* avoid key jitter */
            time_delay_ms(20);

            /* read column again */
#if GPIO_USE_PROTECT
    	    reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
        	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
#endif
        	reg = tls_reg_read32(GPIOB_DATA_ADDR);
#if GPIO_USE_PROTECT
        	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
#endif

        	if ((reg & 0x1E0000) != 0x1E0000) /* valid key */
    	    {
    	        /* check first row */

    	        /* set second & third & fourth row high */
#if GPIO_USE_PROTECT
    	        reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E000);
#endif
        	    reg = tls_reg_read32(GPIOB_DATA_ADDR);
        	    tls_reg_write32(GPIOB_DATA_ADDR, (reg & 0xFFFE1FFF) | 0x1C000); /* write high */
#if GPIO_USE_PROTECT
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
#endif

        	    time_delay_ms(1);

                /* read column */
#if GPIO_USE_PROTECT
                reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
#endif
            	reg = tls_reg_read32(GPIOB_DATA_ADDR);
#if GPIO_USE_PROTECT
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
#endif

            	if ((reg & 0x1E0000) == 0x1C0000)
            	{
                    matrix_key_press(1);
            	}
            	if ((reg & 0x1E0000) == 0x1A0000)
            	{
                    matrix_key_press(2);
            	}
            	if ((reg & 0x1E0000) == 0x160000)
            	{
                    matrix_key_press(3);
            	}
            	if ((reg & 0x1E0000) == 0xE0000)
            	{
                    matrix_key_press(4);
            	}



                /* check second row */

                /* set first & third & fourth row high */
#if GPIO_USE_PROTECT
    	        reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E000);
#endif
        	    reg = tls_reg_read32(GPIOB_DATA_ADDR);
        	    tls_reg_write32(GPIOB_DATA_ADDR, (reg & 0xFFFE1FFF) | 0x1A000); /* write high */
#if GPIO_USE_PROTECT
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
#endif

        	    time_delay_ms(1);

                /* read column */
#if GPIO_USE_PROTECT
                reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
#endif
            	reg = tls_reg_read32(GPIOB_DATA_ADDR);
#if GPIO_USE_PROTECT
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
#endif

            	if ((reg & 0x1E0000) == 0x1C0000)
            	{
                    matrix_key_press(5);
            	}
            	if ((reg & 0x1E0000) == 0x1A0000)
            	{
                    matrix_key_press(6);
            	}
            	if ((reg & 0x1E0000) == 0x160000)
            	{
                    matrix_key_press(7);
            	}
            	if ((reg & 0x1E0000) == 0xE0000)
            	{
                    matrix_key_press(8);
            	}



            	/* check third row */

                /* set first & second & fourth row high */
#if GPIO_USE_PROTECT
    	        reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E000);
#endif
        	    reg = tls_reg_read32(GPIOB_DATA_ADDR);
        	    tls_reg_write32(GPIOB_DATA_ADDR, (reg & 0xFFFE1FFF) | 0x16000); /* write high */
#if GPIO_USE_PROTECT
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
#endif

        	    time_delay_ms(1);

                /* read column */
#if GPIO_USE_PROTECT
                reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
#endif
            	reg = tls_reg_read32(GPIOB_DATA_ADDR);
#if GPIO_USE_PROTECT
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
#endif

            	if ((reg & 0x1E0000) == 0x1C0000)
            	{
                    matrix_key_press(9);
            	}
            	if ((reg & 0x1E0000) == 0x1A0000)
            	{
                    matrix_key_press(10);
            	}
            	if ((reg & 0x1E0000) == 0x160000)
            	{
                    matrix_key_press(11);
            	}
            	if ((reg & 0x1E0000) == 0xE0000)
            	{
                    matrix_key_press(12);
            	}



            	/* check fourth row */

                /* set first & second & third row high */
#if GPIO_USE_PROTECT
    	        reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E000);
#endif
        	    reg = tls_reg_read32(GPIOB_DATA_ADDR);
        	    tls_reg_write32(GPIOB_DATA_ADDR, (reg & 0xFFFE1FFF) | 0xE000); /* write high */
#if GPIO_USE_PROTECT
        	    tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
#endif

        	    time_delay_ms(1);

                /* read column */
#if GPIO_USE_PROTECT
                reg_en = tls_reg_read32(GPIOB_DATA_EN_ADDR);
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en | 0x1E0000);
#endif
            	reg = tls_reg_read32(GPIOB_DATA_ADDR);
#if GPIO_USE_PROTECT
            	tls_reg_write32(GPIOB_DATA_EN_ADDR, reg_en);
#endif

            	if ((reg & 0x1E0000) == 0x1C0000)
            	{
                    matrix_key_press(13);
            	}
            	if ((reg & 0x1E0000) == 0x1A0000)
            	{
                    matrix_key_press(14);
            	}
            	if ((reg & 0x1E0000) == 0x160000)
            	{
                    matrix_key_press(15);
            	}
            	if ((reg & 0x1E0000) == 0xE0000)
            	{
                    matrix_key_press(16);
            	}
    	    }
    	}
        else
        {
    	    time_delay_ms(2);
    	}
	}
}

void matrix_task_init(void)
{
    tls_os_task_create(NULL, NULL, matrix_key_task,
                   (void *)0, (void *)matrix_key_task_stk,
                   MATRIX_KEY_TASK_STK_SIZE * sizeof(u32),
                   MATRIX_KEY_TASK_PRIO, 0);
}
