#include <stdio.h>
#include "wm_include.h"
#include "wm_io.h"


#define FC_JOY_PAD_CLOCK_IO     WM_IO_PB_08
#define FC_JOY_PAD_LATCH_IO     WM_IO_PB_09
#define FC_JOY_PAD_DATA_IO      WM_IO_PB_10

/*
          clock  latch  data
      .     .      .      .    .

         .      .     .     .
               gnd        vcc-5v

*/

/*
հFCΪNTSCʽΪ60Hz
ŷԼйķƻΪPAL-Dʽ50Hz
۰ԼĳЩPAL-60ʽ60Hz
˵ǻ60Hzͣ50Hz60Hzʱе졣

ϷϷÿ16.67ms60Hz,1/60룩ȡһֱ״̬ͨʵ֡

һLATCHź壬ĿΪ12usֱʼ鰴״̬

LATCH巢ͺ6usCLOCKPULSE߿ʼΪ12usռձ50%źţһ8Ρ
ÿεضDATA߲DATAǷڸλñ͡
˳ǹ̶ģϷʱԱ̶ģ˳ΪA,B,SEL,START,ҡ
*/

const static char *fc_joy_pad_key_str[8] = {"Right", "Left", "Down", "Up", "Start", "Select", "B", "A"};

static void fc_joy_pad_delay_us(uint16_t t)
{
	//while(t--);
    extern void delay_us();
    delay_us(t);
}

static void fc_joy_pad_delay_ms(uint16_t t)
{
	tls_os_time_delay(t / (1000 / HZ));
}

void fc_joy_pad_init(void)
{
    tls_gpio_cfg(FC_JOY_PAD_CLOCK_IO, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_PULLHIGH);
    tls_gpio_cfg(FC_JOY_PAD_LATCH_IO, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);

    tls_gpio_write(FC_JOY_PAD_CLOCK_IO, 0);
    tls_gpio_write(FC_JOY_PAD_LATCH_IO, 0);

    tls_gpio_cfg(FC_JOY_PAD_DATA_IO,  WM_GPIO_DIR_INPUT,  WM_GPIO_ATTR_PULLHIGH);
}

//[7]:right
//[6]:left
//[5]:down
//[4]:up
//[3]:Start
//[2]:Select
//[1]:B
//[0]:A
uint8_t fc_joy_pad_read(void)
{
    uint8_t temp = 0;
 	uint8_t i;

    tls_gpio_write(FC_JOY_PAD_LATCH_IO, 1);
    fc_joy_pad_delay_us(12);
    tls_gpio_write(FC_JOY_PAD_LATCH_IO, 0);
    fc_joy_pad_delay_us(6);

    for (i = 0; i < 8; i++)
	{
		temp >>= 1;	 

		if (tls_gpio_read(FC_JOY_PAD_DATA_IO) == 0)
		    temp |= 0x80;

		tls_gpio_write(FC_JOY_PAD_CLOCK_IO, 1);
		fc_joy_pad_delay_us(6);

		tls_gpio_write(FC_JOY_PAD_CLOCK_IO, 0);	
		fc_joy_pad_delay_us(6);
	}

	return temp;
}

#define FC_JOY_PAD_TASK_SIZE        256
#define FC_JOY_PAD_TASK_PRIO	    35

static OS_STK fc_joy_pad_task_stk[FC_JOY_PAD_TASK_SIZE];

static void fc_joy_pad_task(void)
{
    uint8_t i;
    uint8_t key = 0;

    fc_joy_pad_init();

    while (1)
    {
        key = fc_joy_pad_read();
        if (key)
        {
            printf("key = %x\n", key);
			for (i = 0; i < 8; i++)
			{
				if (key & (0X80 >> i))
				{
					printf("key name: %s\n", fc_joy_pad_key_str[i]);
				}
			}
        }

        fc_joy_pad_delay_ms(20);
    }
}

void fc_joy_pad_task_init(void)
{
    tls_os_task_create(NULL, NULL,
                       ( void (*))fc_joy_pad_task,
                       NULL,
                       (void *)fc_joy_pad_task_stk,          /* task's stack start address */
                       FC_JOY_PAD_TASK_SIZE * sizeof(u32), /* task's stack size, unit:byte */
                       FC_JOY_PAD_TASK_PRIO,
                       0);
}

