#ifndef __YC_HASH_H__
#define __YC_HASH_H__

/***************************************************************
 *                  ϣӿ                             *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2014 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/

/*****************************************************************************************************************
                                                                                                                 *
yc_hash_head* yc_hash_create(IN ulong ulNum, IN yc_hash_key_pf pfHashKey);                                       *
void yc_hash_destroy(IN yc_hash_head *pstHashTbl);                                                               *
yc_hash_node* yc_hash_find(IN const yc_hash_head *pstHashTbl, IN const void *pKey, IN yc_hash_cmp_pf pfHashCmp); *
void yc_hash_add(IN yc_hash_head *pstHashTbl, IN const void *pKey, IN yc_hash_node *pstHashNode);                *
void yc_hash_del(IN yc_hash_node *pstHashNode);                                                                  *
                                                                                                                 *
******************************************************************************************************************/

typedef struct hlist_node yc_hash_node;

/*****************************************************************************
   (Prototype)    : yc_hash_cmp_pf
 (Description)  : ϣұȽϻص
 (Input)        : pKey          ȽϵĹϣkey
                          pHashNode     ϣڵ
 (Output)       : (None)
   ֵ(Return Value) : int           0       ҵϣڵ
                                       !0       ϣڵ㲻

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
typedef int (*yc_hash_cmp_pf)(IN const void *pKey, IN const yc_hash_node *pHashNode);

/*****************************************************************************
   (Prototype)    : yc_hash_key_pf
 (Description)  : ϣұȽϻص
 (Input)        : pKey          Ĺϣkey
 (Output)       : (None)
   ֵ(Return Value) : ulong         ϣ

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
typedef ulong (*yc_hash_key_pf)(IN const void *pKey);

typedef struct hlist_head yc_hashbkt_head;

typedef struct tag_HashTableHead{
    ulong  ulNum;
    yc_hash_key_pf    pfHashKey;
    yc_hashbkt_head **pstHashBacket;
}yc_hash_head;


/*****************************************************************************
   (Prototype)    : yc_hash_entry
 (Description)  : ȡϣڵӵʵݽṹָ
 (Input)        : ptr          ϣڵָ
                          type         ʵݽṹ
                          member       ϣڵʵݽṹе
 (Output)       : (None)
   ֵ(Return Value) : void*        ʵݽṹָ

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_entry(ptr, type, member)   container_of(ptr, type, member)

/*****************************************************************************
   (Prototype)    : yc_hash_get_index
 (Description)  : ݹϣkeyȡϣ
 (Input)        : head         ϣͷ
                          key          ϣkey
 (Output)       : (None)
   ֵ(Return Value) : ulong        ϣֵ

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_get_index(head, key)       head->pfHashKey(key)

/*****************************************************************************
   (Prototype)    : yc_hash_is_valid
 (Description)  : ϣǷЧ
 (Input)        : head         ϣͷ
                          index        ϣ
 (Output)       : (None)
   ֵ(Return Value) : bool_t       true     ϣЧ
                                       false    ϣЧ

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_is_valid(head, index)      (((index) < (head->ulNum)) ? true : false)

/*****************************************************************************
   (Prototype)    : yc_hash_get_backet
 (Description)  : ݹϣkeyȡϣͰָ
 (Input)        : head         ϣͷ
                          key          ϣkey
 (Output)       : (None)
   ֵ(Return Value) : yc_hashbkt_head*     !NULL    ϣͰָ
                                                NULL    ϣͰ

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_get_backet(head, key)      head->pstHashBacket[head->pfHashKey(key)]

/*****************************************************************************
   (Prototype)    : yc_hash_get_first_entry
 (Description)  : ӹϣлȡһݣʵݽṹ
 (Input)        : head         ϣͷ
                          key          ϣkey
                          type         ʵݽṹ
                          member       ϣڵʵݽṹе
 (Output)       : (None)
   ֵ(Return Value) : void*       !NULL    ʵݽṹָ
                                       NULL    ʵݽṹָ벻

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_get_first_entry(head, key, type, member) \
            yc_hash_entry(yc_hash_get_backet(head, key)->first, type, member)

/*****************************************************************************
   (Prototype)    : yc_hash_foreach_hash_table_4backet
 (Description)  : ϣеÿϣͰ
 (Input)        : head         ϣͷ
 (Output)       : index        ϣ
                          hashbkt      ϣͰָ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_foreach_hash_table_4backet(head, index, hashbkt) \
        	for (index = 0, hashbkt = head->pstHashBacket[index];\
             	 index < head->ulNum; index++, hashbkt = head->pstHashBacket[index])

/*****************************************************************************
   (Prototype)    : yc_hash_foreach_hash_table
 (Description)  : ϣ
 (Input)        : head         ϣͷ
 (Output)       : index        ϣ
                          hashbkt      ϣͰָ
                          pos          ϣڵָ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_foreach_hash_table(head, index, hashbkt, pos) \
        	yc_hash_foreach_hash_table_4backet(head, index, hashbkt)\
            	hlist_for_each(pos, hashbkt)

/*****************************************************************************
   (Prototype)    : yc_hash_foreach_hash_backet
 (Description)  : ùϣͰ
 (Input)        : head         ϣͰָ
 (Output)       : pos          ϣڵָ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_foreach_hash_backet(head, pos)  \
        	hlist_for_each(pos, head)

/*****************************************************************************
   (Prototype)    : yc_hash_foreach_hash_backet_safe
 (Description)  : ȫùϣͰҪɾϣڵ
 (Input)        : head         ϣͰָ
 (Output)       : pos          ϣڵָ
                          next         ָһϣڵ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_foreach_hash_backet_safe(head, pos, next)   \
        	hlist_for_each_safe(pos, next, head)

/*****************************************************************************
   (Prototype)    : yc_hash_foreach_hash_table_entry
 (Description)  : ùϣȡÿһʵݽṹָ
 (Input)        : head         ϣָ
 (Output)       : index        ϣ
                          hashbkt      ϣͰָ
                          entry        ʵݽṹָ
                          member       ʵݽṹеĹϣڵ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_foreach_hash_table_entry(head, index, hashbkt, entry, member) \
        	yc_hash_foreach_hash_table_4backet(head, index, hashbkt)\
        		hlist_for_each_entry(entry, hashbkt, member)

/*****************************************************************************
   (Prototype)    : yc_hash_foreach_hash_table_entry
 (Description)  : ȫùϣȡÿһʵݽṹָ룬Ҫɾڵ
 (Input)        : head         ϣָ
 (Output)       : index        ϣ
                          hashbkt      ϣͰָ
                          next         ָһʵݽṹ
                          entry        ʵݽṹָ
                          member       ʵݽṹеĹϣڵ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_foreach_hash_table_entry_safe(head, index, hashbkt, next, entry, member) \
        	yc_hash_foreach_hash_table_4backet(head, index, hashbkt)\
            	hlist_for_each_entry_safe(entry, next, hashbkt, member)

/*****************************************************************************
   (Prototype)    : yc_hash_foreach_hash_backet_entry
 (Description)  : ùϣͰȡÿһʵݽṹָ
 (Input)        : head         ϣͰָ
 (Output)       : entry        ʵݽṹָ
                          member       ʵݽṹеĹϣڵ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_foreach_hash_backet_entry(head, entry, member)    \
        	hlist_for_each_entry(entry, head, member)

/*****************************************************************************
   (Prototype)    : yc_hash_foreach_hash_backet_entry_safe
 (Description)  : ȫùϣͰȡÿһʵݽṹָ룬Ҫɾڵ
 (Input)        : head         ϣͰָ
 (Output)       : next         ָһʵݽṹ
                          entry        ʵݽṹָ
                          member       ʵݽṹеĹϣڵ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_hash_foreach_hash_backet_entry_safe(head, next, entry, member) \
        	hlist_for_each_entry_safe(entry, next, head, member)


/*****************************************************************************
   (Prototype)    : __yc_hash_foreach_hash_table
 (Description)  : ϣ
                          עúͬһֻʹһ
 (Input)        : head         ϣͷ
 (Output)       : pos          ϣڵָ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define __yc_hash_foreach_hash_table(head, pos) \
            ulong __ulTmpIndex1 = 0;\
            yc_hashbkt_head *__pstTmpHashbkt1 = NULL;\
            yc_hash_foreach_hash_table(head, __ulTmpIndex1, __pstTmpHashbkt1, pos)

/*****************************************************************************
   (Prototype)    : __yc_hash_foreach_hash_table_entry
 (Description)  : ùϣȡÿһʵݽṹָ룬
                          עúͬһֻʹһ
 (Input)        : head         ϣָ
 (Output)       : entry        ʵݽṹָ
                          member       ʵݽṹеĹϣڵ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define __yc_hash_foreach_hash_table_entry(head, entry, member) \
            ulong __ulTmpIndex2 = 0;\
            yc_hashbkt_head *__pstTmpHashbkt2 = NULL;\
            yc_hash_foreach_hash_table_entry(head, __ulTmpIndex2, __pstTmpHashbkt2, entry, member)

/*****************************************************************************
   (Prototype)    : __yc_hash_foreach_hash_table_entry_safe
 (Description)  : ȫùϣȡÿһʵݽṹָ룬
                          Ҫɾڵ㣬עúͬһֻʹһ
 (Input)        : head         ϣָ
 (Output)       : entry        ʵݽṹָ
                          member       ʵݽṹеĹϣڵ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define __yc_hash_foreach_hash_table_entry_safe(head, entry, member) \
            ulong __ulTmpIndex3 = 0;\
            yc_hashbkt_head *__pstTmpHashbkt3 = NULL;\
            yc_hash_node *__pstTmpNextNode3 = NULL;\
            yc_hash_foreach_hash_table_entry_safe(head, __ulTmpIndex3, __pstTmpHashbkt3, __pstTmpNextNode3, entry, member)

/*****************************************************************************
   (Prototype)    : __yc_hash_foreach_hash_backet_entry_safe
 (Description)  : ȫùϣͰȡÿһʵݽṹָ룬
                          Ҫɾڵ㣬עúͬһֻʹһ
 (Input)        : head         ϣͰָ
 (Output)       : entry        ʵݽṹָ
                          member       ʵݽṹеĹϣڵ
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define __yc_hash_foreach_hash_backet_entry_safe(head, entry, member) \
            yc_hash_node *__pstTmpNextNode4 = NULL;\
            yc_hash_foreach_hash_backet_entry_safe(head, __pstTmpNextNode4, entry, member)


/*****************************************************************************
   (Prototype)    : yc_hash_create
 (Description)  : һµĹϣҪͷ
 (Input)        : ulNum         ϣС
                          pfHashKey     ϣ㺯Ϊ
 (Output)       : (None)
   ֵ(Return Value) : yc_hash_head*    !NULL    ɹ(success)
                                            NULL    ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
static inline yc_hash_head* yc_hash_create(IN ulong ulNum,
                                           IN yc_hash_key_pf pfHashKey)
#ifdef KERNEL
{
	ulong ulCnt4s = 0;
	ulong ulCnt4f = 0;
	yc_hash_head     *pstHashHead   = NULL;
	yc_hashbkt_head **pstHashBacket = NULL;

	pstHashHead = kmalloc(sizeof(yc_hash_head), GFP_KERNEL);
	if (NULL != pstHashHead)
	{
		pstHashBacket = kmalloc(sizeof(yc_hashbkt_head*) * ulNum, GFP_KERNEL);
		if (NULL != pstHashBacket)
		{
			memset(pstHashBacket, 0, sizeof(yc_hashbkt_head) * ulNum);
			for (ulCnt4s = 0; ulCnt4s < ulNum; ulCnt4s++)
			{
				pstHashBacket[ulCnt4s] = kmalloc(sizeof(yc_hashbkt_head), GFP_KERNEL);
				if (NULL == pstHashBacket[ulCnt4s])
				{
					break;
				}
				INIT_HLIST_HEAD(pstHashBacket[ulCnt4s]);
			}
		}
	}

    if (ulCnt4s == ulNum)
    {
        memset(pstHashHead, 0, sizeof(yc_hash_head));

		pstHashHead->ulNum         = ulNum;
		pstHashHead->pfHashKey     = pfHashKey;
		pstHashHead->pstHashBacket = pstHashBacket;
    }
    else
    {
        ulCnt4f = ulCnt4s;
        for (ulCnt4s= 0; ulCnt4s < ulCnt4f; ulCnt4s++)
        {
            kfree(pstHashBacket[ulCnt4s]);
        }
        kfree(pstHashBacket);
        kfree(pstHashHead);
        pstHashHead = NULL;
    }

	return pstHashHead;
}
#else
{
	ulong ulCnt4s = 0;
	ulong ulCnt4f = 0;
	yc_hash_head     *pstHashHead   = NULL;
	yc_hashbkt_head **pstHashBacket = NULL;

	pstHashHead = yc_malloc(sizeof(yc_hash_head));
	if (NULL != pstHashHead)
	{
		pstHashBacket = yc_malloc(sizeof(yc_hashbkt_head*) * ulNum);
		if (NULL != pstHashBacket)
		{
			memset(pstHashBacket, 0, sizeof(yc_hashbkt_head) * ulNum);
			for (ulCnt4s = 0; ulCnt4s < ulNum; ulCnt4s++)
			{
				pstHashBacket[ulCnt4s] = yc_malloc(sizeof(yc_hashbkt_head));
				if (NULL == pstHashBacket[ulCnt4s])
				{
					break;
				}
				INIT_HLIST_HEAD(pstHashBacket[ulCnt4s]);
			}
		}
	}

    if (ulCnt4s == ulNum)
    {
        memset(pstHashHead, 0, sizeof(yc_hash_head));

		pstHashHead->ulNum         = ulNum;
		pstHashHead->pfHashKey     = pfHashKey;
		pstHashHead->pstHashBacket = pstHashBacket;
    }
    else
    {
        ulCnt4f = ulCnt4s;
        for (ulCnt4s= 0; ulCnt4s < ulCnt4f; ulCnt4s++)
        {
            yc_free(pstHashBacket[ulCnt4s]);
        }
        yc_free(pstHashBacket);
        yc_free(pstHashHead);
        pstHashHead = NULL;
    }

	return pstHashHead;
}
#endif

/*****************************************************************************
   (Prototype)    : yc_hash_destroy
 (Description)  : ٹϣͷhash_createڴ.
 (Input)        : pstHashTbl        ϣͷָ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
static inline void yc_hash_destroy(IN yc_hash_head *pstHashTbl)
#ifdef KERNEL
{
    ulong ulCount = 0;

    YC_DBGASSERT(NULL != pstHashTbl);

    for (ulCount = 0; ulCount < pstHashTbl->ulNum; ulCount++)
	{
	    kfree(pstHashTbl->pstHashBacket[ulCount]);
	}
	kfree(pstHashTbl->pstHashBacket);
	kfree(pstHashTbl);

	return;
}
#else
{
    ulong ulCount = 0;

    YC_DBGASSERT(NULL != pstHashTbl);

    for (ulCount = 0; ulCount < pstHashTbl->ulNum; ulCount++)
	{
	    yc_free(pstHashTbl->pstHashBacket[ulCount]);
	}
	yc_free(pstHashTbl->pstHashBacket);
	yc_free(pstHashTbl);

	return;
}
#endif

/*****************************************************************************
   (Prototype)    : yc_hash_find
 (Description)  : ҹϣڵ㣬
                          ϣÿδȽϺpkeyȽϣ
                          ȽϺ0򷵻ظùϣڵָ
 (Input)        : pstHashTbl        ϣͷָ
                          pKey              ϣkey
                          pfHashCmp         ȽϺ
 (Output)       : (None)
   ֵ(Return Value) : yc_hash_node*     NULL    ҵĹϣڵ
                                           !NULL    ϣڵ㲻

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
static inline yc_hash_node* yc_hash_find(IN const yc_hash_head *pstHashTbl,
                                         IN const void *pKey,
                                         IN yc_hash_cmp_pf pfHashCmp)
{
	int   iCmpResult = 0;
	ulong ulIndex 	 = 0;
	yc_hashbkt_head *pstHashbkt  = NULL;
	yc_hash_node 	*pstCurrNode = NULL;

    YC_DBGASSERT(NULL != pstHashTbl);
    YC_DBGASSERT(NULL != pKey);
    YC_DBGASSERT(NULL != pfHashCmp);

	yc_hash_foreach_hash_table(pstHashTbl, ulIndex, pstHashbkt, pstCurrNode)
	{
		iCmpResult = pfHashCmp(pKey, pstCurrNode);
		if (0 == iCmpResult)
		{
			return pstCurrNode;
		}
	}

	return NULL;
}

/*****************************************************************************
   (Prototype)    : yc_hash_add
 (Description)  : ϣpstHashNodeϣpstHashTbl
 (Input)        : pstHashTbl        ϣͷָ
                          pKey              ϣkey
                          pstHashNode       Ľڵ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
static inline void yc_hash_add(IN yc_hash_head *pstHashTbl,
                               IN const void *pKey,
                               IN yc_hash_node *pstHashNode)
{
	ulong ulIndex = 0;

    YC_DBGASSERT(NULL != pstHashTbl);
    YC_DBGASSERT(NULL != pKey);
    YC_DBGASSERT(NULL != pstHashNode);

	ulIndex = pstHashTbl->pfHashKey(pKey);
	hlist_add_head(pstHashNode, pstHashTbl->pstHashBacket[ulIndex]);

	return;
}

/*****************************************************************************
   (Prototype)    : yc_hash_del
 (Description)  : ӹϣժ
                          pstHashNodeӹϣժòͷpstHashNodeڴ
 (Input)        : pstHashNode       ժĽڵ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/7/6
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
static inline void yc_hash_del(IN yc_hash_node *pstHashNode)
{
    YC_DBGASSERT(NULL != pstHashNode);

	hlist_del(pstHashNode);

	return;
}

#endif /* __YC_HASH_H__ */

