#include "wm_include.h"

void UserMain(void)
{
	printf("\n user task \n");

	wm_spi_ck_config(WM_IO_PB_01);
    wm_spi_di_config(WM_IO_PB_03);
    wm_spi_do_config(WM_IO_PB_05);

    tls_spi_init();
    tls_spi_trans_type(SPI_DMA_TRANSFER);
    tls_spi_setup(TLS_SPI_MODE_3, TLS_SPI_CS_LOW, TLS_SPI_FCLK_MAX);

    tls_gpio_cfg(WM_IO_PB_04, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_PULLHIGH);/* cs */
    tls_gpio_write(WM_IO_PB_04, 1);

    tls_gpio_write(WM_IO_PB_04, 0);

    /* read id */
    u8 data = 0x90;
	tls_spi_write(&data, 1);
	data = 0x0;
	tls_spi_write(&data, 1);
	tls_spi_write(&data, 1);    
	tls_spi_write(&data, 1);

    u16 id = 0;
	tls_spi_read(&data, 1);
	id |= data << 8;

    tls_spi_read(&data, 1);
    id |= data;

    tls_gpio_write(WM_IO_PB_04, 1);

    if (0XEF13 == id) printf("EN25Q80\r\n");
    else if (0XEF14 == id) printf("EN25Q16\r\n");
    else if (0XEF15 == id) printf("EN25Q32\r\n");
    else if (0XEF16 == id) printf("EN25Q64\r\n");
    else if (0XEF17 == id) printf("EN25Q128\r\n");
    else printf("id = %x, unknown model\n", id);
}

