#ifndef __WIFI_MESH_H__
#define __WIFI_MESH_H__

#ifdef __cplusplus
extern "C"{
#endif /* __cplusplus */

#define WIFI_MESH_ERROR_NONE             0
#define WIFI_MESH_ERROR_HARD            -1
#define WIFI_MESH_ERROR_TIMEOUT         -7
#define WIFI_MESH_ERROR_NO_MEM          -8
#define WIFI_MESH_ERROR_NO_INIT         -9


#define WIFI_MESH_ID_LEN                16


#define WIFI_MESH_FLAGS_1               (1 << 0)


typedef enum {
    WIFI_MESH_STATUS_LEAF = 0, /* Ҷ豸 */
    WIFI_MESH_STATUS_ROOT      /* 豸 */
} wifi_mesh_status_e;

typedef enum {
    WIFI_MESH_STATE_IDLE = 0,            /* 豸״̬ */
    WIFI_MESH_STATE_PARENT_CONNECTED,    /* Ҷ豸: Ӹ豸 */
    WIFI_MESH_STATE_PARENT_DISCONNECTED, /* Ҷ豸: ѶϿ豸 */
    WIFI_MESH_STATE_CHILD_CONNECTED,     /* 豸: Ҷ豸 */
    WIFI_MESH_STATE_CHILD_DISCONNECTED   /* 豸: Ҷ豸ѶϿ */
} wifi_mesh_state_e;

typedef void (*wifi_mesh_recv_callback)(const u8 *src_mac, const u8 *data, u32 data_len);

typedef void (*wifi_mesh_event_callback)(wifi_mesh_state_e mesh_state, const u8 *mac);

typedef struct {
    u8 mesh_id[WIFI_MESH_ID_LEN]; /* ʶͬһmeshid */

    wifi_mesh_status_e mesh_status;
    u8 root_channel; /* Ǹڵֵ */

    wifi_mesh_recv_callback recv_callback;

    wifi_mesh_event_callback event_callback;

    u32 some_flags;
} wifi_mesh_cfg_s;

int wifi_mesh_init(wifi_mesh_cfg_s *config);

/* dst_macΪͬһmesh idй㲥ݣԱԿյ
          ΪΪָ豸Այ */
int wifi_mesh_send_data(const u8 *dst_mac, const u8 *data, u32 data_len);

void wifi_mesh_deinit(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __WIFI_MESH_H__ */

