#include "wm_include.h"
#include "wifi_mesh.h"
#include "tls_common.h"

#define MESH_DEMO_USE_ROOT            0

#define MESH_DEMO_TASK_PRIO          33
#define MESH_DEMO_STK_SIZE          256
#define MESH_DEMO_QUEUE_SIZE          4

#define MESH_DEMO_MSG_SEND_DATA     0x1

static OS_STK mesh_demo_task_stk[MESH_DEMO_STK_SIZE];
static tls_os_queue_t *mesh_demo_queue = NULL;

const static char *mesh_event_str[5] = {"idle", "parent_connected", "parent_disconnected", "child_connected", "child_disconnected"};

static u8 new_mac[6] = {0};
static u8 loop_send = 0;

static void data_recv_callback(const u8 *src_mac, const u8 *data, u32 data_len)
{
    printf("mesh recv %u data from "MACSTR": %s.\r\n", data_len, MAC2STR(src_mac), data);
}

static void event_callback(wifi_mesh_state_e mesh_state, const u8 *mac)
{
    printf("mesh event %s from "MACSTR".\r\n", mesh_event_str[mesh_state], MAC2STR(mac));

#if MESH_DEMO_USE_ROOT
    if (WIFI_MESH_STATE_CHILD_CONNECTED == mesh_state)
    {
        memcpy(new_mac, mac, 6);
        loop_send = 1;
        tls_os_queue_send(mesh_demo_queue, (void *)MESH_DEMO_MSG_SEND_DATA, 0);
    }
    else if (WIFI_MESH_STATE_CHILD_DISCONNECTED == mesh_state)
    {
        loop_send = 0;
    }
#else
    if (WIFI_MESH_STATE_PARENT_CONNECTED == mesh_state)
    {
        memcpy(new_mac, mac, 6);
        loop_send = 1;
        tls_os_queue_send(mesh_demo_queue, (void *)MESH_DEMO_MSG_SEND_DATA, 0);
    }
    else if (WIFI_MESH_STATE_PARENT_DISCONNECTED == mesh_state)
    {
        loop_send = 0;
    }
#endif
}

static void mesh_demo_task(void *data)
{
    void *msg;
    int ret;
    wifi_mesh_cfg_s config;
    
    tls_os_queue_create(&mesh_demo_queue, MESH_DEMO_QUEUE_SIZE);

    memset(&config, 0, sizeof(config));
    strcpy(config.mesh_id, "yichen-mesh");
#if MESH_DEMO_USE_ROOT
    config.mesh_status = WIFI_MESH_STATUS_ROOT;
    config.root_channel = 9;
#else
    config.mesh_status = WIFI_MESH_STATUS_LEAF;
#endif
    config.recv_callback = data_recv_callback;
    config.event_callback = event_callback;

    wifi_mesh_init(&config);

    for( ; ; ) 
	{
		ret = tls_os_queue_receive(mesh_demo_queue, (void **)&msg, 0, 0);
        if (!ret)
        {
    		switch((u32)msg)
    		{
    			case MESH_DEMO_MSG_SEND_DATA:
    			    while (loop_send)
    			    {
                        wifi_mesh_send_data(new_mac, "hello world", sizeof("hello world"));
                        tls_os_time_delay(5 * HZ);
                    }
    				break;

    			default:
    				break;
    		}
		}
	}
}

void UserMain(void)
{
	printf("\n wifi mesh demo\n");

	tls_os_task_create(NULL, NULL, mesh_demo_task,
                       (void *)0, (void *)mesh_demo_task_stk,
                       MESH_DEMO_STK_SIZE * sizeof(OS_STK),
                       MESH_DEMO_TASK_PRIO, 0);
}

