/***************************************************************************** 
* 
* File Name : main.c
* 
* Description: main 
* 
* Copyright (c) 2014 Winner Micro Electronic Design Co., Ltd. 
* All rights reserved. 
* 
* Author : dave
* 
* Date : 2014-6-14
*****************************************************************************/ 
#include "string.h"
#include "wm_include.h"
#include "wm_ieee80211.h"
#include "tls_wireless.h"

extern struct tls_wif * tls_get_wif_data(void);

static u8 x_my_addr[6] = {0x00, 0x25, 0x08, 0x09, 0x01, 0x0F};
static u8 x_bd_addr[6] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

void x_wifi_recv_callback(u8* data, u32 data_len)
{
    struct ieee80211_hdr *hdr= (struct ieee80211_hdr *)data;

    if (ieee80211_is_beacon(hdr->frame_control))
    {
        printf("beacon: %02X-%02X-%02X-%02X-%02X-%02X\r\n", hdr->addr3[0], 
                                                            hdr->addr3[1], 
                                                            hdr->addr3[2], 
                                                            hdr->addr3[3], 
                                                            hdr->addr3[4], 
                                                            hdr->addr3[5]);
    } else if (ieee80211_is_probe_resp(hdr->frame_control))
    {
        printf("probe resp: %02X-%02X-%02X-%02X-%02X-%02X\r\n", hdr->addr3[0], 
                                                                hdr->addr3[1], 
                                                                hdr->addr3[2], 
                                                                hdr->addr3[3], 
                                                                hdr->addr3[4], 
                                                                hdr->addr3[5]);
    }
}

static void x_scan(void)
{
    u8 ch;
    u8 ie[32];
    struct tls_wifi_hdr_mac_t mac;
    struct tls_wifi_tx_rate_t tx;

    memcpy(mac.da_addr, x_bd_addr, 6);
    memcpy(mac.sa_addr, x_my_addr, 6);
    memcpy(mac.bssid, x_bd_addr, 6);

    tls_wl_if_set_mode(tls_get_wif_data(), IEEE80211_MODE_IBSS);

    tls_wifi_data_recv_cb_register(x_wifi_recv_callback);

    tx.tx_rate = WM_WIFI_TX_RATEIDX_1M;
    tx.tx_gain = tls_wifi_get_tx_gain_max(WM_WIFI_TX_RATEIDX_1M);

    ie[0] = 0;/* ssid */
    ie[1] = 0;

    for (ch = 1; ch < 14; ch++)
    {
        tls_wifi_change_chanel(ch -1);
        tls_wifi_send_mgmt(WM_WIFI_MGMT_TYPE_PROBE_REQ, &mac, ie, 2, &tx);
        tls_os_time_delay(HZ / 10); /* waitting recv 100ms */
    }

    tls_wifi_change_chanel(0);
    tls_wifi_data_recv_cb_register(NULL);

    tls_wl_if_ps(0);/* set wifi off */
}

static void x_scan2(void)
{
    u8 ch;
    u8 packet[64] = {0};
    struct ieee80211_hdr *hdr= (struct ieee80211_hdr *)packet;

    tls_wl_if_set_mode(tls_get_wif_data(), IEEE80211_MODE_IBSS);

    tls_wifi_data_recv_cb_register(x_wifi_recv_callback);

    /* packet: 802.11hdr + ... */
    hdr->frame_control = host_to_le16(IEEE80211_FTYPE_MGMT | IEEE80211_STYPE_PROBE_REQ);
    memcpy(hdr->addr1, x_bd_addr, 6);
    memcpy(hdr->addr2, x_my_addr, 6);
    memcpy(hdr->addr3, x_bd_addr, 6);

    packet[sizeof(*hdr)] = 0; /* ssid */
    packet[sizeof(*hdr) + 1] = 0;/* ssid len */

    for (ch = 1; ch < 14; ch++)
    {
        tls_wifi_change_chanel(ch -1);
        tls_wifi_send_data(NULL, packet, sizeof(*hdr) + 2, NULL);
        tls_os_time_delay(HZ / 10); /* waitting recv 100ms */
    }

    tls_wifi_change_chanel(0);
    tls_wifi_data_recv_cb_register(NULL);

    tls_wl_if_ps(0);/* set wifi off */
}

void UserMain(void)
{
	printf("start scan\r\n");
	x_scan();
	printf("complete scan\r\n");
	printf("start scan2\r\n");
	x_scan2();
	printf("complete scan\r\n");

#if DEMO_CONSOLE
	CreateDemoTask();
#endif
//ûԼtask
}

