#include <string.h>
#include "wm_include.h"

#define YOUR_WIFI_SSID  ""
#define YOUR_WIFI_PWD   ""

#define X_TASK_PRIO     32
#define X_TASK_STK_SIZE 512
static OS_STK x_task_stk[X_TASK_STK_SIZE];
static tls_os_sem_t *x_task_sem = NULL;
static char your_addr[1024] = {0};

#define X_HTTP_BUF_SIZE 1024
#define X_HTTP_ADDR_LEN 256
#define X_HTTP_URL "http://api.cellocation.com:81"
static u32 x_http_content_len = 0;

static int x_http_recv(int skt, void *html, int len)
{
    int ret;
    fd_set read_set;
    struct timeval tv;

    FD_ZERO(&read_set);
    FD_SET(skt, &read_set);
    tv.tv_sec  = 5;
    tv.tv_usec = 0;

    ret = select(skt + 1, &read_set, NULL, NULL, &tv);
    if (ret > 0)
    {
        if (FD_ISSET(skt, &read_set))
        {
            ret = recv(skt, html, len, 0);
            if (0 == ret)
            {
                ret = 0;
            }
            else if (ret < 0)
            {
                ret = -33;
            }

            FD_CLR(skt, &read_set);
        }
        else
        {
            ret = -32;
        }
    }
    else
    {
        ret = -31;
    }

    return ret;
}

static int x_http_read_by_size(int skt_num, char* buffer,
                               unsigned short bufferMaxSize,
                               unsigned short NextTCPReadSize)
{
	unsigned int totBytesToRead;
	int          curBytesToRead;
	unsigned int curBytesRead;

    if (bufferMaxSize < NextTCPReadSize)
    {
        return -1;
	}

    curBytesRead   = 0;
    totBytesToRead = NextTCPReadSize;

    do
    {
        curBytesToRead = x_http_recv(skt_num, buffer + curBytesRead, totBytesToRead);
        if (0 >= curBytesToRead)
            return curBytesToRead;

        curBytesRead   += curBytesToRead;
        totBytesToRead -= curBytesToRead;
    } while(totBytesToRead > 0);

	return curBytesRead;
}

static void x_http_parse_line(char* line, unsigned short len)
{
    //printf("line='%s'\r\n", line);

    if (sscanf(line, "Content-Length: %u", &x_http_content_len) == 1 ||
	    sscanf(line, "Content-length: %u", &x_http_content_len) == 1)
	{

	}

    return;
}

static int x_get_http_response(int skt,
                               char* presponseBuffer,
                               u32 responseBufferSize)
{
    int line_count, total_len = 0;
    int len;
    char *buf, *q;
    u8 ch;
    int ret;

    buf = tls_mem_alloc(X_HTTP_BUF_SIZE);
    if (!buf)
    {
        return -20;
    }

    line_count = 0;
    memset(presponseBuffer, 0, responseBufferSize);
    for(;;) {
        memset(buf, 0, X_HTTP_BUF_SIZE);
        q = buf;
        for(;;) {
            ret = x_http_recv(skt, &ch, 1);
            if (ret <= 0)
        	    break;
            if (ch == '\n')
                break;
            else if (ch != '\r') {
                if ((q - buf) < X_HTTP_BUF_SIZE - 1)
                    *q++ = ch;
            }
        }
        *q = '\0';

        /* test if last line */
        if (buf[0] == '\0')
        {
            *(presponseBuffer + total_len) = '\0';
            break;
        }

        if (line_count == 0) {
            *q++ = '\r';
            *q   = '\n';
            total_len  = q - buf + 1;
            memcpy(presponseBuffer, buf, total_len);
            x_http_parse_line(buf, total_len);
        }
        else
        {
            *q++ = '\r';
            *q   = '\n';
            len = q - buf + 1;
            memcpy(presponseBuffer + total_len, buf, len);
            total_len += len;
            x_http_parse_line(buf, len);
        }
        line_count++;
    }

    tls_mem_free(buf);

	return total_len;
}

static int x_http_connection(char *address, u16 port)
{
	struct hostent *hp;
	struct sockaddr_in server;
	int skt = -1;
	int ret = -1;

    hp = gethostbyname(address);
    if (hp == NULL )
	{
		return -11;
	}

	skt = socket(AF_INET, SOCK_STREAM, 0);
	if (skt < 0)
	{
		return -12;
	}

	memset(&server, 0, sizeof(struct sockaddr_in));
	memcpy(&(server.sin_addr), hp->h_addr, hp->h_length);
	server.sin_family = AF_INET;
	server.sin_port = htons(port);
	ret = connect(skt, (struct sockaddr*)&server, sizeof(struct sockaddr_in));
	if (ret < 0)
	{
		close(skt);
		skt = -13;
	}

	return skt;
}

static int x_parse_http_url(char* url, char *address, u16* portNum, char *media)
{
	char *prefix = "http://";
	u32 prefixLength = 7;
	char* from = NULL ;
	char* to = NULL;
	u32 i;
	int portNumInt;
	char nextChar;

	if (strncmp(url, prefix, prefixLength) != 0)
	{
		return -7;
	}

	from = &url[prefixLength];
	to = &address[0];
	for (i = 0; i < X_HTTP_ADDR_LEN; ++i)
	{
		if (*from == '\0' || *from == ':' || *from == '/')
		{
			*to = '\0';
			break;
		}
		*to++ = *from++;
	}
	if (i == X_HTTP_ADDR_LEN)
	{
		return -8;
	}

 	*portNum = 80;
	nextChar = *from;
	if (nextChar == ':')
	{

		if (sscanf(++from, "%d", &portNumInt) != 1)
		{
			return -9;
		}
		if (portNumInt < 1 || portNumInt > 65535)
		{
			return -10;
		}
		*portNum = portNumInt;
	}

    while (*from != '\0')
    {
        if (*from == '/')
        {
            strcpy(media, from);
            break;
        }
        from++;
    }

	return 0;
}

static int x_http_send_request(u8 *mac)
{
    int ret = -1;
    int len = 0;
    int skt;
    u16 port;
    char *address = NULL;
    char *media   =  NULL;
    char *html = NULL;
    int contentlen = 0;

    address = tls_mem_alloc(X_HTTP_ADDR_LEN);
	if (!address)
	    return -1;

	media = tls_mem_alloc(X_HTTP_ADDR_LEN);
	if (!media)
	{
	    tls_mem_free(address);
	    return -2;
    }

	memset(address, 0, X_HTTP_ADDR_LEN);
	memset(media,   0, X_HTTP_ADDR_LEN);

	ret = x_parse_http_url(X_HTTP_URL, address, &port, media);
	if (ret)
	{
	    tls_mem_free(address);
	    tls_mem_free(media);
	    return -3;
    }

    html = tls_mem_alloc(X_HTTP_BUF_SIZE);
    if (!html)
    {
	    tls_mem_free(address);
	    tls_mem_free(media);
	    return -4;
    }

    skt = x_http_connection(address, port);
    if (skt < 0)
    {
        tls_mem_free(address);
	    tls_mem_free(media);
        tls_mem_free(html);
        return -5;
    }


    memset(html, 0, X_HTTP_BUF_SIZE);
    len = sprintf(html, "GET /wifi/?mac=%02x:%02x:%02x:%02x:%02x:%02x&output=xml HTTP/1.0\r\n", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
    len += sprintf(html + len, "Host: %s:%hu\r\n", address, port);

    //len += sprintf(html + len, "Connection: keep-alive\r\n");
    //len += sprintf(html + len, "Cache-Control: max-age=0\r\n");
    //len += sprintf(html + len, "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8\r\n");
    //len += sprintf(html + len, "Upgrade-Insecure-Requests: 1\r\n");

    len += sprintf(html + len, "User-Agent: uart_soc_wifi\r\n");
    //len += sprintf(html + len, "User-Agent: Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36\r\n");

    //len += sprintf(html + len, "Accept-Encoding: gzip, deflate, sdch\r\n");
    //len += sprintf(html + len, "Accept-Language: zh-CN,zh;q=0.8\r\n");

    len += sprintf(html + len, "\r\n");

    tls_mem_free(address);
    tls_mem_free(media);

    //printf("send='%s'\r\n", html);

    ret = send(skt, html, len, 0);
    if (ret != len)
    {
        close(skt);
        tls_mem_free(html);
        return -6;
    }

    tls_mem_free(html);

    return skt;
}


int x_get_wifi_address(unsigned char *mac, char *buf, unsigned int len)
{
    int ret = -1;
    int skt;
    char *html = NULL;
    u32 responseCode = 0;
    u32 read = 0;
    u32 nTotal = 0;
	char *start;
	char *end;

    skt = x_http_send_request(mac);
    if (skt < 0)
        return skt;

    html = tls_mem_alloc(X_HTTP_BUF_SIZE);
    if (!html)
    {
        close(skt);
        return -2;
    }

    x_http_content_len = 0;
    memset(html, 0, X_HTTP_BUF_SIZE);
    ret = x_get_http_response(skt, html, X_HTTP_BUF_SIZE);
    if (ret > 0)
    {
        if (sscanf(html, "%*s%u", &responseCode) != 1)
    	{
    		ret = -3;
    		goto fail;
    	}

    	if (200 != responseCode)
    	{
    		ret = -4;
            goto fail;
    	}

        if (0 == x_http_content_len)
            x_http_content_len = X_HTTP_BUF_SIZE;

        while (x_http_content_len > nTotal)
        {
            read = x_http_content_len - nTotal;
            if (read > X_HTTP_BUF_SIZE)
                read = X_HTTP_BUF_SIZE;

            ret = x_http_read_by_size(skt, html, X_HTTP_BUF_SIZE, read);
            if (ret >= 0)
            {
                //printf("content='%s'\r\n", html);

                start = strstr(html, "<errcode>");
                end   = strstr(html, "</errcode>");
                if (!start || !end)
                {
                    ret = -5;
                    break;
                }
                start += strlen("<errcode>");
                *end++ = '\0';
                ret = atoi(start);
                if (10001 == ret)
                {
                    ret = -9;//no found
                    break;
                }
                else if (10000 == ret)
                {
                    ret = -8;//param error
                    break;
                }
                else if (0 != ret)
                {
                    ret = -7;
                    break;
                }

                start = strstr(end, "<address>");
                end   = strstr(end, "</address>");
                if (!start || !end)
                {
                    ret = -5;
                    break;
                }

                start += strlen("<address>");
                *end = '\0';
                strncpy(buf, start, len);
                ret = strlen(buf);
                break;
            }
            else
            {
                ret = -6;
                break;
            }
        }
    }

fail:
    close(skt);
    tls_mem_free(html);

    return ret;
}

static tls_os_sem_t *x_wifi_scan_sem = NULL;

static void x_wifi_scan_finish(void)
{
    tls_os_sem_release(x_wifi_scan_sem);
}

static int wpos_proc_entry(char *outbuf, int len)
{
    char *buf;
    u32 buflen;
    int i;
    u8 *mac;
    u8 macsave[6];
    int rssi;
    struct tls_scan_bss_t *scan_res;
    struct tls_bss_info_t *bss_info;

    tls_os_sem_create(&x_wifi_scan_sem, 0);
    tls_wifi_scan_result_cb_register(x_wifi_scan_finish);
    tls_wifi_scan();
    tls_os_sem_acquire(x_wifi_scan_sem, 0);
    tls_os_sem_delete(x_wifi_scan_sem);
    x_wifi_scan_sem = NULL;
    buflen = 2000;
    buf = tls_mem_alloc(buflen);
    tls_wifi_get_scan_rslt(buf, buflen);
    scan_res = (struct tls_scan_bss_t *)buf;
    bss_info = scan_res->bss;
    mac = bss_info->bssid;
    rssi = -(char)(0x100 - bss_info->rssi);
    for (i = 0; i < scan_res->count; i++)
    {
        if (rssi < -(char)(0x100 - bss_info->rssi))
        {
            rssi = -(char)(0x100 - bss_info->rssi);
            mac = bss_info->bssid;
        }

        //printf("%d: %02x:%02x, %d, %d\r\n", i, bss_info->bssid[0], bss_info->bssid[1],rssi, -(char)(0x100 - bss_info->rssi));

        bss_info++;
    }
    memcpy(macsave, mac, 6);
    tls_mem_free(buf);

    return x_get_wifi_address(macsave, outbuf, len);
}

static void x_task_net_status(u8 status)
{
    if (NETIF_IP_NET_UP == status)
        tls_os_sem_release(x_task_sem);
}

static void x_task_func(void *data)
{
	IGNORE_PARAMETER(data);

	tls_os_sem_create(&x_task_sem, 0);

    tls_netif_add_status_event(x_task_net_status);

	tls_wifi_connect(YOUR_WIFI_SSID, strlen(YOUR_WIFI_SSID),
	                 YOUR_WIFI_PWD, strlen(YOUR_WIFI_PWD));

    tls_os_sem_acquire(x_task_sem, 0);

    printf("have joined net\r\n");

	wpos_proc_entry(your_addr, sizeof(your_addr));

    printf("your address: %s\r\n", your_addr);

    for( ; ; )
	{
        tls_os_time_delay(0x99999);
	}
}

void CreateXTask(void)
{
    tls_os_task_create(NULL, NULL, x_task_func,
                       NULL, (void *)x_task_stk,
                       X_TASK_STK_SIZE * sizeof(u32),
                       X_TASK_PRIO, 0);
}

