/*****************************************************************************
*
* File Name  : wm_wdrt_demo.c
*
* Description: wifi direct rx or tx demo
*
* Copyright (c) 2014 Winner Micro Electronic Design Co., Ltd.
* All rights reserved.
*
* Author     : 
*
* Date : 2019-5-6
*****************************************************************************/
#include <string.h>
#include "wm_include.h"
#include "wm_wdrt_demo.h"


#define WM_WDRT_DEMO_TX
#define TEST_SPEED


#ifndef WM_WDRT_DEMO_TX
#ifdef TEST_SPEED
static u32 my_wifi_rx_len = 0;
static u32 my_wifi_last_time = 0;
#endif

static void my_wifi_rx_callback(const u8 *src, u8* data, u32 data_len)
{
#ifdef TEST_SPEED
    u32 dtime;
#endif

#ifndef TEST_SPEED
    printf("rx %u bytes: [%s]\r\n", data_len, data);
#else
    my_wifi_rx_len += data_len;

    dtime = tls_os_get_time() - my_wifi_last_time;
    if (dtime >= HZ)
    {
        printf("rx speed: %0.2f Mbps\r\n", (my_wifi_rx_len * 8) / ((float)dtime / HZ) / 1024 / 1024);

        my_wifi_rx_len = 0;
        my_wifi_last_time = tls_os_get_time();
    }
#endif
}
#endif

void UserMain(void)
{
    wm_wdrt_cfg cfg;
    memset(&cfg, 0, sizeof(cfg));

#ifdef WM_WDRT_DEMO_TX
    cfg.mode = WM_WDRT_MODE_TX;
    cfg.work_channel = 6;
    cfg.tx_rate = WM_WIFI_TX_RATEIDX_36M;
    cfg.tx_data = "hello world";
#ifndef TEST_SPEED
    cfg.tx_data_len = sizeof("hello world");
#else
    cfg.tx_data_len = 1500;
#endif
    cfg.da[0]= 0x40;
    cfg.da[1]= 0xd6;
    cfg.da[2]= 0x3c;
    cfg.da[3]= 0x1b;
    cfg.da[4]= 0x6b;
    cfg.da[5]= 0xa5;
#else
    cfg.mode = WM_WDRT_MODE_RX;
    cfg.work_channel = 6;
    cfg.rx_callback = my_wifi_rx_callback;
#ifdef TEST_SPEED
    my_wifi_last_time = tls_os_get_time();
#endif
#endif

	wm_wdrt_demo(&cfg);
}

