#ifndef __SHELL_H__
#define __SHELL_H__

#define	SHELL_PROMPT			"Shell> "	/* Monitor Command Prompt	*/
#define SHELL_CBSIZE	        128		    /* Console I/O Buffer Size	*/
#define	SHELL_MAXARGS	        16		    /* max number of command args	*/
#define SHELL_HISTORY_MAX       10


/* =============================================== */
#define SHELL_UART_NO           TLS_UART_0  /* for read uart */

extern int sendchar(int ch);                /* for write uart */
/* =============================================== */

/* ex. AT+SSID
*  input ssid, not input at+ssid
*  need call shell_ouput_atcmd_result in atcmd module
*/
#define SHELL_SUPPORT_ATCMD     0

/* =============================================== */

extern void shell_ouput_atcmd_result(const char *buf);

extern void shell_loop(void);

#endif /* __SHELL_H__ */

