#include <stdio.h>
#include <string.h>

#include "wm_include.h"
#include "utils.h"

#include "shell.h"
#include "ringbuf.h"

#if SHELL_SUPPORT_ATCMD
#if (GCC_COMPILE==1)
#include "wm_cmdp_hostif_gcc.h"
#else
#include "wm_cmdp_hostif.h"
#endif
#endif

struct cmd_tbl_s {
    char *name;		/* Command Name			*/
    int	  maxargs;	/* maximum number of arguments	*/
    int   repeatable;	/* autorepeat allowed?		*/
                        /* Implementation function	*/
    int (*cmd)(struct cmd_tbl_s *, int, int, char *[]);
    char *usage;		/* Usage message	(short)	*/
    char *help;		    /* Help  message	(long)	*/
};

typedef struct cmd_tbl_s shell_cmd_tbl_t;

static char shell_console_buffer[SHELL_CBSIZE];		/* console I/O buffer	*/
static char * shell_delete_char (char *buffer, char *p, int *colp, int *np, int plen);
static char shell_erase_seq[] = "\b \b";		/* erase sequence	*/
static char shell_tab_seq[] = "        ";		/* used to expand TABs	*/
static int shell_ctrlc_was_pressed = 0;

static uint8_t       shell_ringbuf_array[128];
static ringbuf_t     shell_ringbuf = {shell_ringbuf_array, sizeof(shell_ringbuf_array)};
static tls_os_sem_t *shell_uart_rx_sem = NULL;


int shell_cmd_do_help (shell_cmd_tbl_t * cmdtp, int flag, int argc, char *argv[]);
shell_cmd_tbl_t *shell_find_cmd (const char *cmd);

typedef struct {
    struct dl_list node;
    char *console;
} shell_history_cmd_t;
static DEFINE_DL_LIST(shell_history_cmd);


static shell_cmd_tbl_t shell_cmd_tbl[] =
{
    {"help", SHELL_MAXARGS,	1,	shell_cmd_do_help,
     "help    - print online help\n",
     "[command ...]\n"
     "    - show help information (for 'command')\n"
     "'help' prints online help for the monitor commands.\n\n"
     "Without arguments, it prints a short usage message for all commands.\n\n"
     "To get detailed help information for specific commands you can type\n"
     "'help' with one or more command names as arguments.\n"
    },
    {NULL, 0, 0, NULL, NULL, NULL},
};

/*
 * Use printf() instead of printf() to avoid printf buffer overflow
 * for long help messages
 */
static int shell_cmd_do_help (shell_cmd_tbl_t * cmdtp, int flag, int argc, char *argv[])
{
	int i;
	int rcode = 0;

	if (argc == 1) {	/*show list of commands */

		int cmd_items = sizeof(shell_cmd_tbl) / sizeof(shell_cmd_tbl_t);	/* pointer arith! */
		shell_cmd_tbl_t *cmd_array[cmd_items];
		int i, j, swaps;

		/* Make array of commands from .uboot_cmd section */
		cmdtp = &shell_cmd_tbl[0];
		for (i = 0; i < cmd_items; i++) {
			cmd_array[i] = cmdtp++;
		}

		/* Sort command list (trivial bubble sort) */
		for (i = cmd_items - 1; i > 0; --i) {
			swaps = 0;
			for (j = 0; j < i; ++j) {
				if (strcmp (cmd_array[j]->name,
					    cmd_array[j + 1]->name) > 0) {
					shell_cmd_tbl_t *tmp;
					tmp = cmd_array[j];
					cmd_array[j] = cmd_array[j + 1];
					cmd_array[j + 1] = tmp;
					++swaps;
				}
			}
			if (!swaps)
				break;
		}

		/* print short help (usage) */
		for (i = 0; i < cmd_items; i++) {
			const char *usage = cmd_array[i]->usage;

#if 0
			/* allow user abort */
			if (ctrlc ())
				return 1;
#endif
			if (usage == NULL)
				continue;
			printf ("\r\n");
			printf (usage);
		}
		return 0;
	}
	/*
	 * command help (long version)
	 */
	for (i = 1; i < argc; ++i) {
		if ((cmdtp = shell_find_cmd (argv[i])) != NULL) {
			/* found - print (long) help info */
			printf (cmdtp->name);
			sendchar (' ');
			if (cmdtp->help) {
				printf (cmdtp->help);
			} else {
				printf ("\r\n- No help available.\n");
				rcode = 1;
			}
			sendchar ('\n');
		} else {
			printf ("\r\nUnknown command '%s' - try 'help'"
				" without arguments for list of all"
				" known commands\n\n", argv[i]
					);
			rcode = 1;
		}
	}
	return rcode;
}

static s16 shell_uart_rx_callback(u16 len)
{
    uint8_t c;
    while(tls_uart_read(SHELL_UART_NO, &c, 1) > 0)
    {
        ringbuf_put(&shell_ringbuf, c);
    }

    tls_os_sem_release(shell_uart_rx_sem);

    return 0;
}

static int shell_getc(void)
{
    for (;;) {
        int c = ringbuf_get(&shell_ringbuf);
        if (c != -1) {
            return c;
        }

        tls_os_sem_acquire(shell_uart_rx_sem, 0);
    }
}

/*
* Prompt for input and read a line.
* If CONFIG_BOOT_RETRY_TIME is defined and retry_time >= 0,
* time out when time goes past endtime (timebase time in ticks).
* Return: number of read characters
* -1 if break
* -2 if timed out
*/
static int shell_readline (const char *const prompt)
{
	char *p = shell_console_buffer; // console_bufferΪȡĻ
	int n = 0; /* buffer index */
	int plen = 0; /* prompt length */
	int col; /* output column cnt */
	char c;
	int a;
	int e = 0;
	int f = 0;
	int g = 0;
	shell_history_cmd_t *history;

	/* print prompt */
	if (prompt) { //ʾ㣬ʾ
		plen = strlen (prompt);
		printf (prompt);
	}
	col = plen;

	for (;;) {
		c = shell_getc(); //Ӵڶȡһַ
		//printf("c=%x\r\n", c);
		/*
		* Special character handling
		*/
		switch (c) {
			case '\r': /* Enter */
			case '\n':
						*p = '\0';
						printf ("\r\n");
						return (p - shell_console_buffer);//ĳ

			case '\0': /* nul */
						continue;

			case 0x03: /* ^C - break */ //ֹ
						shell_console_buffer[0] = '\0'; /* discard input */
						printf ("\r\n");
						return (-1);

			case 0x15: /* ^U - erase line */
						while (col > plen) {
							printf (shell_erase_seq);
							--col;
						}
						p = shell_console_buffer;
						n = 0;
						continue;

			case 0x17: /* ^W - erase word */
						p=shell_delete_char(shell_console_buffer, p, &col, &n, plen);
						while ((n > 0) && (*p != ' ')) {
							p=shell_delete_char(shell_console_buffer, p, &col, &n, plen);
						}
						continue;

			case 0x08: /* ^H - backspace */
			case 0x7F: /* DEL - backspace */ //ɾ
						p=shell_delete_char(shell_console_buffer, p, &col, &n, plen);
						continue;



            case 0x1B:  /* esc */                  //ASCII
                    //printf("%x ", c);
                     a = shell_getc();
                     //printf("%x ", a);
                     if (0x5B == a)
                     {
                         a = shell_getc();
                         //printf("%x ", a);
                         if (0x41 == a)
                         {
                               //
                               if (1 != g)
                               {
                                    e = 0;
                                    g = 1;
                               }
                               f = 0;
                                __dl_list_for_each_reverse(history, &shell_history_cmd, node)
                                {
                                    if (e == f++)
                                    {
                                        while (col > plen) {
                							printf (shell_erase_seq);
                							--col;
                						}
                						p = shell_console_buffer;

                                        strcpy(shell_console_buffer, history->console);
                                        n = strlen(shell_console_buffer);
                                        p = shell_console_buffer + n;
                                        col = n + plen;
                                        printf("%s", shell_console_buffer);
                                        break;
                                    }
                                }
                                e++;
                               continue;
                         }
                         else if (0x42 == a)
                         {
                               //
                               if (2 != g)
                               {
                                    e = 0;
                                    g = 2;
                               }
                               f = 0;
                                __dl_list_for_each(history, &shell_history_cmd, node)
                                {
                                    if (e == f++)
                                    {
                                        while (col > plen) {
                							printf (shell_erase_seq);
                							--col;
                						}
                						p = shell_console_buffer;

                                        strcpy(shell_console_buffer, history->console);
                                        n = strlen(shell_console_buffer);
                                        p = shell_console_buffer + n;
                                        col = n + plen;
                                        printf("%s", shell_console_buffer);
                                        break;
                                    }
                                }
                                e++;
                               continue;
                         }
                         else if (0x43 == a)
                         {
                               //
                               continue;
                         }
                         else if (0x44 == a)
                         {
                               //
                               continue;
                         }
                     }
                     continue;



			default:
						/*
						* Must be a normal character then
						*/
						if (n < SHELL_CBSIZE-2) {
							if (c == '\t') { /* expand TABs */
								printf (shell_tab_seq+(col&07));
								col += 8 - (col&07);
							}
							else {
										++col; /* echo input */ //ӡ
										sendchar (c);
							}
							*p++ = c; /*ַbuffer*/
							++n;
						}
						else { /* Buffer full */
							sendchar ('\a');
						}
		}
	}
}

static char * shell_delete_char (char *buffer, char *p, int *colp, int *np, int plen)
{
	char *s;

	if (*np == 0) {
		return (p);
	}

	if (*(--p) == '\t') {			/* will retype the whole line	*/
		while (*colp > plen) {
			printf (shell_erase_seq);
			(*colp)--;
		}
		for (s=buffer; s<p; ++s) {
			if (*s == '\t') {
				printf (shell_tab_seq+((*colp) & 07));
				*colp += 8 - ((*colp) & 07);
			} else {
				++(*colp);
				sendchar (*s);
			}
		}
	} else {
		printf (shell_erase_seq);
		(*colp)--;
	}
	(*np)--;
	return (p);
}

static int shell_had_ctrlc (void)
{
	return shell_ctrlc_was_pressed;
}

static void shell_clear_ctrlc (void)
{
	shell_ctrlc_was_pressed = 0;
}

/****************************************************************************/

static void shell_process_macros (const char *input, char *output)
{
	char c, prev;
	//const char *varname_start = NULL;
	int inputcnt = strlen (input);
	int outputcnt = SHELL_CBSIZE;
	int state = 0;		/* 0 = waiting for '$'  */
	//int i;
	//char envname[SHELL_CBSIZE], *envval;
	//int envcnt = input - varname_start - 1;	/* Varname # of chars */

	/* 1 = waiting for '(' or '{' */
	/* 2 = waiting for ')' or '}' */
	/* 3 = waiting for '''  */

	prev = '\0';		/* previous character   */

	while (inputcnt && outputcnt) {
		c = *input++;
		inputcnt--;

		if (state != 3) {
			/* remove one level of escape characters */
			if ((c == '\\') && (prev != '\\')) {
				if (inputcnt-- == 0)
					break;
				prev = c;
				c = *input++;
			}
		}

		switch (state) {
		case 0:	/* Waiting for (unescaped) $    */
			if ((c == '\'') && (prev != '\\')) {
				state = 3;
				break;
			}
			if ((c == '$') && (prev != '\\')) {
				state++;
			} else {
				*(output++) = c;
				outputcnt--;
			}
			break;
		case 1:	/* Waiting for (        */
			if (c == '(' || c == '{') {
				state++;
				//varname_start = input;
			} else {
				state = 0;
				*(output++) = '$';
				outputcnt--;

				if (outputcnt) {
					*(output++) = c;
					outputcnt--;
				}
			}
			break;
		case 2:	/* Waiting for )        */
			if (c == ')' || c == '}') {

#if 0
				/* Get the varname */
				for (i = 0; i < envcnt; i++) {
					envname[i] = varname_start[i];
				}
				envname[i] = 0;
#if 0
				/* Get its value */
				envval = getenv (envname);
#else
				envval = NULL;
#endif

				/* Copy into the line if it exists */
				if (envval != NULL)
					while ((*envval) && outputcnt) {
						*(output++) = *(envval++);
						outputcnt--;
					}
#endif
				/* Look for another '$' */
				state = 0;
			}
			break;
		case 3:	/* Waiting for '        */
			if ((c == '\'') && (prev != '\\')) {
				state = 0;
			} else {
				*(output++) = c;
				outputcnt--;
			}
			break;
		}
		prev = c;
	}

	if (outputcnt)
		*output = 0;
}

/****************************************************************************/

static int shell_parse_line (char *line, char *argv[])
{
	int nargs = 0;

	while (nargs < SHELL_MAXARGS) {

		/* skip any white space */
		while ((*line == ' ') || (*line == '\t')) {
			++line;
		}

		if (*line == '\0') {	/* end of line, no more args	*/
			argv[nargs] = NULL;
			return (nargs);
		}

		argv[nargs++] = line;	/* begin of argument string	*/

		/* find end of string */
		while (*line && (*line != ' ') && (*line != '\t')) {
			++line;
		}

		if (*line == '\0') {	/* end of line, no more args	*/
			argv[nargs] = NULL;
			return (nargs);
		}

		*line++ = '\0';		/* terminate current arg	 */
	}

	printf ("** Too many args (max. %d) **\n", SHELL_MAXARGS);
	return (nargs);
}

/***************************************************************************
 * find command table entry for a command
 */
static shell_cmd_tbl_t *shell_find_cmd (const char *cmd)
{
	shell_cmd_tbl_t *cmdtp_temp = &shell_cmd_tbl[0];	/*Init value */
	const char *p;
	int len;
	int n_found = 0;
	int i;
	int size;

	/*
	 * Some commands allow length modifiers (like "cp.b");
	 * compare command name only until first dot.
	 */
	len = ((p = strchr(cmd, '.')) == NULL) ? strlen (cmd) : (p - cmd);

    size = sizeof(shell_cmd_tbl) / sizeof(shell_cmd_tbl[0]);
	for (i = 0; i < size; i++) {
		if (strncmp (cmd, shell_cmd_tbl[i].name, len) == 0) {
			if (len == strlen (shell_cmd_tbl[i].name))
				return &shell_cmd_tbl[i];	/* full match */

			cmdtp_temp = &shell_cmd_tbl[i];	/* abbreviated command ? */
			n_found++;
		}
	}
	if (n_found == 1) {			/* exactly one match */
		return cmdtp_temp;
	}

	return NULL;	/* not found or ambiguous command */
}

/****************************************************************************
 * returns:
 *	1  - command executed, repeatable
 *	0  - command executed but not repeatable, interrupted commands are
 *	     always considered not repeatable
 *	-1 - not executed (unrecognized, bootd recursion or too many args)
 *           (If cmd is NULL or "" or longer than SHELL_CBSIZE-1 it is
 *           considered unrecognized)
 *
 * WARNING:
 *
 * We must create a temporary copy of the command since the command we get
 * may be the result from getenv(), which returns a pointer directly to
 * the environment data, which may change magicly when the command we run
 * creates or modifies environment variables (like "bootp" does).
 */

static int shell_run_command (const char *cmd, int flag)
{
	shell_cmd_tbl_t *cmdtp;
	char cmdbuf[SHELL_CBSIZE];	/* working copy of cmd		*/
	char *token;			/* start of token in cmdbuf	*/
	char *sep;			/* end of token (separator) in cmdbuf */
	char finaltoken[SHELL_CBSIZE];
	char *str = cmdbuf;
	char *argv[SHELL_MAXARGS + 1];	/* NULL terminated	*/
	int argc, inquotes;
	int repeatable = 1;
	int rc = 0;
	shell_history_cmd_t *history;
	shell_history_cmd_t *historyl;

	shell_clear_ctrlc();		/* forget any previous Control C */

	if (!cmd || !*cmd) {
		return -1;	/* empty command */
	}



#if 1
    __dl_list_for_each_safe(history, historyl, &shell_history_cmd, node)
    {
        if (0 == strcmp(history->console, cmd))
        {
            dl_list_del(&history->node);
            tls_mem_free(history->console);
            tls_mem_free(history);
            break;
        }
    }

    history = tls_mem_alloc(sizeof(shell_history_cmd_t));
	history->console = strdup(cmd);

    if (dl_list_len(&shell_history_cmd) == SHELL_HISTORY_MAX)
    {
        historyl = dl_list_first(&shell_history_cmd, shell_history_cmd_t, node);
        dl_list_del(&historyl->node);
        tls_mem_free(historyl->console);
        tls_mem_free(historyl);
        dl_list_add_tail(&shell_history_cmd, &history->node);
    }
    else
    {
        dl_list_add_tail(&shell_history_cmd, &history->node);
    }
#endif



	if (strlen(cmd) >= SHELL_CBSIZE) {
		printf ("\r\n## Command too long!\n");
		return -1;
	}

	strcpy (cmdbuf, cmd);

	/* Process separators and check for invalid
	 * repeatable commands
	 */
	while (*str) {

		/*
		 * Find separator, or string end
		 * Allow simple escape of ';' by writing "\;"
		 */
		for (inquotes = 0, sep = str; *sep; sep++) {
			if ((*sep=='\'') &&
			    (*(sep-1) != '\\'))
				inquotes=!inquotes;

			if (!inquotes &&
			    (*sep == ';') &&	/* separator		*/
			    ( sep != str) &&	/* past string start	*/
			    (*(sep-1) != '\\'))	/* and NOT escaped	*/
				break;
		}

		/*
		 * Limit the token to data between separators
		 */
		token = str;
		if (*sep) {
			str = sep + 1;	/* start of command for next pass */
			*sep = '\0';
		}
		else
			str = sep;	/* no more commands for next pass */

		/* find macros in this token and replace them */
		shell_process_macros (token, finaltoken);

		/* Extract arguments */
		if ((argc = shell_parse_line (finaltoken, argv)) == 0) {
			rc = -1;	/* no command at all */
			continue;
		}

		/* Look up command in command table */
		if ((cmdtp = shell_find_cmd(argv[0])) == NULL) {
		    if (!flag)
			    printf ("\r\nUnknown command '%s' - try 'help'\n", argv[0]);
			rc = -1;	/* give up after bad command */
			continue;
		}

		/* found - check max args */
		if (argc > cmdtp->maxargs) {
			printf ("\r\nUsage:\n%s\n", cmdtp->usage);
			rc = -1;
			continue;
		}

		/* OK - call function to do the command */
		if ((cmdtp->cmd) (cmdtp, flag, argc, argv) != 0) {
			rc = -1;
		}

		repeatable &= cmdtp->repeatable;

		/* Did the user stop this? */
		if (shell_had_ctrlc ())
			return 0;	/* if stopped then not repeatable */
	}

	return rc ? rc : repeatable;
}

#if SHELL_SUPPORT_ATCMD
static int shell_run_atcmd (const char *cmd, int flag)
{
    int err;
    //char *cmd;
    char *cmd2;
    shell_history_cmd_t *history;
	shell_history_cmd_t *historyl;

    //cmd = shell_console_buffer;
    cmd2 = tls_mem_alloc(strlen(cmd) + 6);
    if (!cmd2)
        return -1;
    strcpy(cmd2, cmd);

	__dl_list_for_each_safe(history, historyl, &shell_history_cmd, node)
    {
        if (0 == strcmp(history->console, cmd2))
        {
            dl_list_del(&history->node);
            tls_mem_free(history->console);
            tls_mem_free(history);
            break;
        }
    }

    history = tls_mem_alloc(sizeof(shell_history_cmd_t));
	history->console = strdup(cmd2);

    if (dl_list_len(&shell_history_cmd) == SHELL_HISTORY_MAX)
    {
        historyl = dl_list_first(&shell_history_cmd, shell_history_cmd_t, node);
        dl_list_del(&historyl->node);
        tls_mem_free(historyl->console);
        tls_mem_free(historyl);
        dl_list_add_tail(&shell_history_cmd, &history->node);
    }
    else
    {
        dl_list_add_tail(&shell_history_cmd, &history->node);
    }

    strcpy(cmd2, "AT+");
    strcat(cmd2, cmd);

    err = strlen(cmd2);
	cmd2[err] = '\n';

	err = tls_hostif_cmd_handler(HOSTIF_SHELL_AT_CMD, cmd2, err + 1);

    tls_mem_free(cmd2);

	return err;
}

const static char *shell_atcmd_err_str[14] =
{
    "",
    "invalid format",
    "unsupported command",
    "invalid operate sign",
    "invalid parameter",
    "operation not permitted",
    "memory not enough",
    "flash error",
    "device or resource busy",
    "device sleeping",
    "join net failed",
    "socket diabled",
    "socket invalid",
    "socket connect failed",
};

void shell_ouput_atcmd_result(const char *buf)
{
    int err;

    //printf("'%s'", buf);

    if (!strncmp(buf, "+OK", strlen("+OK")))
    {
        if (!strncmp(buf, "+OK=", strlen("+OK=")))
            printf("%s", buf + strlen("+OK="));
        else
            printf("execute complete.\n\n");
    }
    else if (!strncmp(buf, "+ERR", strlen("+ERR")))
    {
        err = atoi(buf + strlen("+ERR="));
        if (-64 == err)
        {
            printf("undefined command.\n\n");
        }
        else if (err < 0 && err > -14)
        {
            printf("%s.\n\n", shell_atcmd_err_str[-err]);
        }
        else
        {
            printf("%s.", buf);
        }
    }
    else
    {
        //printf("%s.", buf);
    }

    return;
}
#endif

void shell_loop(void)
{
    int err;

    tls_os_sem_create(&shell_uart_rx_sem, 0);
    tls_uart_port_init(SHELL_UART_NO, NULL, 0);
    tls_uart_rx_callback_register((u16) SHELL_UART_NO, shell_uart_rx_callback);

    for (;;)
    {
        err = shell_readline (SHELL_PROMPT);
    	if(err > 0){
#if SHELL_SUPPORT_ATCMD
    		err = shell_run_command (shell_console_buffer, 1);
    		if (err < 0)
    		    err = shell_run_atcmd (shell_console_buffer, 0);
    		    if (err < 0)
    		        printf ("\r\nUnknown command - try 'help'\n");
#else
            err = shell_run_command (shell_console_buffer, 0);
#endif
        }
    }
}

