#include <string.h>
#include "wm_include.h"
#include "wm_gpio_afsel.h"
#include "wm_sd_driver.h"

#define CMD0 0//λsd
#define CMD8 8
#define CMD9 9
#define CMD10 10
#define CMD12 12
#define CMD18 18
#define CMD17 17
#define CMD23 23
#define CMD24 24
#define CMD25 25
#define CMD55 55
#define CMD58 58
#define ACMD41 41

#define SD_IO_CS WM_IO_PB_15
#define SD_IO_CK WM_IO_PB_16
#define SD_IO_DI WM_IO_PB_17
#define SD_IO_DO WM_IO_PB_18

//#define W60X_SD_DBG printf
#define W60X_SD_DBG(...)
#define W60X_SD_INFO printf

#define SPI_CS_ENABLE tls_gpio_write(SD_IO_CS, 0);
#define SPI_CS_DISENABLE tls_gpio_write(SD_IO_CS, 1);

static SD_TYPE_E SD_Type;

static void SPI_SetIOConfig(void)
{
    /*MASTER SPI configuratioin*/
	wm_spi_cs_config(SD_IO_CS);
	wm_spi_ck_config(SD_IO_CK);
	wm_spi_di_config(SD_IO_DI);
	wm_spi_do_config(SD_IO_DO);
}

static void SPI_SetHighSpeed(void)
{
    tls_spi_setup(TLS_SPI_MODE_3, TLS_SPI_CS_LOW, TLS_SPI_FCLK_MAX);
}

static void SPI_SetLowSpeed(void)
{
    tls_spi_setup(TLS_SPI_MODE_3, TLS_SPI_CS_LOW, 200000);
}

static u8 SD_SendCommand(u8 cmd, u32 arg, u8 crc)
{
    unsigned char r1 = 0xFF;
    unsigned int Retry = 0;
    uint8_t data = 0xFF;
    uint32_t data_tx = 0;

    SPI_CS_DISENABLE;

    //8ʱӣ߼
    tls_spi_write(&data, 1);
    tls_spi_write(&data, 1);
    tls_spi_write(&data, 1);

    //ѡSD
    SPI_CS_ENABLE;

    /*SDпʼ */
    //cmdĵڶλΪλֵΪ1Ի0x40
    data = cmd | 0x40;
    tls_spi_write(&data, 1);

    data_tx = arg;
    data_tx = data_tx >> 24;
    tls_spi_write((const u8 *)&data_tx, 1);

    data_tx = arg;
    data_tx = data_tx >> 16;
    tls_spi_write((const u8 *)&data_tx, 1);

    data_tx = arg;
    data_tx = data_tx >> 8;
    tls_spi_write((const u8 *)&data_tx, 1);

    tls_spi_write((const u8 *)&arg, 1);
    tls_spi_write(&crc, 1);
    tls_spi_read(&r1, 1);

    //ȴӦʱ˳
    while (r1 == 0xFF)
    {
        tls_spi_read(&r1, 1);
        Retry++;
        if (Retry > 200)
            break; //ʱ
    }

    //رƬѡ
    SPI_CS_DISENABLE;

    //϶ⷢ8ʱӣSDʣµĹ
    data = 0xFF;
    tls_spi_write(&data, 1);

    //״ֵ̬
    return r1;
}

static u8 SD_SendCommand_NoDeassert(u8 cmd, u32 arg, u8 crc)
{
    u8 Retry = 0;
    u8 r1 = 0xFF;
    uint8_t data = 0xFF;
    uint32_t data_tx = 0;

    tls_spi_write(&data, 1);
    tls_spi_write(&data, 1);

    //;              //дʱ

    SPI_CS_ENABLE; //ƬѡõͣѡSD

    //
    data = cmd | 0x40;
    tls_spi_write(&data, 1);

    data_tx = arg;
    data_tx = data_tx >> 24;
    tls_spi_write((const u8 *)&data_tx, 1);

    data_tx = arg;
    data_tx = data_tx >> 16;
    tls_spi_write((const u8 *)&data_tx, 1);

    data_tx = arg;
    data_tx = data_tx >> 8;
    tls_spi_write((const u8 *)&data_tx, 1);

    tls_spi_write((const u8 *)&arg, 1);
    tls_spi_write(&crc, 1);
    tls_spi_read(&r1, 1);

    //ȴӦʱ˳
    while (r1 == 0xFF)
    {
        tls_spi_read(&r1, 1);
        Retry++;
        if (Retry > 200)
            break; //ʱ
    }
    //Ӧֵ
    return r1;
}


static u8 SD_ReceiveData(u8 *data, u16 len, u8 release)
{
    u16 retry;
    u8 r1;

    //һδ
    SPI_CS_ENABLE;
    retry = 0;

    do
    {
        tls_spi_read(&r1, 1);
        retry++;
        if (retry > 4000)  //4000εȴûӦ˳ɶԼΣ
        {
            SPI_CS_DISENABLE;
            W60X_SD_DBG("wait reply timeour\r\n");
            return 1;
        }
    } while (r1 != 0xFE);//ȴSDʼ0xFE

    //ѭ󣬿ʼ
    while (len--)
    {
        tls_spi_read(data, 1);
        //printf("*data=%x\r\n", *data);
        data++;
    }

    //2αCRC
    retry = 0xffff;
    tls_spi_write((const u8 *)&retry, 1);
    tls_spi_write((const u8 *)&retry, 1);

    //ͷ
    if(release == 1)
    {
        SPI_CS_DISENABLE;
        tls_spi_write((const u8 *)&retry, 1);
    }

    return 0;
}

u8 SD_GetCID(u8 *cid_data)
{
    u8 r1;

    //CMD10ȡCIDϢ
    r1 = SD_SendCommand(CMD10, 0, 0xFF);
    if (r1 != 0x00)
        return r1;  	//Ӧ˳

    //16ֽڵ
    SD_ReceiveData(cid_data, 16, 1);

    return 0;
}

u8 SD_GetCSD(u8 *csd_data)
{
    uint8_t res;

    res = SD_SendCommand(CMD9,0,0xFF);
    if (res) return res;

    SD_ReceiveData(csd_data, 16, 1);

    return 0;
}

u32 SD_GetCapacity(void)
{
    u8 csd[16];
    u32 Capacity;
    u8 r1;
    u16 i;
    u16 temp;

    //ȡCSDϢ0
    if (SD_GetCSD(csd) != 0)
        return 0;

    //CSDĴ2.0汾淽ʽ
    if ((csd[0] & 0xC0) == 0x40)
    {
       Capacity  = ((u32)csd[8]) << 8;
       Capacity += (u32)csd[9] + 1;
       Capacity  = (Capacity) * 1024;	//õ
       Capacity *= 512;	//õֽ
    }
    else		//CSDĴ1.0汾
    {
        i    = csd[6]&0x03;
        i  <<= 8;
        i   += csd[7];
        i  <<= 2;
        i   += ((csd[8] & 0xc0) >> 6);
        r1   = csd[9] & 0x03;
        r1 <<= 1;
        r1  += ((csd[10] & 0x80) >> 7);
        r1  += 2;
        temp = 1;

        while (r1)
        {
            temp*=2;
            r1--;
        }

        Capacity = ((u32)(i + 1)) * ((u32)temp);
        i = csd[5] & 0x0f;
        temp = 1;

        while(i)
        {
            temp *= 2;
            i--;
        }

        //ս, ֽΪλ
        Capacity *= (u32)temp;
    }

    return (u32)Capacity;
}

SD_TYPE_E SD_GetCardType(void)
{
    return SD_Type;
}

u8 SD_ReadSingleBlock(u32 sector, u8 *buffer)
{
    u8 r1;

    //ģʽ
    SPI_SetHighSpeed();

    if (SD_Type!=SD_TYPE_V2HC)	//SDHC
    {
        sector = sector<<9;	//512*sectorıַ߽
    }

    r1 = SD_SendCommand(CMD17, sector, 1);	//CMD17 
    if (r1 != 0x00)	return r1;

    r1 = SD_ReceiveData(buffer, 512, 1);	//һΪ512ֽ

    if (r1 != 0)
        return r1;   //ݳ
    else
        return 0; 		//ȡȷ0
}

u8 SD_ReadMultiBlock(u32 sector, u8 *buffer, u8 count)
{
    u8 r1;

    //ģʽ
    SPI_SetHighSpeed();

    if (SD_Type != SD_TYPE_V2HC)
    {
        sector = sector<<9;
    }

    r1 = SD_SendCommand(CMD18, sector, 1);		//
    if (r1 != 0x00)	return r1;

    //ʼ
    do
    {
        if (SD_ReceiveData(buffer, 512, 0) != 0x00)
        {
            break;
        }
        buffer += 512;
    } 	while (--count);

    SD_SendCommand(CMD12, 0, 1);	//ȫɣֹͣ
    SPI_CS_DISENABLE;	//ͷ
    r1 = 0xff;
    tls_spi_write(&r1, 1);

    if (count != 0)
        return count;   //ûд꣬ʣ
    else
        return 0;
}

static u8 SD_WaitReady(void)
{
  u8 r1;
  u16 retry=0;

  do
  {
    tls_spi_read(&r1, 1);
    retry++;
    if(retry==0xfffe)
        return 1;
  } while (r1 != 0xFF);

    return 0;
}

u8 SD_WriteSingleBlock(u32 sector, const u8 *data)
{
  	u8 r1;
  	//u16 i;
  	u16 retry;

    //ģʽ
    SPI_SetHighSpeed();

	//SDHCsectorַתΪbyteַ
    if (SD_Type != SD_TYPE_V2HC)
  	{
        sector = sector<<9;
  	}

	//дָ
    r1 = SD_SendCommand(CMD24, sector, 0x00);
  	if (r1 != 0x00)
  	{
		//Ӧֱӷ
    	return r1;
  	}

	//ʼ׼ݴ
    SPI_CS_ENABLE;

  	//ȷ3ݣȴSD׼
  	r1 = 0xff;
  	tls_spi_write(&r1, 1);
  	tls_spi_write(&r1, 1);
  	tls_spi_write(&r1, 1);

  	//ʼ0xFE
    r1 = 0xfe;
  	tls_spi_write(&r1, 1);

    //һsector
    #if 0
  	for (i = 0; i < 512; i++)
  	{
        tls_spi_write(data++, 1);
  	}
  	#endif
  	tls_spi_write(data, 512);

  	//2αCRCУ
  	r1 = 0xff;
  	tls_spi_write(&r1, 1);
  	tls_spi_write(&r1, 1);

  	//ȴSDӦ
  	tls_spi_read(&r1, 1);
	//Ϊ0x05˵дɹ
  	if ((r1 & 0x1F) != 0x05)
  	{
 		SPI_CS_DISENABLE;
 		return r1;
  	}

    //ȴ
  	retry = 0;
    //Աʱ߱
    tls_spi_read(&r1, 1);
  	while (!r1)
  	{
        tls_spi_read(&r1, 1);
        retry++;
        if(retry > 65534)        //ʱûдɣ˳
        {
            SPI_CS_DISENABLE;
            return 1;           //д볬ʱ1
        }
  	}

    //дɣƬѡ1
  	SPI_CS_DISENABLE;
  	r1 = 0xff;
  	tls_spi_write(&r1, 1);
    return 0;
}

u8 SD_WriteMultiBlock(u32 sector, const u8 *data, u8 count)
{
  	u8 r1;
  	//u16 i;

    //ģʽ
  	SPI_SetHighSpeed();

  	if (SD_Type != SD_TYPE_V2HC)
    {
        sector = sector<<9;
    }
    //if (SD_Type != SD_TYPE_MMC)
    {
        //ACMD23ָʹԤ
        r1 = SD_SendCommand(CMD23, count, 0x01);
    }

    //дָCMD25
    r1 = SD_SendCommand(CMD25, sector, 0x01);
    //Ӧȷֱӷ
  	if (r1 != 0x00)	return r1;

	//ʼ׼ݴ
  	SPI_CS_ENABLE;
	//3SD׼
	r1 = 0xff;
  	tls_spi_write(&r1, 1);
  	tls_spi_write(&r1, 1);
    tls_spi_write(&r1, 1);

  	//NsectorѭдĲ
  	do
  	{
        //ʼ0xFCǶд
        r1 = 0xfc;
        tls_spi_write(&r1, 1);
        //1sector
#if 0
        for (i = 0; i < 512; i++)
        {
            tls_spi_write(data++, 1);
        }
#endif
        tls_spi_write(data, 512);
        //2αCRC
        r1 = 0xff;
        tls_spi_write(&r1, 1);
        tls_spi_write(&r1, 1);

        //ȴSDӦ
        tls_spi_read(&r1, 1);
        //0x05ʾдɹ
        if ((r1 & 0x1F) != 0x05)
        {
            SPI_CS_DISENABLE;
            return r1;
        }

        //SDæź
        if (SD_WaitReady() == 1)//ʱдδɣ˳
        {
            SPI_CS_DISENABLE;
            return 1;
        }
    } while(--count);

       //ʹ0xFD
       r1 = 0xfd;
  	   tls_spi_write(&r1, 1);

       //ȴ׼
       if(SD_WaitReady())
       {
           SPI_CS_DISENABLE;
           return 1;
       }

       //дɣƬѡ1
       SPI_CS_DISENABLE;
       r1 = 0xff;
  	   tls_spi_write(&r1, 1);

       //countֵд꣬count=0,count=δдsector
       return count;
}

u8 SD_Init(void)
{
    u8 r1;
    u16 retry;
    u8 buff[6];
    uint8_t data[13];

    SPI_SetIOConfig();

    //SDʼʱʱӲܳ400KHz
    SPI_SetLowSpeed();

    //CSΪ͵ƽƬѡõͣѡSD

    //ʱȴSDϵȶ
    // for (i = 0; i < 0xffffff; i++)
    //     ;
    //Ȳ74壬SDʼ
    memset(data, 0xFF, 13);
    //д10ѭ80
    tls_spi_write(data, 13);

    //-----------------SDλidle״̬----------------
    //ѭCMD0ֱSD0x01,idle״̬
    //ʱֱ˳

    retry = 0;
    do
    {
        //CMD0CRCΪ0x95
        r1 = SD_SendCommand(CMD0, 0, 0x95);
        retry++;
    } while ((r1 != 0x01) && (retry < 200));
    //ѭ󣬼ԭ
    if (retry == 200) //˵ѳʱ
    {
        W60X_SD_DBG("CMD0 timeout!!!\r\n");
        return 1;
    }
    //δʱ˵SDλidle
    //CMD8ȡSDİ汾Ϣ
    r1 = SD_SendCommand_NoDeassert(CMD8, 0x1aa, 0x87);
    W60X_SD_DBG("CMD8 [version]:%02X\r\n", r1);
    //SD2.0ĳʼ
    if (r1 == 0x01)
    {
        //V2.0ĿCMD8ᴫ4ֽڵݣҪٽ
        tls_spi_read(buff, 4);

        SPI_CS_DISENABLE;
        //෢8ʱ
        retry = 0xFFFF;
        tls_spi_write((const u8 *)&retry, 1);
        retry = 0;
        //ʼָCMD55+ACMD41
        do
        {
            r1 = SD_SendCommand(CMD55, 0, 0);
            //Ӧ0x01
            if (r1 != 0x01)
            {
                W60X_SD_DBG("[cmd55]:%02X\r\n", r1);
                return r1;
            }
            W60X_SD_DBG("[cmd55]:%02X\r\n", r1);
            r1 = SD_SendCommand(ACMD41, 0x40000000, 0);
        } while (r1 != 0);

        //ʼָɣȡOCRϢ
        //----------SD2.0汾ʼ-----------
        //OCRָ
        r1 = SD_SendCommand_NoDeassert(CMD58, 0, 0);
        //ûзȷӦֱ˳Ӧ
        if (r1 != 0x00)
            return r1;
        //Ӧȷ󣬻ش4ֽOCRϢ
        tls_spi_read(buff, 4);
        //OCRɣƬѡø
        SPI_CS_DISENABLE;

        retry = 0xFFFF;
        tls_spi_write((const u8 *)&retry, 1);
        //յOCRеbit30λCSSȷΪSD2.0SDHC
        //CCS=1SDHC   CCS=0SD2.0
        if (buff[0] & 0x40)
        {
        	SD_Type = SD_TYPE_V2HC;
            W60X_SD_INFO("SD_TYPE_V2HC\r\n");
            //printf("SD test success!\r\n");
        }
        else
        {
        	SD_Type = SD_TYPE_V2;
            W60X_SD_INFO("SD_TYPE_V2\r\n");
            //printf("SD test success!\r\n");
        }
        //-----------SD2.0汾-----------
        //ģʽ
        SPI_SetHighSpeed();

		u32 Capacity = SD_GetCapacity();
		W60X_SD_INFO("SD Card Capacity = %0.2gG\n", (double)Capacity / 1024 /1024 / 1024);

		return 0;
    }

	return 0xff;
}

