/*****************************************************************************
*
* File Name : main.c
*
* Description: main
*
* Copyright (c) 2014 Winner Micro Electronic Design Co., Ltd.
* All rights reserved.
*
* Author : dave
*
* Date : 2014-6-14
*****************************************************************************/
#include "wm_include.h"
#include "wm_flash_map.h"
#include "wm_io.h"
#include "wm_gpio.h"

#define USE_FATFS       0
#define USE_FTP_SERVER  0

#if USE_FATFS
#include "fatfs/ff.h"
#else
#include "wm_vfs_fat/wm_vfs_fat.h"
#if USE_FTP_SERVER
#include "ftpserver/wm_ftpserver.h"
#endif
#include "oofatfs/ff.h"
#endif

void UserMain(void)
{
	printf("\n user task\n");

#if USE_FATFS
    FIL fp;
    UINT bw;
    FATFS fs;
    DIR dp;
    FILINFO fno;
    FRESULT res;
    char buff[32] = {0};

    res = f_mount (&fs, "0:/", 1);
    printf("mount = %d\r\n", res);

	res = f_opendir(&dp, "0:/");
    printf("opendir 0:/, res = %d\r\n\r\n", res);
	while (FR_OK == res)
	{
		res = f_readdir(&dp, &fno);
        if ((res != FR_OK) || (fno.fname[0] == 0))
        {
            printf("readdir 0:/, res = %d\r\n", res);
            break;
        }
        printf("[%-32s], [%u]\r\n", fno.fname, fno.fsize);
    }
	f_closedir(&dp);

	res = f_mkdir("0:/w60xdump");
    printf("mkdir 0:/w60xdump, res = %d\r\n", res);

    res = f_open(&fp, "0:/w60xdump/test.txt", FA_READ | FA_WRITE | FA_OPEN_APPEND);
    printf("open 0:/w60xdump/test.txt, res = %d\r\n", res);
    if (FR_NO_FILE == res)
    {
        res = f_open(&fp, "0:/w60xdump/test.txt", FA_READ | FA_WRITE | FA_CREATE_NEW);
        printf("open 0:/w60xdump/test.txt, res = %d\r\n", res);
    }

    res = f_write(&fp, "hello world", sizeof("hello world"), &bw);
    printf("write 0:/w60xdump/test.txt, res = %d, bw = %u\r\n", res, bw);

    res = f_rewind(&fp);
    printf("rewind 0:/w60xdump/test.txt, res = %d\r\n", res);

    res = f_read(&fp, buff, sizeof(buff), &bw);
    printf("read 0:/w60xdump/test.txt, res = %d, bw = %u, buff = [%s]\r\n", res, bw, buff);

    res = f_close(&fp);
    printf("close 0:/w60xdump/test.txt, res = %d\r\n", res);

    res = f_opendir(&dp, "0:/");
    printf("opendir 0:/, res = %d\r\n\r\n", res);
	while (FR_OK == res)
	{
		res = f_readdir(&dp, &fno);
        if ((res != FR_OK) || (fno.fname[0] == 0))
        {
            printf("readdir 0:/, res = %d\r\n", res);
            break;
        }
        printf("[%-32s], [%u]\r\n", fno.fname, fno.fsize);
    }
	f_closedir(&dp);

    res = f_unlink ("0:/w60xdump/test.txt");
    printf("unlink 0:/w60xdump/test.txt, res = %d\r\n", res);

    res = f_unlink ("0:/w60xdump");
    printf("unlink 0:/w60xdump, res = %d\r\n", res);

    res = f_opendir(&dp, "0:/");
    printf("opendir 0:/, res = %d\r\n\r\n", res);
	while (FR_OK == res)
	{
		res = f_readdir(&dp, &fno);
        if ((res != FR_OK) || (fno.fname[0] == 0))
        {
            printf("readdir 0:/, res = %d\r\n", res);
            break;
        }
        printf("[%-32s], [%u]\r\n", fno.fname, fno.fsize);
    }
	f_closedir(&dp);

#else

    FIL fp;
    UINT bw;
    FF_DIR dir;
    FILINFO fno;
    FRESULT res;
    char buff[32] = {0};
    fs_user_mount_t *vfs_fat;

	wm_vfs_fat_init();
#if USE_FTP_SERVER
	wm_ftps_start(21, "root", "root");
#endif

    vfs_fat = wm_vfs_fat_get_ctx();

    res = f_opendir(&vfs_fat->fatfs, &dir, "/");
    printf("opendir /, res = %d\r\n\r\n", res);
	while (FR_OK == res)
	{
		res = f_readdir(&dir, &fno);
        if ((res != FR_OK) || (fno.fname[0] == 0))
        {
            printf("readdir /, res = %d\r\n", res);
            break;
        }
        printf("[%-32s], [%u]\r\n", fno.fname, fno.fsize);
    }
	f_closedir(&dir);

	res = f_mkdir(&vfs_fat->fatfs, "/w60xdump");
    printf("mkdir /w60xdump, res = %d\r\n", res);

    res = f_open(&vfs_fat->fatfs, &fp, "/w60xdump/test.txt", FA_READ | FA_WRITE | FA_OPEN_APPEND);
    printf("open /w60xdump/test.txt, res = %d\r\n", res);
    if (FR_NO_FILE == res)
    {
        res = f_open(&vfs_fat->fatfs, &fp, "/w60xdump/test.txt", FA_READ | FA_WRITE | FA_CREATE_NEW);
        printf("open /w60xdump/test.txt, res = %d\r\n", res);
    }

    res = f_write(&fp, "hello world", sizeof("hello world"), &bw);
    printf("write /w60xdump/test.txt, res = %d, bw = %u\r\n", res, bw);

    res = f_rewind(&fp);
    printf("rewind /w60xdump/test.txt, res = %d\r\n", res);

    res = f_read(&fp, buff, sizeof(buff), &bw);
    printf("read /w60xdump/test.txt, res = %d, bw = %u, buff = [%s]\r\n", res, bw, buff);

    res = f_close(&fp);
    printf("close /w60xdump/test.txt, res = %d\r\n", res);

    res = f_opendir(&vfs_fat->fatfs, &dir, "/");
    printf("opendir /, res = %d\r\n\r\n", res);
	while (FR_OK == res)
	{
		res = f_readdir(&dir, &fno);
        if ((res != FR_OK) || (fno.fname[0] == 0))
        {
            printf("readdir /, res = %d\r\n", res);
            break;
        }
        printf("[%-32s], [%u]\r\n", fno.fname, fno.fsize);
    }
	f_closedir(&dir);

    res = f_unlink (&vfs_fat->fatfs, "/w60xdump/test.txt");
    printf("unlink /w60xdump/test.txt, res = %d\r\n", res);

    res = f_unlink (&vfs_fat->fatfs, "/w60xdump");
    printf("unlink /w60xdump, res = %d\r\n", res);

    res = f_opendir(&vfs_fat->fatfs, &dir, "/");
    printf("opendir /, res = %d\r\n\r\n", res);
	while (FR_OK == res)
	{
		res = f_readdir(&dir, &fno);
        if ((res != FR_OK) || (fno.fname[0] == 0))
        {
            printf("readdir /, res = %d\r\n", res);
            break;
        }
        printf("[%-32s], [%u]\r\n", fno.fname, fno.fsize);
    }
	f_closedir(&dir);
#endif


#if DEMO_CONSOLE
	CreateDemoTask();
#endif
//ûԼtask
}

