#include "wm_include.h"
#include "wm_flash_map.h"
#include "wm_io.h"
#include "wm_gpio.h"

#include "oled.h"
#include "stdlib.h"
#include "oledfont.h"  	 

static void lcd_delay(void)
{
    int i;
    for (i = 0;i < 100; i++);
}

u16 BACK_COLOR, POINT_COLOR;   //ɫɫ
void LCD_Writ_Bus(char dat)   //д
{	
	u8 i;			  
  

	for(i=0;i<8;i++)
	{			  
		OLED_SCLK_Clr();
		if(dat&0x80)
		   OLED_SDIN_Set();
		else 
		   OLED_SDIN_Clr();
		OLED_SCLK_Set();
		dat<<=1;   
	}	
	lcd_delay();
    OLED_SCLK_Clr();
}

void LCD_WR_DATA8(char da) //-8λ
{
    //OLED_BLK_Clr();
    OLED_DC_Set();
	//LCD_Writ_Bus(da);  
    tls_spi_write((const u8 *)&da, 1);
    //OLED_BLK_Set();
}  
void LCD_WR_DATA(int da)
{
    //OLED_BLK_Clr();
    OLED_DC_Set();
    u8 data = da>>8;
    tls_spi_write(&data, 1);
    data = da & 0xff;
    tls_spi_write(&data, 1);
	//LCD_Writ_Bus(da>>8);
    //LCD_Writ_Bus(da);
    //OLED_BLK_Set();
}	  
void LCD_WR_DATA2(u8 *data, int len)
{
    OLED_DC_Set();
    tls_spi_write(data, len);
}
void LCD_WR_REG(char da)	 
{
    //OLED_BLK_Clr();
    OLED_DC_Clr();
	//LCD_Writ_Bus(da);
    tls_spi_write((const u8 *)&da, 1);
    //lcd_delay();
    //OLED_BLK_Set();
}
 void LCD_WR_REG_DATA(int reg,int da)
{
    LCD_WR_REG(reg);
	LCD_WR_DATA(da);
}

void Address_set(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2)
{ 
#if 0
   LCD_WR_REG(0x2a);
   LCD_WR_DATA8(x1>>8);
   LCD_WR_DATA8(x1);
   LCD_WR_DATA8(x2>>8);
   LCD_WR_DATA8(x2);
#endif
    u8 data[16];
    data[0] = x1>>8;
    data[1] = x1;
    data[2] = x2>>8;
    data[3] = x2;
    LCD_WR_REG(0x2a);
    LCD_WR_DATA2(data, 4);
#if 0
    u8 cmd;
    u8 data[16];
    cmd = 0x2a;
    data[0] = x1>>8;
    data[1] = x1;
    data[2] = x2>>8;
    data[3] = x2;
    tls_spi_write_with_cmd(&cmd, 1, data, 4);
#endif

  #if 0
   LCD_WR_REG(0x2b);
   LCD_WR_DATA8(y1>>8);
   LCD_WR_DATA8(y1);
   LCD_WR_DATA8(y2>>8);
   LCD_WR_DATA8(y2);
   #endif
    data[0] = y1>>8;
    data[1] = y1;
    data[2] = y2>>8;
    data[3] = y2;
    LCD_WR_REG(0x2b);
    LCD_WR_DATA2(data, 4);
#if 0
   cmd = 0x2b;
    data[0] = y1>>8;
    data[1] = y1;
    data[2] = y2>>8;
    data[3] = y2;
    tls_spi_write_with_cmd(&cmd, 1, data, 4);
#endif

   LCD_WR_REG(0x2C);	
   //cmd = 0x2C;
    //tls_spi_write(&cmd, 1);
}

void Lcd_Init(void)
{
    #if 0
    tls_gpio_cfg(WM_IO_PA_11, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);//ck
    tls_gpio_cfg(WM_IO_PA_09, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);//do
    tls_gpio_cfg(WM_IO_PA_03, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);//di
    tls_gpio_cfg(WM_IO_PA_02, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);//cs blk

    tls_gpio_write(WM_IO_PA_11, 1);
    tls_gpio_write(WM_IO_PA_09, 1);
    tls_gpio_write(WM_IO_PA_03, 1);
    tls_gpio_write(WM_IO_PA_02, 1);
    #endif

    tls_gpio_cfg(WM_IO_PB_13, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);//rst
    tls_gpio_write(WM_IO_PB_13, 1);

    tls_gpio_cfg(WM_IO_PB_14, WM_GPIO_DIR_OUTPUT, WM_GPIO_ATTR_FLOATING);//di
    tls_gpio_write(WM_IO_PB_14, 1);

    tls_spi_trans_type(SPI_DMA_TRANSFER);
    tls_spi_setup(TLS_SPI_MODE_3, TLS_SPI_CS_LOW, TLS_SPI_FCLK_MAX);

    OLED_RST_Clr();
	lcd_delay();
	OLED_RST_Set();
	lcd_delay();


	//OLED_BLK_Set();
	
//************* Start Initial Sequence **********// 
LCD_WR_REG(0x36); 

LCD_WR_DATA8(0x00);
//u8 cmd = 0x36;
u8 data[16];
//data[0] = 0x00;
//tls_spi_write_with_cmd(&cmd, 1, data, 1);

LCD_WR_REG(0x3A); 
LCD_WR_DATA8(0x05);//0x65
//cmd = 0x3A;
//data[0] = 0x05;
//tls_spi_write_with_cmd(&cmd, 1, data, 1);

//LCD_WR_REG(0xB2);
//LCD_WR_DATA8(0x0C);
//LCD_WR_DATA8(0x0C);
//LCD_WR_DATA8(0x00);
//LCD_WR_DATA8(0x33);
//LCD_WR_DATA8(0x33);
#if 1
//cmd = 0xB2;
data[0] = 0x0C;
data[1] = 0x0C;
data[2] = 0x00;
data[3] = 0x33;
data[4] = 0x33;
LCD_WR_REG(0xB2);
LCD_WR_DATA2(data, 5);
#endif

//LCD_WR_REG(0xB7); 
//LCD_WR_DATA8(0x35);  
//cmd = 0xB7;
//data[0] = 0x35;
//tls_spi_write_with_cmd(&cmd, 1, data, 1);

LCD_WR_REG(0xBB);
LCD_WR_DATA8(0x19);
//cmd = 0xBB;
//data[0] = 0x19;
//tls_spi_write_with_cmd(&cmd, 1, data, 1);

LCD_WR_REG(0xC0);
LCD_WR_DATA8(0x2C);
//cmd = 0xC0;
//data[0] = 0x2C;
//tls_spi_write_with_cmd(&cmd, 1, data, 1);

LCD_WR_REG(0xC2);
LCD_WR_DATA8(0x01);
//cmd = 0xC2;
//data[0] = 0x01;
//tls_spi_write_with_cmd(&cmd, 1, data, 1);

LCD_WR_REG(0xC3);
LCD_WR_DATA8(0x12);   
//cmd = 0xC3;
//data[0] = 0x12;
//tls_spi_write_with_cmd(&cmd, 1, data, 1);

LCD_WR_REG(0xC4);
LCD_WR_DATA8(0x20);  
//cmd = 0xC4;
//data[0] = 0x20;
//tls_spi_write_with_cmd(&cmd, 1, data, 1);

LCD_WR_REG(0xC6); 
LCD_WR_DATA8(0x0F);    
//cmd = 0xC6;
//data[0] = 0x0F;
//tls_spi_write_with_cmd(&cmd, 1, data, 1);

//LCD_WR_REG(0xD0); 
//LCD_WR_DATA8(0xA4);
//LCD_WR_DATA8(0xA1);
//cmd = 0xD0;
data[0] = 0xA4;
data[1] = 0xA1;
LCD_WR_REG(0xD0); 
LCD_WR_DATA2(data, 2);

#if 0
LCD_WR_REG(0xE0);
LCD_WR_DATA8(0xD0);
LCD_WR_DATA8(0x04);
LCD_WR_DATA8(0x0D);
LCD_WR_DATA8(0x11);
LCD_WR_DATA8(0x13);
LCD_WR_DATA8(0x2B);
LCD_WR_DATA8(0x3F);
LCD_WR_DATA8(0x54);
LCD_WR_DATA8(0x4C);
LCD_WR_DATA8(0x18);
LCD_WR_DATA8(0x0D);
LCD_WR_DATA8(0x0B);
LCD_WR_DATA8(0x1F);
LCD_WR_DATA8(0x23);
#endif
#if 1
data[0] = 0xD0;
data[1] = 0x04;
data[2] = 0x0D;
data[3] = 0x11;
data[4] = 0x13;
data[5] = 0x2B;
data[6] = 0x3F;
data[7] = 0x54;
data[8] = 0x4C;
data[9] = 0x18;
data[10] = 0x0D;
data[11] = 0x0B;
data[12] = 0x1F;
data[13] = 0x23;
LCD_WR_REG(0xE0);
LCD_WR_DATA2(data, 14);
#endif

#if 0
LCD_WR_REG(0xE1);
LCD_WR_DATA8(0xD0);
LCD_WR_DATA8(0x04);
LCD_WR_DATA8(0x0C);
LCD_WR_DATA8(0x11);
LCD_WR_DATA8(0x13);
LCD_WR_DATA8(0x2C);
LCD_WR_DATA8(0x3F);
LCD_WR_DATA8(0x44);
LCD_WR_DATA8(0x51);
LCD_WR_DATA8(0x2F);
LCD_WR_DATA8(0x1F);
LCD_WR_DATA8(0x1F);
LCD_WR_DATA8(0x20);
LCD_WR_DATA8(0x23);
#endif
#if 1
data[0] = 0xD0;
data[1] = 0x04;
data[2] = 0x0C;
data[3] = 0x11;
data[4] = 0x13;
data[5] = 0x2C;
data[6] = 0x3F;
data[7] = 0x44;
data[8] = 0x51;
data[9] = 0x2F;
data[10] = 0x1F;
data[11] = 0x1F;
data[12] = 0x20;
data[13] = 0x23;
LCD_WR_REG(0xE1);
LCD_WR_DATA2(data, 14);
#endif

LCD_WR_REG(0x21); 
//cmd = 0x21;
//tls_spi_write(&cmd, 1);

LCD_WR_REG(0x11); 
//Delay (120); 
//cmd = 0x11;
//tls_spi_write(&cmd, 1);

LCD_WR_REG(0x29); 
//cmd = 0x29;
//tls_spi_write(&cmd, 1);
} 

//
//Color:Ҫɫ
void LCD_Clear(u16 Color)
{
	u16 i;//,j;  	
	u8 data[LCD_H * 2];
	Address_set(0,0,LCD_W-1,LCD_H-1);
	for (i = 0; i < LCD_H * 2; i++)
	{
	    if (0 == i % 2)
            data[i] = Color >> 8;
        else
            data[i] = Color & 0xff;
	}
    for(i=0;i<LCD_W;i++)
	 {
	    LCD_WR_DATA2(data, LCD_H * 2);
#if 0
	  for (j=0;j<LCD_H;j++)
	   	{
        	LCD_WR_DATA(Color);	 			 
	    }
#endif
	  }
}



//ָλʾһ(32*33С)
//dcolorΪɫgbcolorΪɫ
void showhanzi(unsigned int x,unsigned int y,unsigned char index)	
{  
	unsigned char i,j;
	unsigned char *temp=hanzi;    
    Address_set(x,y,x+31,y+31); //      
	temp+=index*128;	
	for(j=0;j<128;j++)
	{
		for(i=0;i<8;i++)
		{ 		     
		 	if((*temp&(1<<i))!=0)
			{
				LCD_WR_DATA(POINT_COLOR);
			} 
			else
			{
				LCD_WR_DATA(BACK_COLOR);
			}   
		}
		temp++;
	 }
}
//
//POINT_COLOR:˵ɫ
void LCD_DrawPoint(u16 x,u16 y)
{
	Address_set(x,y,x,y);//ùλ 
	LCD_WR_DATA(POINT_COLOR); 	    
} 	 
//һ
//POINT_COLOR:˵ɫ
void LCD_DrawPoint_big(u16 x,u16 y)
{
	LCD_Fill(x-1,y-1,x+1,y+1,POINT_COLOR);
} 
//ָָɫ
//С:
//  (xend-xsta)*(yend-ysta)
void LCD_Fill(u16 xsta,u16 ysta,u16 xend,u16 yend,u16 color)
{          
	u16 i,j; 
	Address_set(xsta,ysta,xend,yend);      //ùλ 
	for(i=ysta;i<=yend;i++)
	{													   	 	
		for(j=xsta;j<=xend;j++)LCD_WR_DATA(color);//ùλ 	    
	} 					  	    
}  
//
//x1,y1:
//x2,y2:յ  
void LCD_DrawLine(u16 x1, u16 y1, u16 x2, u16 y2)
{
	u16 t; 
	int xerr=0,yerr=0,delta_x,delta_y,distance; 
	int incx,incy,uRow,uCol; 

	delta_x=x2-x1; // 
	delta_y=y2-y1; 
	uRow=x1; 
	uCol=y1; 
	if(delta_x>0)incx=1; //õ 
	else if(delta_x==0)incx=0;//ֱ 
	else {incx=-1;delta_x=-delta_x;} 
	if(delta_y>0)incy=1; 
	else if(delta_y==0)incy=0;//ˮƽ 
	else{incy=-1;delta_y=-delta_y;} 
	if( delta_x>delta_y)distance=delta_x; //ѡȡ 
	else distance=delta_y; 
	for(t=0;t<=distance+1;t++ )// 
	{  
		LCD_DrawPoint(uRow,uCol);// 
		xerr+=delta_x ; 
		yerr+=delta_y ; 
		if(xerr>distance) 
		{ 
			xerr-=distance; 
			uRow+=incx; 
		} 
		if(yerr>distance) 
		{ 
			yerr-=distance; 
			uCol+=incy; 
		} 
	}  
}    
//
void LCD_DrawRectangle(u16 x1, u16 y1, u16 x2, u16 y2)
{
	LCD_DrawLine(x1,y1,x2,y1);
	LCD_DrawLine(x1,y1,x1,y2);
	LCD_DrawLine(x1,y2,x2,y2);
	LCD_DrawLine(x2,y1,x2,y2);
}
//ָλûһָСԲ
//(x,y):ĵ
//r    :뾶
void Draw_Circle(u16 x0,u16 y0,u8 r)
{
	int a,b;
	int di;
	a=0;b=r;	  
	di=3-(r<<1);             //ж¸λõı־
	while(a<=b)
	{
		LCD_DrawPoint(x0-b,y0-a);             //3           
		LCD_DrawPoint(x0+b,y0-a);             //0           
		LCD_DrawPoint(x0-a,y0+b);             //1       
		LCD_DrawPoint(x0-b,y0-a);             //7           
		LCD_DrawPoint(x0-a,y0-b);             //2             
		LCD_DrawPoint(x0+b,y0+a);             //4               
		LCD_DrawPoint(x0+a,y0-b);             //5
		LCD_DrawPoint(x0+a,y0+b);             //6 
		LCD_DrawPoint(x0-b,y0+a);             
		a++;
		//ʹBresenham㷨Բ     
		if(di<0)di +=4*a+6;	  
		else
		{
			di+=10+4*(a-b);   
			b--;
		} 
		LCD_DrawPoint(x0+a,y0+b);
	}
} 
//ָλʾһַ

//num:Ҫʾַ:" "--->"~"
//mode:ӷʽ(1)Ƿǵӷʽ(0)
//ָλʾһַ

//num:Ҫʾַ:" "--->"~"

//mode:ӷʽ(1)Ƿǵӷʽ(0)
void LCD_ShowChar(u16 x,u16 y,u8 num,u8 mode)
{
    u8 temp;
    u8 pos,t;
	u16 x0=x;
	u16 colortemp=POINT_COLOR;      
    if(x>LCD_W-16||y>LCD_H-16)return;	    
	//ô		   
	num=num-' ';//õƫƺֵ
	Address_set(x,y,x+8-1,y+16-1);      //ùλ 
	if(!mode) //ǵӷʽ
	{
		for(pos=0;pos<16;pos++)
		{ 
			temp=asc2_1608[(u16)num*16+pos];		 //1608
			for(t=0;t<8;t++)
		    {                 
		        if(temp&0x01)POINT_COLOR=colortemp;
				else POINT_COLOR=BACK_COLOR;
				LCD_WR_DATA(POINT_COLOR);	
				temp>>=1; 
				x++;
		    }
			x=x0;
			y++;
		}	
	}else//ӷʽ
	{
		for(pos=0;pos<16;pos++)
		{
		    temp=asc2_1608[(u16)num*16+pos];		 //1608
			for(t=0;t<8;t++)
		    {                 
		        if(temp&0x01)LCD_DrawPoint(x+t,y+pos);//һ     
		        temp>>=1; 
		    }
		}
	}
	POINT_COLOR=colortemp;	    	   	 	  
}   
//m^n
u32 mypow(u8 m,u8 n)
{
	u32 result=1;	 
	while(n--)result*=m;    
	return result;
}			 
//ʾ2
//x,y :	 
//len :ֵλ
//color:ɫ
//num:ֵ(0~4294967295);	
void LCD_ShowNum(u16 x,u16 y,u32 num,u8 len)
{         	
	u8 t,temp;
	u8 enshow=0;
	num=(u16)num;
	for(t=0;t<len;t++)
	{
		temp=(num/mypow(10,len-t-1))%10;
		if(enshow==0&&t<(len-1))
		{
			if(temp==0)
			{
				LCD_ShowChar(x+8*t,y,' ',0);
				continue;
			}else enshow=1; 
		 	 
		}
	 	LCD_ShowChar(x+8*t,y,temp+48,0); 
	}
} 
//ʾ2
//x,y:
//num:ֵ(0~99);	 
void LCD_Show2Num(u16 x,u16 y,u16 num,u8 len)
{         	
	u8 t,temp;						   
	for(t=0;t<len;t++)
	{
		temp=(num/mypow(10,len-t-1))%10;
	 	LCD_ShowChar(x+8*t,y,temp+'0',0); 
	}
} 
//ʾַ
//x,y:  
//*p:ַʼַ
//16
void LCD_ShowString(u16 x,u16 y,const u8 *p)
{         
    while(*p!='\0')
    {       
        if(x>LCD_W-16){x=0;y+=16;}
        if(y>LCD_H-16){y=x=0;LCD_Clear(RED);}
        LCD_ShowChar(x,y,*p,0);
        x+=8;
        p++;
    }  
}




































