/*****************************************************************************
*
* vcc(3.3)   --- vcc
* gnd        --- gnd
* 
* cs(BLK)    --- PB15
* ck(CLK)    --- PB16
* do(DIN)    --- PB18
*
* reset(RES) --- PB13
* di(DC)     --- PB14
* 
*****************************************************************************/
#include "wm_include.h"
#include "wm_flash_map.h"
#include "wm_io.h"
#include "wm_gpio.h"

#include "oled.h"
#include "bmp.h"

void xianshi(void)//ʾϢ
{
	BACK_COLOR = WHITE;
	POINT_COLOR = RED;

    LCD_ShowString(10, 35, "WinnerMicro W60X");
	LCD_ShowString(10, 55, "LCD_W:");

	LCD_ShowNum(70, 55, LCD_W, 3);

	LCD_ShowString(110, 75, "look photo --->");
	
	showhanzi(115, 0, 3);  //
	showhanzi(150, 0, 4);  //

	LCD_ShowNum(160, 55, LCD_H, 3);
}

static void showimage(void)
{
    int i;
    Address_set(0, 0, 239, 319);

    for (i = 0; i < (sizeof(gImage_0) / SPI_DMA_BUF_MAX_SIZE); i++)
    {
        LCD_WR_DATA2((u8 *)gImage_0 + i * SPI_DMA_BUF_MAX_SIZE, SPI_DMA_BUF_MAX_SIZE);
    }

    if (0 != (sizeof(gImage_0) % SPI_DMA_BUF_MAX_SIZE))
        LCD_WR_DATA2((u8 *)gImage_0 + i * SPI_DMA_BUF_MAX_SIZE, sizeof(gImage_0) % SPI_DMA_BUF_MAX_SIZE);
}

void UserMain(void)
{
	printf("\n user task\n");

    Lcd_Init();			//ʼOLED

	LCD_Clear(WHITE); //

	tls_os_time_delay(500);

	xianshi(); //ʾϢ

	tls_os_time_delay(500);

	showimage();


#if DEMO_CONSOLE
	CreateDemoTask();
#endif
//ûԼtask
}

