#include <string.h>
#include "wm_include.h"
#include "wm_flash_map.h"
#include "wm_internal_flash.h"
#include "wm_rtc.h"

#define DEMO_TASK_PRIO                  32
#define DEMO_TASK_STK_SIZE              2048

#define DEMO_LOG_UPLOAD_CACHE_SIZE     (32 * 1024) /* ֽ */
#define DEMO_LOG_TIME_FORMAT           "<%02d.%02d %02d:%02d:%02d> "

#define DEMO_LOG_USE_LOCK               1
#define DEMO_LOG_USE_NTP                1
#define DEMO_LOG_SAVE                   1

static OS_STK demo_task_stk[DEMO_TASK_STK_SIZE / sizeof(OS_STK)];

static u8 demo_log_buf[DEMO_LOG_UPLOAD_CACHE_SIZE];
static u32 demo_log_curr_len = 0;

#if DEMO_LOG_USE_LOCK
static tls_os_sem_t *demo_log_sem = NULL;
#endif

#if DEMO_LOG_USE_NTP
static u8   demo_log_not_end  = 0;
static char demo_log_tm[32];
#endif

#if DEMO_LOG_SAVE
#define DEMO_LOG_BUF_LEN_MAX            1024
static u32 demo_log_save_max;
static u32 demo_log_len_addr;
static u32 demo_log_con_addr;
#endif

#if DEMO_LOG_SAVE
static void demo_log_save(void)
{
    int ret;
    u32 pos   = 0;
    u32 total = 0;
    u32 offset;

    ret = tls_fls_read(demo_log_len_addr, (u8 *)&total, sizeof(u32));
    if (TLS_FLS_STATUS_OK == ret)
    {
        if (0xFFFFFFFF == total)/* µģ */
        {
            total = 0;
        }

        pos = total % demo_log_save_max;

        if ((demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE) <= (demo_log_save_max - pos))
        {
            tls_fls_write(demo_log_con_addr + pos, demo_log_buf, demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE);
        }
        else
        {
            offset = demo_log_save_max - pos;

            tls_fls_write(demo_log_con_addr + pos, demo_log_buf, offset);

            tls_fls_write(demo_log_con_addr, demo_log_buf + offset, (demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE) - offset);
        }

        total += (demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE);
        tls_fls_write(demo_log_len_addr, (u8 *)&total, sizeof(u32));

#if DEMO_LOG_USE_LOCK
        tls_os_sem_acquire(demo_log_sem, 0);
#endif

        demo_log_curr_len = 0;

#if DEMO_LOG_USE_LOCK
        tls_os_sem_release(demo_log_sem);
#endif

        //memset(demo_log_buf, 0, DEMO_LOG_UPLOAD_CACHE_SIZE);
    }

    return;
}

static void demo_log_print_flslog(void)
{
    int ret;
    u32 len    = 0;
    u32 total  = 0;
    u32 offset = 0;
    u8 *buf = NULL;

    buf = tls_mem_alloc(DEMO_LOG_BUF_LEN_MAX + 1);
    if (!buf)
    {
        return;
    }

    ret = tls_fls_read(demo_log_len_addr, (u8 *)&total, sizeof(u32));
    if (TLS_FLS_STATUS_OK == ret)
    {
        if (0xFFFFFFFF == total) /* µģ */
        {
            tls_mem_free(buf);
            return;
        }

        if (total > demo_log_save_max)
        {
            total = demo_log_save_max;
        }

        while (total > offset)
        {
            if ((total - offset) >= DEMO_LOG_BUF_LEN_MAX)
                len = DEMO_LOG_BUF_LEN_MAX;
            else
                len = total - offset;

            ret = tls_fls_read(demo_log_con_addr + offset, buf, len);
            if (TLS_FLS_STATUS_OK == ret)
            {
                offset += len;
                buf[len] = '\0';
                printf("%s", buf);
            }
        }

        total = 0;
        tls_fls_write(demo_log_len_addr, (u8 *)&total, sizeof(u32));
    }

    tls_mem_free(buf);

    return;
}
#endif

static void demo_log_print_cache(void)
{
    u32 total = 0;

#if DEMO_LOG_USE_LOCK
    tls_os_sem_acquire(demo_log_sem, 0);
#endif

    if (demo_log_curr_len > 0)
    {
#if DEMO_LOG_SAVE
        printf("flash cache log: [");
        demo_log_print_flslog();
        printf("]\r\n");
#endif
        if (demo_log_curr_len >= DEMO_LOG_UPLOAD_CACHE_SIZE)
            total = DEMO_LOG_UPLOAD_CACHE_SIZE;
        else
            total = demo_log_curr_len;

        demo_log_buf[total - 1] = '\0';

        printf("ram cache log: [%s]\r\n", demo_log_buf);

        demo_log_curr_len = 0;
        memset(demo_log_buf, 0, DEMO_LOG_UPLOAD_CACHE_SIZE);
    }

#if DEMO_LOG_USE_LOCK
    tls_os_sem_release(demo_log_sem);
#endif

    return;
}

/*
keil: fputcеdemo_log_write
gcc:  _write_rеdemo_log_write
iar:  __writeеdemo_log_write
ʵڲ: sendcharеdemo_log_writeдѭд...
*/
int demo_log_write(u8 c)
{
#if DEMO_LOG_USE_NTP
    struct tm logtb;
    int tm_len = 0;
    u8 is_tm = 0;
    u8 offset = 0;

    if ('\r' == c)
        return 0;
#endif

#if DEMO_LOG_USE_LOCK
    tls_os_sem_acquire(demo_log_sem, 0);
#endif

#if DEMO_LOG_USE_NTP
    if (0 != (demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE))
    {
        if ('\n' == demo_log_buf[(demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE) - 1])
        {
            is_tm = 1;
        }
    }
    else
    {
        if (!demo_log_not_end)
        {
            is_tm = 1;
        }
    }

    if (is_tm)
    {
        if (demo_log_not_end)
            demo_log_not_end = 0;

        tls_get_rtc(&logtb);
        tm_len = sprintf(demo_log_tm, DEMO_LOG_TIME_FORMAT, logtb.tm_mon + 1,
                                                            logtb.tm_mday,
                                                        	logtb.tm_hour,
                                                            logtb.tm_min,
                                                        	logtb.tm_sec);
        if ((DEMO_LOG_UPLOAD_CACHE_SIZE - (demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE)) >= (tm_len + 1))
        {
            memcpy(demo_log_buf + (demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE), demo_log_tm, tm_len);
        }
        else
        {
#if DEMO_LOG_SAVE
            demo_log_save();
#endif
            offset = DEMO_LOG_UPLOAD_CACHE_SIZE - (demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE);
            memcpy(demo_log_buf + (demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE), demo_log_tm, offset);
            memcpy(demo_log_buf, demo_log_tm + offset, tm_len - offset);
        }

        demo_log_curr_len   += tm_len;
    }
    else
    {
        if ((DEMO_LOG_UPLOAD_CACHE_SIZE - (demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE)) == 0)
        {
#if DEMO_LOG_SAVE
            demo_log_save();
#endif
        }
    }
#else
    if ((DEMO_LOG_UPLOAD_CACHE_SIZE - (demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE)) == 0)
    {
#if DEMO_LOG_SAVE
        demo_log_save();
#endif
    }
#endif

    memcpy(demo_log_buf + (demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE), &c, sizeof(u8));
    demo_log_curr_len   += sizeof(u8);

#if DEMO_LOG_USE_NTP
    if ((0 != demo_log_curr_len) && (0 == (demo_log_curr_len % DEMO_LOG_UPLOAD_CACHE_SIZE)))
    {
        if ('\n' != c)
            demo_log_not_end  = 1;
    }
#endif

#if DEMO_LOG_USE_LOCK
    tls_os_sem_release(demo_log_sem);
#endif

    return WM_SUCCESS;
}

static void demo_log_init(void)
{
#if DEMO_LOG_USE_LOCK
    tls_os_sem_create(&demo_log_sem, 1);
#endif

#if DEMO_LOG_SAVE
    demo_log_save_max = USER_AREA_LEN - sizeof(u32);
    demo_log_len_addr = USER_ADDR_START;
    demo_log_con_addr = demo_log_len_addr + sizeof(u32);
#endif

    demo_log_curr_len = 0;
    memset(demo_log_buf, 0, DEMO_LOG_UPLOAD_CACHE_SIZE);

    return;
}

static void demo_task_entry(void *sdata)
{
    demo_log_init();

    /* do something, ex printf xxxx... */
    tls_os_time_delay(3 * 60 * HZ);

    demo_log_print_cache();

	for( ; ; )
	{
        tls_os_time_delay(999999);
	}
}

void UserMain(void)
{
	printf("\n log cache demo\n");

    tls_os_task_create(NULL, "demo_task", demo_task_entry, NULL, (void *)demo_task_stk, DEMO_TASK_STK_SIZE, DEMO_TASK_PRIO, 0);
}

