#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>

#include "include/yc_basetype.h"
#include "include/yc_bt.h"
#include "include/yc_timer.h"
#include "include/yc_socket.h"
#include "include/yc_conf.h"
#include "include/yc_cli.h"

#define CONF_FILE_NAME  "../res/x.conf"
#define CONF_INFO_NAME  "info"
#define CONF_KEY_NAME   "loopcnt"

static yc_socket_server_s *g_udpsv = NULL;
static void *g_iTimerID = YC_TIMER_ID_INVALID;

static void exit_callback(IN int iSignalNum)
{
    YC_IGNOPARA(iSignalNum);

    yc_cli_destroy();

    if (NULL != g_udpsv)
    {
        yc_udp_server_destroy(g_udpsv);
        g_udpsv = NULL;
    }

    if (YC_TIMER_ID_INVALID != g_iTimerID)
    {
        yc_timer_del(g_iTimerID);
        g_iTimerID = YC_TIMER_ID_INVALID;
    }

    printf("app exit\r\n");
    exit(0);

    return;
}

static void timerexpir_callback(IN void *arg)
{
    int iRet = YC_ERROR_SUCCESS;
    long lData = 0;

    YC_IGNOPARA(arg);

    iRet = yc_conf_get_key_4long(CONF_FILE_NAME, CONF_INFO_NAME, CONF_KEY_NAME, &lData);
    if (YC_ERROR_SUCCESS != iRet)
    {
        printf("get conf faild.\r\n");
        exit_callback(0);
        return;
    }

    printf("get data %lu.\r\n", lData);

    return;
}

static void t_udp_server_rcv_pf(IN int iSockfd,         IN void *pArg,
                                IN const void *pData,   IN uint uiDataLen,
                                IN const char *pcSrcIP, IN ushort usSrcPort)
{
    printf("[%d]<%s:%hu> %u: %s\r\n", iSockfd, pcSrcIP, usSrcPort, uiDataLen, (char *)pData);
}

int main(IN int argc, IN char *argv[])
{
    int iRet;

    YC_IGNOPARA(argc);
    YC_IGNOPARA(argv);

    if (SIG_ERR == signal(SIGINT, exit_callback))
    {
        printf("signal singint failed.\r\n");
        return YC_ERROR_FAILED;
    }

    g_iTimerID = yc_timer_add(true, TIMER_UNIT_SC, 5, timerexpir_callback, NULL);
    if (YC_TIMER_ID_INVALID == g_iTimerID)
    {
        printf("add timer failed.\r\n");
        return YC_ERROR_FAILED;
    }

    g_udpsv = yc_udp_server_create(7788, t_udp_server_rcv_pf, NULL);
    printf("g_udpsv = %p\r\n", g_udpsv);

    iRet = yc_cli_create("yc-shell>");
    printf("pCli = %d\r\n", iRet);

    printf("app start\r\n");
    iRet = yc_cli_run(false);
    printf("Cli exit = %d\r\n", iRet);

    for ( ; ; )
    {
        sleep(10);
    }

    return YC_ERROR_SUCCESS;
}

