#include <linux/module.h>
#include <linux/uaccess.h>
#include <linux/fs.h>
#include <linux/cdev.h>
#include <linux/device.h>
#include <linux/slab.h>
#include <linux/netfilter.h>
#include <asm/rwlock.h>

#include "../../include/yc_opt.h"
#include "../../include/yc_basetype.h"
#include "../../include/yc_cioctl.h"
#include "../../include/list.h"


#define CIOCTL_DEVICE_COUNT 	    1
#define CIOCTL_DEVICE_MINOR         0

typedef struct tagCioctl_proc{
    struct list_head stNode;
    unsigned int uiCmd;
    yc_cioctl_proc_pf pfProcFunc;
}cioctl_proc_s;

static DEFINE_RWLOCK(g_stCioctlProcFunc_ListLock);
static struct list_head g_stCioctlProcFunc_ListHead = LIST_HEAD_INIT(g_stCioctlProcFunc_ListHead);

static int g_iCioctlMajorID = 0;
static struct cdev g_stCioctlCdev;
static struct class *g_stCioctlCls;
static struct device *g_stCioctlDev;

static int cioctl_proc(IN unsigned int uiCmd,
					   IN void *pInData, IN unsigned int uiInDataLen,
           			   OUT void *pOutBuf, IN unsigned int uiOutBufLen,
           			   OUT unsigned int *puiOutDataLen)
{
    int iRet = YC_ERROR_FAILED;
    cioctl_proc_s *pstProc = NULL;

    read_lock(&g_stCioctlProcFunc_ListLock);
    list_for_each_entry(pstProc, &g_stCioctlProcFunc_ListHead, stNode)
    {
        if (uiCmd == pstProc->uiCmd)
        {
            iRet = pstProc->pfProcFunc(pInData, uiInDataLen,
                                       pOutBuf, uiOutBufLen,
                                       puiOutDataLen);
            break;
        }
    }
    read_unlock(&g_stCioctlProcFunc_ListLock);

    return iRet;
}

static int cioctl_device_open(struct inode *inode, struct file *file)
{
	YC_DBG_PRINK("%s\n", __FUNCTION__);

	return 0;
}

static int cioctl_device_close(struct inode *inode, struct file *file)
{
	YC_DBG_PRINK("%s\n", __FUNCTION__);

	return 0;
}

static ssize_t cioctl_device_read(struct file *file, char __user *buffer,
								  size_t count, loff_t *ppos)
{
	YC_DBG_PRINK("%s\n", __FUNCTION__);

	return 0;
}
static ssize_t cioctl_device_write(struct file *file, const char __user *buffer,
								   size_t count, loff_t *ppos)
{
	YC_DBG_PRINK("%s\n", __FUNCTION__);

	return 0;
}

static long cioctl_device_unlocked_ioctl(struct file *file,
							             unsigned int uiCmd,
							             unsigned long arg)
{
	char *pcBuf = NULL;
	int iRet = YC_ERROR_FAILED;
	unsigned int uiBufLen = 0;
	unsigned int uiInDataLen = 0;
	unsigned int uiOutBufLen = 0;

    YC_DBG_PRINK("%s: yc_cioctl command %u!\n", __FUNCTION__, uiCmd);

	/* TLV: pcbuflen 4b, indatalen 4b, indata, outbuflen 4b, outdatalen 4b, outdata */
	if (0 != copy_from_user(&uiBufLen, (char *)arg, sizeof(unsigned int)))
	{
		return YC_ERROR_FAILED;
	}

	pcBuf = (char *)kmalloc(uiBufLen, GFP_KERNEL);
	if (NULL == pcBuf)
	{
		return YC_ERROR_FAILED;
	}

	memset(pcBuf, 0, uiBufLen);

	if (0 != copy_from_user(pcBuf, (char *)arg, uiBufLen))
	{
		kfree(pcBuf);
		return YC_ERROR_FAILED;
	}


	uiInDataLen = *(unsigned int *)(pcBuf + sizeof(unsigned int));
	uiOutBufLen = *(unsigned int *)(pcBuf + sizeof(unsigned int) + sizeof(unsigned int) + uiInDataLen);
    iRet = cioctl_proc(uiCmd,
    				   (void *)(pcBuf + sizeof(unsigned int) + sizeof(unsigned int)),
    				   uiInDataLen,
           			   (void *)(pcBuf + sizeof(unsigned int) + sizeof(unsigned int) + uiInDataLen + sizeof(unsigned int) + sizeof(unsigned int)),
           			   uiOutBufLen,
           			   (unsigned int *)(pcBuf + sizeof(unsigned int) + sizeof(unsigned int) + uiInDataLen + sizeof(unsigned int)));
	if (YC_ERROR_SUCCESS == iRet)
	{
	    if (0 != uiOutBufLen)
	    {
    		if (0 != copy_to_user((char *)arg, pcBuf, uiBufLen))
    		{
    			iRet = YC_ERROR_FAILED;
    		}
		}
	}

	kfree(pcBuf);

	return iRet;
}

#if 0
static int cioctl_device_ioctl(struct inode *inode, struct file *file,
							   unsigned int uiCmd, unsigned long arg)
{
	return cioctl_device_unlocked_ioctl(file, uiCmd, arg);
}
#endif

#if YC_CIOCTL_CFG_ASYN
static int cioctl_socket_set(struct sock *sk, int cmd, void __user *user, unsigned int len)
{
    char *pcBuf = NULL;
    int iRet = YC_ERROR_FAILED;

    YC_DBG_PRINK("%s\n", __FUNCTION__);

    pcBuf = (char *)kmalloc(len, GFP_KERNEL);
	if (NULL == pcBuf)
	{
		return YC_ERROR_FAILED;
	}

    memset(pcBuf, 0, len);

    if (0 == copy_from_user(pcBuf, (char *)user, len))
    {
        YC_DBG_PRINK("%s: yc_cioctl command %u!\n", __FUNCTION__, *(unsigned int *)(pcBuf + sizeof(unsigned char)));
        /* TLV: pos-1b, cmd-4b, indata*/
    	iRet = cioctl_proc(*(unsigned int *)(pcBuf + sizeof(unsigned char)),
    					   pcBuf + sizeof(unsigned char) + sizeof(unsigned int),
    					   len - sizeof(unsigned char) - sizeof(unsigned int),
               			   NULL, 0, NULL);
    }

    kfree(pcBuf);

    return iRet;
}

static int cioctl_socket_get(struct sock *sk, int cmd, void __user *user, int *len)
{
    YC_DBG_PRINK("%s\n", __FUNCTION__);

	return 0;
}
#endif

static struct file_operations g_stCioctldevicefops = {
	.owner		= THIS_MODULE,
	.open 		= cioctl_device_open,
	.release 	= cioctl_device_close,
	.read		= cioctl_device_read,
	.write		= cioctl_device_write,
	/* .ioctl		= cioctl_device_ioctl,//ںں޴˻ص */
	.unlocked_ioctl = cioctl_device_unlocked_ioctl,//ں˵ı
};

#if YC_CIOCTL_CFG_ASYN
static struct nf_sockopt_ops g_stCioctl_sockopts = {
	.pf		= PF_INET,
	.set_optmin	= YC_CIOCTL_SOCKET_OPS_SET,
	.set_optmax	= YC_CIOCTL_SOCKET_OPS_MAX,
	.set		= cioctl_socket_set,
	.get_optmin	= YC_CIOCTL_SOCKET_OPS_GET,
	.get_optmax	= YC_CIOCTL_SOCKET_OPS_MAX,
	.get		= cioctl_socket_get,
	.owner		= THIS_MODULE,
};
#endif

int yc_cioctl_init(void)
{
	int iRet;
	dev_t dev_id;

	YC_DBG_PRINK("%s: register yc_cioctl device\n", __FUNCTION__);

	if (g_iCioctlMajorID)
	{
		dev_id = MKDEV(g_iCioctlMajorID, 0);
		iRet = register_chrdev_region(dev_id, CIOCTL_DEVICE_COUNT, YC_CIOCTL_DEVICE_NAME);
	}
	else
	{
		iRet = alloc_chrdev_region(&dev_id, CIOCTL_DEVICE_MINOR,
								   CIOCTL_DEVICE_COUNT, YC_CIOCTL_DEVICE_NAME);
		g_iCioctlMajorID = MAJOR(dev_id);
		//YC_DBG_PRINK("%s: g_iCioctlMajorID = %d\n", __FUNCTION__, g_iCioctlMajorID);
	}

	if (iRet)
	{
		YC_DBG_PRINK("%s: Cannot register yc_cioctl device\n", __FUNCTION__);
		goto failure_register_cioctl_device;
	}

	cdev_init(&g_stCioctlCdev, &g_stCioctldevicefops);
	iRet = cdev_add(&g_stCioctlCdev, dev_id, CIOCTL_DEVICE_COUNT);
	if (iRet < 0)
	{
		YC_DBG_PRINK("%s: add g_stCioctlCdev failed.\n", __FUNCTION__);
		goto failure_add_cioctl_cdev;
	}

	g_stCioctlCls = class_create(THIS_MODULE, YC_CIOCTL_DEVICE_NAME);
	if (IS_ERR(g_stCioctlCls))
	{
		YC_DBG_PRINK("Cannot create yc_cioctl class!\n");
		iRet = PTR_ERR(g_stCioctlCls);
		goto failure_create_cioctl_class;
	}

	g_stCioctlDev = device_create(g_stCioctlCls, NULL, dev_id, NULL, YC_CIOCTL_DEVICE_NAME);
	if (IS_ERR(g_stCioctlDev))
	{
		YC_DBG_PRINK("Cannot create yc_cioctl device!\n");
		iRet = PTR_ERR(g_stCioctlDev);
		goto failure_create_cioctl_device;
	}

#if YC_CIOCTL_CFG_ASYN
    iRet = nf_register_sockopt(&g_stCioctl_sockopts);
    if (iRet)
	{
		YC_DBG_PRINK("%s: register yc_cioctl socket failed.\n", __FUNCTION__);
		goto failure_register_cioctl_socket;
	}
#endif

	return YC_ERROR_SUCCESS;

#if YC_CIOCTL_CFG_ASYN
failure_register_cioctl_socket:
    device_destroy(g_stCioctlCls, dev_id);
#endif

failure_create_cioctl_device:
	class_destroy(g_stCioctlCls);

failure_create_cioctl_class:
	cdev_del(&g_stCioctlCdev);

failure_add_cioctl_cdev:
	unregister_chrdev_region(dev_id, CIOCTL_DEVICE_COUNT);

failure_register_cioctl_device:

	return YC_ERROR_FAILED;
}

void yc_cioctl_fini(void)
{
	dev_t dev_id;

	YC_DBG_PRINK("%s: unregister yc_cioctl device\n", __FUNCTION__);

#if YC_CIOCTL_CFG_ASYN
    nf_unregister_sockopt(&g_stCioctl_sockopts);
#endif

	dev_id = MKDEV(g_iCioctlMajorID, 0);
	device_destroy(g_stCioctlCls, dev_id);
	class_destroy(g_stCioctlCls);
	cdev_del(&g_stCioctlCdev);
	unregister_chrdev_region(dev_id, CIOCTL_DEVICE_COUNT);

	return;
}

int yc_cioctl_register(IN uint uiCmd, IN yc_cioctl_proc_pf pfProcFunc)
{
    int iRet = YC_ERROR_FAILED;
    cioctl_proc_s *pstProc = NULL;

    pstProc = (cioctl_proc_s *)kmalloc(sizeof(cioctl_proc_s), GFP_KERNEL);
    if (NULL != pstProc)
    {
        memset(pstProc, 0, sizeof(cioctl_proc_s));
        pstProc->uiCmd = uiCmd;
        pstProc->pfProcFunc = pfProcFunc;
        write_lock(&g_stCioctlProcFunc_ListLock);
        list_add(&(pstProc->stNode), &g_stCioctlProcFunc_ListHead);
        write_unlock(&g_stCioctlProcFunc_ListLock);
        iRet = YC_ERROR_SUCCESS;
    }

    return iRet;
}
EXPORT_SYMBOL(yc_cioctl_register);

void yc_cioctl_deregister(IN uint uiCmd)
{
    cioctl_proc_s *pstProc = NULL;
    cioctl_proc_s *pstNextProc = NULL;

    write_lock(&g_stCioctlProcFunc_ListLock);
    list_for_each_entry_safe(pstProc, pstNextProc, &g_stCioctlProcFunc_ListHead, stNode)
    {
        if (uiCmd == pstProc->uiCmd)
        {
            list_del(&(pstProc->stNode));
            kfree(pstProc);
            break;
        }
    }
    write_unlock(&g_stCioctlProcFunc_ListLock);

    return;
}
EXPORT_SYMBOL(yc_cioctl_deregister);

