#ifndef __YC_HLS_H__
#define __YC_HLS_H__

/***************************************************************
 *             http liv stream ؽӿ                        *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2016 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


typedef struct tagHls_handle yc_hls_s;

typedef enum tagHls_media_type{
    YC_HLS_MEDIA_UNKNOWN = 0,

    YC_HLS_MEDIA_MP3,
    YC_HLS_MEDIA_AAC,
    YC_HLS_MEDIA_MP4
}yc_hls_media_e;

/*****************************************************************************
   (Prototype)    : yc_hls_open
 (Description)  : һhls
 (Input)        : pcUrl         hlsַ
 (Output)       : (None)
   ֵ(Return Value) : yc_hls_s*    !NULL       ɹ(success)
                                        NULL       ɹʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/8/20
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
yc_hls_s *yc_hls_open(IN const char *pcUrl);

/*****************************************************************************
   (Prototype)    : yc_hls_read
 (Description)  : ȡhlsýݣ
                          ǰҪдpuiVedioLenpuiAudioLen
                          ǷtsĸʽýֻpcVedio
 (Input)        : pstHls          hls
 (Output)       : pcVedio         Ƶ
                          puiVedioLen     ƵС/ʵƵС
                          peVedioType     Ƶ
                          pcAudio         Ƶ
                          puiAudioLen     ƵС/ʵƵС
                          peAudioType     Ƶ
   ֵ(Return Value) : int    YC_ERROR_SCUCCESS       ȡɹ(success)
                                 other                   ȡʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/8/20
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_hls_read(IN yc_hls_s *pstHls,
                OUT char *pcVedio, INOUT uint *puiVedioLen,
                OUT yc_hls_media_e *peVedioType,
                OUT char *pcAudio, INOUT uint *puiAudioLen,
                OUT yc_hls_media_e *peAudioType);

/*****************************************************************************
   (Prototype)    : yc_hls_close
 (Description)  : رhls
 (Input)        : pstHls         hls
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/8/20
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_hls_close(IN yc_hls_s *pstHls);

#endif /* __YC_HLS_H__ */

