#ifndef __YC_DEBUG_H__
#define __YC_DEBUG_H__

/***************************************************************
 *               Ϣӡӿ                          *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2014 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


typedef enum tagDebug_type{
    YC_DEBUG_TYPE_EVENT,  /* ¼Ϣ */
    YC_DEBUG_TYPE_ERROR,  /* Ϣ */
    YC_DEBUG_TYPE_INFO    /* ʾϢ */
}yc_debug_type_e;


#if YC_OPT_MEM_DEBUG
void *__yc_malloc(const char *func, int line, uint size);
void __yc_free(void *ptr);
#endif

#ifdef YC_DEBUG
void __yc_debug_print(IN yc_debug_type_e enType, IN const char *pcFunc, IN const char *pcFormat, ...);
#endif

void __yc_sys_log(IN yc_debug_type_e enType, IN const char *pcFunc, IN const char *pcFormat, ...);




#ifdef YC_DEBUG
/*****************************************************************************
   (Prototype)    : yc_debug_print
 (Description)  : ӡϢ
 (Input)        : enType        Ϣ
                          pcFormat      ַʽ
                          arg...        ַʽ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/25
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_debug_print(enType, pcFormat, arg...)          __yc_debug_print(enType, __FUNCTION__, pcFormat, ##arg)
#else
#define yc_debug_print(enType, pcFormat, arg...)
#endif



/*****************************************************************************
   (Prototype)    : yc_open_log
 (Description)  : logsyslogLOG_LOCAL2,
                          debugʾ׼ʱlogļ
 (Input)        : szIdent        logʶ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/25
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_open_log(IN const char *szIdent);

/*****************************************************************************
   (Prototype)    : yc_sys_log
 (Description)  : logϢ͡ĺ
 (Input)        : enType        Ϣ
                          pcFormat      ַʽ
                          arg...        ַʽ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/25
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_sys_log(enType, pcFormat, arg...)      __yc_sys_log(enType, __FUNCTION__, pcFormat, ##arg)

/*****************************************************************************
   (Prototype)    : yc_sys_log2
 (Description)  : logϢ͡ĺ
 (Input)        : enType        Ϣ
                          pcFormat      ַʽ
                          arg...        ַʽ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/25
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_sys_log2(IN yc_debug_type_e enType, IN const char *pcFormat, ...);

/*****************************************************************************
   (Prototype)    : yc_close_log
 (Description)  : رlog
 (Input)        : szIdent        logʶ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/25
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_close_log(void);

/*****************************************************************************
   (Prototype)    : yc_open_log6
 (Description)  : logsyslogLOG_LOCAL6,
                          debuglogʱlogļ
                          رyc_close_log
 (Input)        : szIdent        logʶ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/25
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_open_log6(IN const char *szIdent);

/*****************************************************************************
   (Prototype)    : yc_sys_log6
 (Description)  : log
 (Input)        : pcFormat      ַʽ
                          arg...        ַʽ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/25
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_sys_log6(IN const char *pcFormat, ...);

/*****************************************************************************
   (Prototype)    : yc_sys_vlog6
 (Description)  : log
 (Input)        : pcFormat      ַʽ
                          vList         
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/25
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_sys_vlog6(IN const char *pcFormat, IN va_list vList);

#if YC_OPT_MEM_DEBUG
/*****************************************************************************
   (Prototype)    : yc_malloc_show
 (Description)  : ӡѾڴ
 (Input)        : (None)
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/25
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_malloc_show(void);

/*****************************************************************************
   (Prototype)    : yc_malloc
 (Description)  : ڴ
 (Input)        : size          ڴС
 (Output)       : (None)
   ֵ(Return Value) : void*         !NULL       ɹ(success)
                                         NULL       ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/25
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_malloc(size)             __yc_malloc(__FUNCTION__, __LINE__, size)

/*****************************************************************************
   (Prototype)    : yc_free
 (Description)  : ͷڴ
 (Input)        : ptr            ڴ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/25
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
#define yc_free(ptr)                        __yc_free(ptr)
#else
#define yc_malloc                           malloc
#define yc_free                             free
#endif

#endif /* __YC_DEBUG_H__ */

