#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "../include/yc_opt.h"
#include "../include/yc_basetype.h"

#define YC_VERSION_LEN_MAX              128

static char yc_version_str_src[YC_VERSION_LEN_MAX];
static char yc_version_str_cur[YC_VERSION_LEN_MAX];

static void yc_daemon_close_allfd(bool_t bIsNoCloseStdFd)
{
	char buf[32] = {0};
	FILE *fp;
	pid_t pid;
	char *pos;
	int fd;

	pid = getpid();

    sprintf(buf, "ls /proc/%d/fd", pid);

	fp = popen(buf, "r");
	if (!fp)
	{
		return;
	}

    memset(buf, 0, 32);
	while (pos = fgets(buf, 32, fp))
	{
	    //fprintf(stderr, "buf='%s'\n", buf);
        fd = atoi(pos);
        //fprintf(stderr, "fd=%d\n", fd);
        if (bIsNoCloseStdFd && ((0 == fd) || (1 == fd) || (2 == fd)))
        {

		}
        else
		{
            close(fd);
		}

        memset(buf, 0, 32);
	}

	pclose(fp);

	return;
}

/* ʵunix߼̣fd */
static int yc_daemon_is_running(const char *pcName)
{
    char acBuf[128];
    struct flock fl;
    int iRet;
    int iFd;

    sprintf(acBuf, "/var/run/%sd.pid", pcName);
    iFd = open(acBuf, O_RDWR | O_CREAT, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
    if (0 > iFd)
    {
        return YC_ERROR_FAILED;
    }

    memset(&fl, 0, sizeof(struct flock));
    fl.l_type = F_WRLCK;
    fl.l_start = 0;
    fl.l_whence = SEEK_SET;
    fl.l_len = 0;
    fl.l_pid = getpid();

    iRet = fcntl(iFd, F_SETLK, &fl);/* ȴ */
    if (0 != iRet)
    {
        if ((EACCES == errno) || (EAGAIN == errno))
        {
            /* repeat run */
        }
        else
        {
             /* can not lock file */
        }
        close(iFd);
        return YC_ERROR_FAILED;
    }

    iRet = ftruncate(iFd, 0);
    if (0 != iRet)
    {
        close(iFd);
        return YC_ERROR_FAILED;
    }

    sprintf(acBuf, "%ld\r\n", (long)getpid());
    iRet = write(iFd, acBuf, strlen(acBuf) + 1);
    if (0 > iRet)
    {
        close(iFd);
        return YC_ERROR_FAILED;
    }

    return iFd;
}

static int yc_daemon_rlock(int iFd)
{
    char acBuf[18];
    struct flock fl;
    int iRet;

    memset(&fl, 0, sizeof(struct flock));
    fl.l_type = F_WRLCK;
    fl.l_start = 0;
    fl.l_whence = SEEK_SET;
    fl.l_len = 0;
    fl.l_pid = getpid();

    iRet = fcntl(iFd, F_SETLKW, &fl);/* ȴ */
    if (0 != iRet)
    {
        if ((EACCES == errno) || (EAGAIN == errno))
        {
            /* repeat run */
        }
        else
        {
            /* can not lock file */
        }

        return YC_ERROR_FAILED;
    }

    iRet = ftruncate(iFd, 0);
    if (0 != iRet)
    {
        return YC_ERROR_FAILED;
    }

    sprintf(acBuf, "%ld\r\n", (long)getpid());
    iRet = write(iFd, acBuf, strlen(acBuf) + 1);
    if (0 > iRet)
    {
        return YC_ERROR_FAILED;
    }

    return YC_ERROR_SUCCESS;
}

static void yc_daemon_run(bool_t bIsNoCloseStdFd)
{
    pid_t stPid;

    stPid = fork();
    if (stPid > 0)
    {
        exit(YC_ERROR_SUCCESS);
    }
    else if (stPid < 0)
    {
        exit(YC_ERROR_FAILED);
    }

    stPid = setsid();
    if (stPid < 0)
    {
        exit(YC_ERROR_FAILED);
    }

    stPid = fork();
    if (stPid > 0)
    {
        exit(YC_ERROR_SUCCESS);
    }
    else if (stPid < 0)
    {
        exit(YC_ERROR_FAILED);
    }

    /* ĵǰĿ¼(̳и̵ĵǰĿ¼) */
	chdir("/");

    /* ػ̵ļȨ޴ */
    umask(0);
	
	/* رļض׼롢豸dup2(dev/null, STDIN/OUT/ERR); */
    yc_daemon_close_allfd(bIsNoCloseStdFd);

    return;
}

int yc_daemon_create(IN const char *pcName, IN bool_t bIsNoCloseStdFd)
{
    int ret;

    ret = yc_daemon_is_running(pcName);
    if (ret < 0)
    {
        return YC_ERROR_FAILED;
    }

    yc_daemon_run(bIsNoCloseStdFd);

    /* fdɽ˳֮ϵͳգݲǻ */
    ret = yc_daemon_rlock(ret);

    return ret;
}

char *yc_version(void)
{
    char *arch;
    char *host;
    char *type;
    FILE *fp;
    char buf[YC_VERSION_LEN_MAX];

    fp = popen("uname -a", "r");
	if (!fp)
	{
		return yc_version_str_cur;
	}

    memset(buf, 0, YC_VERSION_LEN_MAX);
	if (NULL == fgets(buf, YC_VERSION_LEN_MAX, fp))
    {
        return yc_version_str_cur;
    }

    pclose(fp);

    if (0 == strncasecmp(buf, "Linux", strlen("Linux")))
    {
        host = "linux";
    }
    else if (0 == strncasecmp(buf, "CYGWIN", strlen("CYGWIN")))
    {
        host = "windows";
    }
    else
    {
        host = "unkown host";
    }

    if (4 == sizeof(ulong))
    {
        arch = "x86_32";
    }
    else if (8 == sizeof(ulong))
    {
        arch = "x86_64";
    }
    else
    {
        arch = "";
    }

#if (YC_LINUX_LITE || YC_WINDOWS_LITE)
    type = "lite";
#else
    type = "";
#endif

    sprintf(yc_version_str_src, "%s %s %s, %s", host, arch, type, YC_LIB_VERSION);
    strcpy(yc_version_str_cur, yc_version_str_src);

    return yc_version_str_cur;
}

