#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include <stdarg.h>

#include "../include/yc_opt.h"
#if !YC_LINUX_LITE
#include <sys/timerfd.h>
#endif

#include "../include/yc_basetype.h"
#include "../include/yc_timer.h"
#include "../include/yc_debug.h"


/* ==============================================
   뼶ʱ̻߳ƴÿֻܴ߳һ
   ˶ʱʱ -lrt ѡ
================================================= */


struct timer_data{
    yc_timer_callback_pf callback;     /* ʱʱص */
    void *arg;                      /* ʱʱص */
};

struct timer_handle{
    struct timer_data *p;           /* ʱʱ */
    timer_t timerid;                /* ʱid*/
};

struct timer_count{
    unsigned int count;                     /* ѾĶʱ */
    struct timer_handle handle[TIMER_NUM_MAX];  /* ʱ */
};

/* ¼Ķʱʱ */
static struct timer_count g_stdata;

/* ʱʱص */
static void expire_func(IN union sigval data)
{
    struct timer_data *p;

    p = (struct timer_data *)data.sival_ptr;

    /* ִʵעĳʱص */
    p->callback(p->arg);
}

/* ʱɹضʱidʧܷERROR_FAILED */
/* bIsLoopѭͷѭʱintervalʱ */
/* callbackΪʱصΪ; argΪʱصΪ */
void *yc_timer_add(IN bool_t bIsLoop,
                   IN yc_timer_unit_e enUnit, IN int interval,
                   IN yc_timer_callback_pf callback, IN void *arg)
{
    int ret;
    timer_t timerid;
    unsigned int count;
    struct sigevent stevp;
    struct itimerspec stvalue;
    struct timer_data *p = NULL;

    /* ж */
    if ((1 < bIsLoop) || (NULL == callback) || (TIMER_NUM_MAX <= g_stdata.count))
    {
        YC_DBG_PRINT("Parameter error.\r\n");
        return YC_TIMER_ID_INVALID;
    }

    /* ڴ */
    p = (struct timer_data *)yc_malloc(sizeof(struct timer_data));
    if (NULL == p)
    {
        YC_DBG_PRINT("memory no enough.\r\n");
        return YC_TIMER_ID_INVALID;
    }

    /* 泬ʱص */
    memset(p, 0, sizeof(struct timer_data));
    p->callback = callback;
    p->arg = arg;

    /* ԣ̴߳ʱ */
    memset(&stevp, 0, sizeof(stevp));
    stevp.sigev_notify = SIGEV_THREAD;
    stevp.sigev_value.sival_ptr = p;
    stevp.sigev_notify_function = expire_func;

    /* ʱ */
    ret = timer_create(CLOCK_REALTIME, &stevp, &timerid);
    if (0 > ret)
    {
        YC_DBG_PERROR("timer_create");
        yc_free(p);
        return YC_TIMER_ID_INVALID;
    }

    /* ȫֳʱݣȫֱĬϳʼȻΪ0 */
    for (count = 0; count < TIMER_NUM_MAX; count++)
    {
        if (0 == g_stdata.handle[count].timerid)
        {
            g_stdata.handle[count].p = p;
            g_stdata.handle[count].timerid = timerid;
            g_stdata.count++;
            break;
        }
    }

    /* 䳬ʱʱ */
    memset(&stvalue, 0, sizeof(stvalue));
    if (TIMER_UNIT_SC == enUnit)
    {
        stvalue.it_value.tv_sec = interval;
    }
    else if (TIMER_UNIT_MS == enUnit)
    {
        stvalue.it_value.tv_nsec = interval * 1000000;
    }
    else if (TIMER_UNIT_US == enUnit)
    {
        stvalue.it_value.tv_nsec = interval * 1000;
    }
    else if (TIMER_UNIT_NS == enUnit)
    {
        stvalue.it_value.tv_nsec = interval;
    }

    if (true == bIsLoop)
    {
        if (TIMER_UNIT_SC == enUnit)
        {
            stvalue.it_interval.tv_sec = interval;
        }
        else if (TIMER_UNIT_MS == enUnit)
        {
            stvalue.it_interval.tv_nsec = interval * 1000000;
        }
        else if (TIMER_UNIT_US == enUnit)
        {
            stvalue.it_interval.tv_nsec = interval * 1000;
        }
        else if (TIMER_UNIT_NS == enUnit)
        {
            stvalue.it_interval.tv_nsec = interval;
        }
    }

    /* óʱʱ */
    ret = timer_settime(timerid, 0, &stvalue, NULL);
    if (0 > ret)
    {
        YC_DBG_PERROR("timer_settime");
        yc_free(p);
        if(timer_delete(timerid))
        {
            YC_DBG_PERROR("timer_delete");
        }

        return YC_TIMER_ID_INVALID;
    }

    return (void *)((long)timerid);
}

/* ʱ޸ĺ޸֮¼ʱɹ0ʧܷERROR_FAILED */
/* bIsLoopѭͷѭʱintervalʱ */
int yc_timer_mod(IN void *pTmHd,
                 IN bool_t bIsLoop,
                 IN yc_timer_unit_e enUnit,
                 IN int interval)
{
    long timer_id;
    int ret = YC_ERROR_FAILED;
    struct itimerspec stvalue;

    timer_id = (long)pTmHd;

    /* µĳʱʱ */
    memset(&stvalue, 0, sizeof(stvalue));
    if (TIMER_UNIT_SC == enUnit)
    {
        stvalue.it_value.tv_sec = interval;
    }
    else if (TIMER_UNIT_MS == enUnit)
    {
        stvalue.it_value.tv_nsec = interval * 1000000;
    }
    else if (TIMER_UNIT_US == enUnit)
    {
        stvalue.it_value.tv_nsec = interval * 1000;
    }
    else if (TIMER_UNIT_NS == enUnit)
    {
        stvalue.it_value.tv_nsec = interval;
    }

    if (true == bIsLoop)
    {
        if (TIMER_UNIT_SC == enUnit)
        {
            stvalue.it_interval.tv_sec = interval;
        }
        else if (TIMER_UNIT_MS == enUnit)
        {
            stvalue.it_interval.tv_nsec = interval * 1000000;
        }
        else if (TIMER_UNIT_US == enUnit)
        {
            stvalue.it_interval.tv_nsec = interval * 1000;
        }
        else if (TIMER_UNIT_NS == enUnit)
        {
            stvalue.it_interval.tv_nsec = interval;
        }
    }

    /* µĳʱʱ */
    ret = timer_settime((timer_t) timer_id, 0, &stvalue, NULL);
    if (0 > ret)
    {
        YC_DBG_PERROR("timer_settime");
        ret = YC_ERROR_FAILED;
    }
    else
    {
        ret = YC_ERROR_SUCCESS;
    }

    return ret;
}

/* ȡʱʣʱ䣬ɹʣʱ λ룬ʧܷERROR_FAILED */
long yc_timer_get_remain_time(IN void *pTmHd)
{
    long timer_id;
    int ret = YC_ERROR_FAILED;
    struct itimerspec stvalue;

    timer_id = (long)pTmHd;

    memset(&stvalue, 0, sizeof(stvalue));

    /* ȡʣʱ */
    ret = timer_gettime((timer_t) timer_id, &stvalue);
    if(0 > ret)
    {
        YC_DBG_PERROR("timer_gettime");
        return YC_ERROR_FAILED;
    }

    return (long)stvalue.it_value.tv_sec * 1000000000 + stvalue.it_value.tv_nsec;
}

/* ɾʱɹ0ʧܷERROR_FAILED */
int yc_timer_del(IN void *pTmHd)
{
    long timer_id;
    int ret = YC_ERROR_FAILED;
    unsigned int count;
    struct itimerspec stvalue;
    struct timer_data *p = NULL;

    timer_id = (long)pTmHd;

    /* ʱʱ */
    memset(&stvalue, 0, sizeof(stvalue));
    ret = timer_settime((timer_t) timer_id, 0, &stvalue, NULL);
    if (0 > ret)
    {
        YC_DBG_PERROR("timer_settime");
    }

    /* ɾʱ */
    ret = timer_delete((timer_t) timer_id);
    if(0 > ret)
    {
        YC_DBG_PERROR("timer_delete");
        ret = YC_ERROR_FAILED;
    }
    else
    {
        ret = YC_ERROR_SUCCESS;
    }

    /* ȫֱҳʱݣͷŴڴ */
    for (count = 0; count < TIMER_NUM_MAX; count++)
    {
        if ((timer_t)timer_id == g_stdata.handle[count].timerid)
        {
            p = g_stdata.handle[count].p;
            yc_free(p);
            g_stdata.handle[count].p = NULL;
            g_stdata.handle[count].timerid = 0;
            g_stdata.count--;
            break;
        }
    }

    return ret;
}



#ifndef sighandler_t
typedef void (*sighandler_t)(int);
#endif
static sighandler_t g_pfOld_Alarm_func = NULL;
static uint g_uiAlarm_Seconds = 0;
static void *g_pAlarm_Param = NULL;
static yc_alarm_callback g_pfAlarm_Callback = NULL;

static void yc_alarm_sighandler(IN int sig)
{
    if (g_pfAlarm_Callback)
        g_pfAlarm_Callback(g_pAlarm_Param);

    if (0 != g_uiAlarm_Seconds)
    {
        alarm(g_uiAlarm_Seconds);
    }

    return;
}

/* ÿֻһöʱsecondsΪ0ȡʱʱ䵥λΪ룬
   ֵָʾһʱʣʱ䣬Ϊ0˵һʱ */
uint yc_set_alarm(IN uint seconds,
                  IN bool_t bIsLoop,
                  IN yc_alarm_callback pfCallback, IN void *pArg)
{
    uint uiRet = 0;
    sighandler_t pfOld_Alarm = NULL;

    if (0 == seconds)
    {
        if (g_pfOld_Alarm_func)
        {
            signal(SIGALRM, g_pfOld_Alarm_func);
            g_pfOld_Alarm_func = NULL;
        }

        g_uiAlarm_Seconds  = 0;
        g_pAlarm_Param     = NULL;
        g_pfAlarm_Callback = NULL;

        uiRet = alarm(0);

        return uiRet;
    }

    if (NULL != pfCallback)
    {
        if (NULL == g_pfOld_Alarm_func)
        {
            pfOld_Alarm = signal(SIGALRM, yc_alarm_sighandler);
            if (SIG_ERR == pfOld_Alarm)
            {
                yc_debug_print(YC_DEBUG_TYPE_ERROR, "signal alarm error");
                return YC_ALARM_INVALID;
            }
            else
            {
                g_pfOld_Alarm_func = pfOld_Alarm;
            }
        }
        else
        {
            pfOld_Alarm = signal(SIGALRM, yc_alarm_sighandler);
            if (SIG_ERR == pfOld_Alarm)
            {
                yc_debug_print(YC_DEBUG_TYPE_ERROR, "signal alarm error");
                return YC_ALARM_INVALID;
            }
        }

        g_pAlarm_Param = pArg;
    }

    if (true == bIsLoop)
    {
        g_uiAlarm_Seconds = seconds;
    }

    uiRet = alarm(seconds);

    return uiRet;
}

#if !YC_LINUX_LITE
/* ʱʹepoll/selectȼʹcloseرգ
   intervalΪ0ֻfdʱ䣬ʱʱ俪ʼת
   ֵǸΪfdΪYC_TIMER_ID_INVALIDʾʧ */
int yc_timerfd_add(IN bool_t bIsLoop,
                   IN yc_timer_unit_e enUnit, IN int interval)
{
    int iFd = -1;
    int iRet = YC_ERROR_FAILED;
    struct itimerspec stvalue;

    iFd = timerfd_create(CLOCK_REALTIME, 0);
    if (-1 == iFd)
    {
        yc_debug_print(YC_DEBUG_TYPE_ERROR, "timerfd create error");
        return YC_ERROR_FAILED;
    }

    if (0 != interval)
    {
        memset(&stvalue, 0, sizeof(stvalue));
        if (TIMER_UNIT_SC == enUnit)
        {
            stvalue.it_value.tv_sec = interval;
        }
        else if (TIMER_UNIT_MS == enUnit)
        {
            stvalue.it_value.tv_nsec = interval * 1000000;
        }
        else if (TIMER_UNIT_US == enUnit)
        {
            stvalue.it_value.tv_nsec = interval * 1000;
        }
        else if (TIMER_UNIT_NS == enUnit)
        {
            stvalue.it_value.tv_nsec = interval;
        }

        if (true == bIsLoop)
        {
            if (TIMER_UNIT_SC == enUnit)
            {
                stvalue.it_interval.tv_sec = interval;
            }
            else if (TIMER_UNIT_MS == enUnit)
            {
                stvalue.it_interval.tv_nsec = interval * 1000000;
            }
            else if (TIMER_UNIT_US == enUnit)
            {
                stvalue.it_interval.tv_nsec = interval * 1000;
            }
            else if (TIMER_UNIT_NS == enUnit)
            {
                stvalue.it_interval.tv_nsec = interval;
            }
        }

        iRet = timerfd_settime(iFd, 0, &stvalue, NULL);
        if (0 != iRet)
        {
            yc_debug_print(YC_DEBUG_TYPE_ERROR, "timerfd settime error");
            close(iFd);
            iFd = YC_ERROR_FAILED;
        }
    }

    return iFd;
}

/* /޸Ķʱʱ䣬
   ɹERROR_SUCCESSʧܷERROR_FAILED */
int yc_timerfd_mod(IN int iFd,
                   IN bool_t bIsLoop,
                   IN yc_timer_unit_e enUnit, IN int interval)
{
    int iRet = YC_ERROR_FAILED;
    struct itimerspec stvalue;

    memset(&stvalue, 0, sizeof(stvalue));
    if (TIMER_UNIT_SC == enUnit)
    {
        stvalue.it_value.tv_sec = interval;
    }
    else if (TIMER_UNIT_MS == enUnit)
    {
        stvalue.it_value.tv_nsec = interval * 1000000;
    }
    else if (TIMER_UNIT_US == enUnit)
    {
        stvalue.it_value.tv_nsec = interval * 1000;
    }
    else if (TIMER_UNIT_NS == enUnit)
    {
        stvalue.it_value.tv_nsec = interval;
    }

    if (true == bIsLoop)
    {
        if (TIMER_UNIT_SC == enUnit)
        {
            stvalue.it_interval.tv_sec = interval;
        }
        else if (TIMER_UNIT_MS == enUnit)
        {
            stvalue.it_interval.tv_nsec = interval * 1000000;
        }
        else if (TIMER_UNIT_US == enUnit)
        {
            stvalue.it_interval.tv_nsec = interval * 1000;
        }
        else if (TIMER_UNIT_NS == enUnit)
        {
            stvalue.it_interval.tv_nsec = interval;
        }
    }

    iRet = timerfd_settime(iFd, 0, &stvalue, NULL);
    if (0 != iRet)
    {
        yc_debug_print(YC_DEBUG_TYPE_ERROR, "timerfd settime error");
        iRet = YC_ERROR_FAILED;
    }
    else
    {
        iRet = YC_ERROR_SUCCESS;
    }

    return iRet;
}

/* ȡʱʣʱ䣬λ,
   ɹʣʱ䣬ʧܷERROR_FAILED */
long yc_timerfd_get_remain_time(int iFd)
{
    int iRet = YC_ERROR_FAILED;
    struct itimerspec stvalue;

    memset(&stvalue, 0, sizeof(stvalue));
    iRet = timerfd_gettime(iFd, &stvalue);
    if (0 != iRet)
    {
        yc_debug_print(YC_DEBUG_TYPE_ERROR, "timerfd gettime error");
        return YC_ERROR_FAILED;
    }

    return (long)stvalue.it_value.tv_sec * 1000000000 + stvalue.it_value.tv_nsec;
}
#endif

