#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <netdb.h>
#include <stdarg.h>
#include <sys/select.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <arpa/inet.h>
#include <netinet/in.h>

#include "../include/yc_opt.h"
#include "../include/yc_basetype.h"
#include "../include/yc_debug.h"
#include "../include/yc_httpc.h"
#include "../include/yc_hls.h"


#if 1
#define yc_hls_printf(...)            printf("yc_hls: " __VA_ARGS__)
#else
#define yc_hls_printf(...)
#endif

#define HLS_PLAY_LIST_INDEX_MAX              8

#define TS_HEADER_LEN                        4
#define TS_FRAME_LEN                         188

// PAT table
// Programm Association Table
typedef struct TS_PAT
{
    unsigned table_id                        : 8;
    unsigned section_syntax_indicator        : 1;
    unsigned zero                            : 1;
    unsigned reserved_1                      : 2;
    unsigned section_length                  : 12;
    unsigned transport_stream_id             : 16;
    unsigned reserved_2                      : 2;
    unsigned version_number                  : 5;
    unsigned current_next_indicator          : 1;
    unsigned section_number                  : 8;
    unsigned last_section_number             : 8;
    unsigned program_number                  : 16;
    unsigned reserved_3                      : 3;
    unsigned network_PID                     : 13;
    unsigned program_map_PID                 : 13;
    unsigned CRC_32                          : 32;
} TS_PAT;

// PMT table
// Program Map Table
typedef struct TS_PMT
{
    unsigned table_id                        : 8;
    unsigned section_syntax_indicator        : 1;
    unsigned zero                            : 1;
    unsigned reserved_1                        : 2;
    unsigned section_length                    : 12;
    unsigned program_number                    : 16;
    unsigned reserved_2                        : 2;
    unsigned version_number                    : 5;
    unsigned current_next_indicator            : 1;
    unsigned section_number                    : 8;
    unsigned last_section_number            : 8;
    unsigned reserved_3                        : 3;
    unsigned PCR_PID                        : 13;
    unsigned reserved_4                        : 4;
    unsigned program_info_length            : 12;

    unsigned stream_type                    : 8;
    unsigned reserved_5                        : 3;
    unsigned elementary_PID                    : 13;
    unsigned reserved_6                        : 4;
    unsigned ES_info_length                    : 12;
    unsigned CRC_32                            : 32;
} TS_PMT;

typedef struct TS_PES
{
    unsigned packet_start_code_prefix                : 24;
    unsigned stream_id                               : 8;
    unsigned PES_packet_length                       : 16;
    unsigned PES_scrambling_control                  : 2;
    unsigned PES_priority                            : 1;
    unsigned data_alignment_indicator                : 1;
    unsigned copyright                              : 1;
    unsigned original_or_copy                       : 1;
    unsigned PTS_DTS_flags                          : 2;
    unsigned ESCR_flag                              : 1;
    unsigned ES_rate_flag                           : 1;
    unsigned DSM_trick_mode_flag                    : 1;
    unsigned additional_copy_info_flag              : 1;
    unsigned PES_CRC_flag                           : 1;
    unsigned PES_extension_flag                     : 1;
    unsigned PES_header_data_length                 : 8;
    unsigned PTS_marker_bit                         : 1;
    unsigned PTS_32_30                              : 3;
    unsigned PTS_29_15                              : 15;
    unsigned PTS_14_0                               : 15;

} TS_PES;

typedef struct TS_adaptation_field
{
    unsigned adaptation_field_length                        : 8;
    unsigned discontinuity_indicator                        : 1;
    unsigned random_access_indicator                        : 1;
    unsigned elementary_stream_priority_indicator           : 1;
    unsigned PCR_flag                                       : 1;
    unsigned OPCR_flag                                      : 1;
    unsigned splicing_point_flag                            : 1;
    unsigned transport_private_data_flag                    : 1;
    unsigned adaptation_field_extension_flag                : 1;
    unsigned program_clock_reference_base1                  : 1;
    unsigned program_clock_reference_base2                  : 32;
    unsigned reserved1                                      : 6;
    unsigned program_clock_reference_extension              : 9;
    unsigned original_program_clock_reference_base1         : 1;
    unsigned original_program_clock_reference_base2         : 32;
    unsigned reserved2                                      : 6;
    unsigned original_program_clock_reference_extension     : 9;
    unsigned splice_countdown                               : 8;
    unsigned transport_private_data_length                  : 8;
    unsigned private_data_byte                              : 8;
    unsigned adaptation_field_extension_length              : 8;
    unsigned ltw_flag                                       : 1;
    unsigned piecewise_rate_flag                            : 1;
    unsigned seamless_splice_flag                           : 1;
    unsigned reserved3                                      : 5;
    unsigned ltw_valid_flag                                 : 1;
    unsigned ltw_offset                                     : 15;
    unsigned reserved4                                      : 2;
    unsigned piecewise_rate                                 : 22;
    unsigned splice_type                                    : 4;
    unsigned marker_bit                                     : 1;
    unsigned DTS_next_AU                                    : 32;
    unsigned reserved                                       : 8;
    unsigned stuffing_byte                                  : 8;
} TS_adaptation_field;

// Transport packet header
typedef struct _TS_packet_header
{
    unsigned sync_byte                        : 8;
    unsigned transport_error_indicator        : 1;
    unsigned payload_unit_start_indicator     : 1;
    unsigned transport_priority               : 1;
    unsigned PID                              : 13;
    unsigned transport_scrambling_control     : 2;
    unsigned adaption_field_control           : 2;
    unsigned continuity_counter               : 4;

    TS_PAT pat;
    TS_PMT pmt;
    int audio_pid;
    int video_pid;
    unsigned char stream_type;
} TS_packet_header;

struct tagHls_handle{
    yc_httpc_handle_s *pstHttp;

    char *url;
    char *url2;

    uint index_count;
    char *index_url[HLS_PLAY_LIST_INDEX_MAX];
    char *index_url_last;

    uint remain_len;
    uint curr_index;

    yc_hls_media_e eVedioType;
    yc_hls_media_e eAudioType;

    TS_packet_header *ts;
    uchar  ts_is_audio; /* 0-vedio, 1-audio */
    uchar *ts_buf;
    uchar  ts_read_len;
    uchar  ts_remain_len;
};

// Adjust TS packet header
static void adjust_TS_packet_header(TS_packet_header* pheader,unsigned char * buf_header)
{
    if(buf_header[0] != 0x47)
    {
        yc_hls_printf("ts packet header error: 0x%hhx!\n", buf_header[0]);
    }
    pheader->sync_byte                        = buf_header[0];
    pheader->transport_error_indicator        = buf_header[1] >> 7;
    pheader->payload_unit_start_indicator    = buf_header[1] >> 6 & 0x01;
    pheader->transport_priority                = buf_header[1] >> 5 & 0x01;
    pheader->PID                            = (buf_header[1] & 0x1F) << 8 | buf_header[2];
    pheader->transport_scrambling_control    = buf_header[3] >> 6;
    pheader->adaption_field_control            = buf_header[3] >> 4 & 0x03;
    pheader->continuity_counter                = buf_header[3] & 0x0F;
}


// Adjust PAT table
static void adjust_PAT_table ( TS_packet_header* pheader,TS_PAT * packet,unsigned char * buffer )
{
    int n = 0, i = 0;
    int len = 0;
    unsigned char adaption_field_length = 0;

    if(pheader->adaption_field_control == 2 || pheader->adaption_field_control == 3)
    {
    	adaption_field_length = buffer[0];
    	len = adaption_field_length + 1;
    }
    if(pheader->adaption_field_control == 1 || pheader->adaption_field_control == 3)
    {
    	len++;

        packet->table_id                    = buffer[len + 0];
        packet->section_syntax_indicator    = buffer[len + 1] >> 7;
        packet->zero                        = buffer[len + 1] >> 6 & 0x1;
        packet->reserved_1                  = buffer[len + 1] >> 4 & 0x3;
        packet->section_length              = (buffer[len + 1] & 0x0F) << 8 | (buffer[len + 2] & 0xFF);
//        printf("packet->section_length = %d\n",(buffer[len + 1] & 0x0F) << 8 | (buffer[len + 2] & 0xFF));
        packet->transport_stream_id         = buffer[len + 3] << 8 | buffer[len + 4];
        packet->reserved_2                    = buffer[len + 5] >> 6;
        packet->version_number                = buffer[len + 5] >> 1 &  0x1F;
        packet->current_next_indicator        = buffer[len + 5] & 0x01;
        packet->section_number                = buffer[len + 6];
        packet->last_section_number            = buffer[len + 7];

        // Get CRC_32
//        len = 3 + packet->section_length;

        packet->CRC_32                        = (buffer[len-4] & 0xFF) << 24
                                              | (buffer[len-3] & 0xFF) << 16
                                              | (buffer[len-2] & 0xFF) << 8
                                              | (buffer[len-1] & 0xFF);

        // Parse network_PID or program_map_PID
        //printf("packet->CRC_32 = 0x%x\n",packet->CRC_32);
        //printf("len-4 = %d\n"len-4);
        //printf("packet->section_length = %d\n",packet->section_length);

        //len = 3+ 1 + packet->section_length - 4;
        len += 8;

        for ( i = 0,n = len; i < (packet->section_length-8+3-4); n+=4,i+=4 )
        {
        //    printf("@@@@@@###############\n");
            packet->program_number            = (buffer[n] & 0xFF) << 8 | (buffer[n+1] & 0xFF);
            packet->reserved_3                = buffer[n+2] >> 5;
            if ( packet->program_number == 0x0 )
            {
                packet->network_PID = (buffer[n +2] & 0x1F) << 8 | (buffer[n +3] & 0xFF);
			//	printf("packet->network_PID = %x\n",packet->network_PID);
            }
            else
            {
            	packet->program_map_PID = (buffer[n +2] & 0x1F) << 8 | (buffer[n +3] & 0xFF);
            //    printf("packet->program_map_PID = %x\n",packet->program_map_PID);
            //    printf("packet->program_map_PID = %d\n",packet->program_map_PID);
            }
        }
    }
    if(packet->program_map_PID == 0)
    {
    	yc_hls_printf("can't find program_map_PID !\n");
    }
}

// Adjust PMT table
static void adjust_PMT_table ( TS_packet_header* pheader, TS_PMT * packet,unsigned char * buffer )
{
    int pos = 12, len = 0;
    int i = 0;
    unsigned char adaption_field_length = 0;

    if(pheader->adaption_field_control == 2 || pheader->adaption_field_control == 3)
    {
    	adaption_field_length = buffer[0];
    	len = adaption_field_length + 1;
    }
    if(pheader->adaption_field_control == 1 || pheader->adaption_field_control == 3)
    {
    	len++;
        packet->table_id                            = buffer[len + 0];
        packet->section_syntax_indicator            = buffer[len + 1] >> 7;
        packet->zero                                = buffer[len + 1] >> 6 & 0x1;
        packet->reserved_1                            = buffer[len + 1] >> 4 & 0x3;
        packet->section_length                        = (buffer[len + 1] & 0x0F) << 8 | buffer[len + 2];
//        printf("PMT packet->section_length = %d\n",packet->section_length);
        packet->program_number                        = buffer[len + 3] << 8 | buffer[len + 4];
        packet->reserved_2                            = buffer[len + 5] >> 6;
        packet->version_number                        = buffer[len + 5] >> 1 & 0x1F;
        packet->current_next_indicator                = buffer[len + 5] & 0x01;
        packet->section_number                        = buffer[len + 6];
        packet->last_section_number                    = buffer[len + 7];
        packet->reserved_3                            = buffer[len + 8] >> 5;
        packet->PCR_PID                                = ((buffer[len + 8] << 8) | buffer[len + 9]) & 0x1FFF;
        packet->reserved_4                            = buffer[len + 10] >> 4;
        packet->program_info_length                    = (buffer[len + 10] & 0x0F) << 8 | (buffer[len + 11] & 0xFF);
        // Get CRC_32

        //len = packet->section_length + 3;
        packet->CRC_32                = (buffer[len-4] & 0x000000FF) << 24
                                      | (buffer[len-3] & 0x000000FF) << 16
                                      | (buffer[len-2] & 0x000000FF) << 8
                                      | (buffer[len-1] & 0x000000FF);
        // program info descriptor
        //printf("packet->program_info_length = %d\n",packet->program_info_length);
        //printf("packet->section_length = %d\n",packet->section_length);
        //printf("pos = %d\n",pos);
        if ( packet->program_info_length != 0 )
            len += packet->program_info_length;

//        printf("pos = %d\n",pos);
        // Get stream type and PID
        for (i = 0, pos = len + 12 ; i < packet->section_length - 3 ; pos+=5,i+=5)
        {
//        	printf("########################\n");
            packet->stream_type                            = buffer[pos];
//            printf("packet->stream_type = %d\n",packet->stream_type);
            packet->reserved_5                            = buffer[pos+1] >> 5;
            packet->elementary_PID                        = ((buffer[pos+1] << 8) | buffer[pos+2]) & 0x1FFF;
//            printf("packet->elementary_PID = %d\n",packet->elementary_PID);
            packet->reserved_6                            = buffer[pos+3] >> 4;
            packet->ES_info_length                        = (buffer[pos+3] & 0x0F) << 8 | buffer[pos+4];

            //printf("packet->stream_type=%u\r\n", packet->stream_type);
            if (packet->stream_type == 3)    //mp3
                pheader->audio_pid = packet->elementary_PID;
            else if(packet->stream_type == 15)    //aac
                pheader->audio_pid = packet->elementary_PID;
            else if(packet->stream_type == 27)    //h264
                pheader->video_pid = packet->elementary_PID;

            pheader->stream_type = packet->stream_type;

            if ( packet->ES_info_length != 0 )
            {
                pos += packet->ES_info_length;
                i += packet->ES_info_length;
            }
        }
    }
}

static int adjust_video_table (TS_packet_header *packet_head,unsigned char * buffer,unsigned char *out)
{
    int length_flag = 0;
    TS_PES packet_pes;
//    unsigned char test = 0;
#if 0   //get pts
    unsigned int dts = 0;
    static unsigned int dts_old = 0;
    static int fb_v = 0;
    static int times = 0;
    static int times2 = 0;
    static int times_frame = 0;
    static int test = 0;
    test++;
    if(test == 4)
    {
        fb_v = fb;
        test ++;
    }
#endif


//    printf("data packet_head->adaption_field_control = %d\n",packet_head->adaption_field_control);
    if(packet_head->adaption_field_control == 2||packet_head->adaption_field_control == 3)
    {
    //    adaptation_field()
        //ֶεĴ
        TS_adaptation_field adaptation_field;
        adaptation_field.adaptation_field_length                = buffer[0] & 0xFF;
        adaptation_field.discontinuity_indicator                = buffer[1] >> 7 & 0x01;
        adaptation_field.random_access_indicator                = buffer[1] >> 6 & 0x01;
        adaptation_field.elementary_stream_priority_indicator   = buffer[1] >> 5 & 0x01;
        adaptation_field.PCR_flag                               = buffer[1] >> 4 & 0x01;
        adaptation_field.OPCR_flag                              = buffer[1] >> 3 & 0x01;
        adaptation_field.splicing_point_flag                    = buffer[1] >> 2 & 0x01;
        adaptation_field.transport_private_data_flag            = buffer[1] >> 1 & 0x01;
        adaptation_field.adaptation_field_extension_flag        = buffer[1] >> 0 & 0x01;
        length_flag = adaptation_field.adaptation_field_length+1;
//        printf("adaptation_field.adaptation_field_length = %d\n",adaptation_field.adaptation_field_length);
//        printf("length_flag = %d\n",length_flag);
        if(adaptation_field.PCR_flag == 1)
        {
        //    printf("line = %d\n",__LINE__);
            //6ֽ
        }
        if(adaptation_field.OPCR_flag == 1)
        {
//            printf("line = %d\n",__LINE__);
        }
        if(adaptation_field.splicing_point_flag == 1)
        {
//            printf("line = %d\n",__LINE__);
        }
        if(adaptation_field.transport_private_data_flag == 1)
        {
//            printf("line = %d\n",__LINE__);
        }
        if(adaptation_field.adaptation_field_extension_flag == 1)
        {
//            printf("line = %d\n",__LINE__);
        }
        //stuffing_byte 1byte
    }
    if(packet_head->adaption_field_control== 1  ||  packet_head->adaption_field_control== 3)
    {

        if(packet_head->payload_unit_start_indicator == 0)
        {
            //fwrite(buffer+length_flag,184-length_flag,1,fb);
            memcpy(out, buffer+length_flag, 184-length_flag);
            return (184-length_flag);
        }

    //    printf("buffer[length_flag +0] = 0x%x\n",buffer[length_flag +0]);
    //    printf("buffer[length_flag +1] = 0x%x\n",buffer[length_flag +1]);
    //    printf("buffer[length_flag +2] = 0x%x\n",buffer[length_flag +2]);
        packet_pes.packet_start_code_prefix = (buffer[length_flag +0] << 16
                                             | buffer[length_flag +1] << 8
                                             | buffer[length_flag +2]) &0xffffff;

    //    printf("packet_pes.packet_start_code_prefix = 0x%x\n",packet_pes.packet_start_code_prefix);
        if(packet_pes.packet_start_code_prefix != 1)
        {
            yc_hls_printf("packet_pes.packet_start_code_prefix 00 00 01 error !\n");
        }

        packet_pes.stream_id         = buffer[length_flag +3] & 0xFF;
        packet_pes.PES_packet_length = ( (buffer[length_flag +4] &0xFF) << 8 | (buffer[length_flag +5]&0xFF) ) & 0xffff;

    //    printf("packet_pes.stream_id = 0x%x\n",packet_pes.stream_id);
    //    printf("packet_pes.PES_packet_length = %d\n",packet_pes.PES_packet_length);

        packet_pes.PES_scrambling_control   = buffer[length_flag +6] >> 4 & 0x03;
        packet_pes.PES_priority             = buffer[length_flag +6] >> 3 & 0x01;
        packet_pes.data_alignment_indicator = buffer[length_flag +6] >> 2 & 0x01;
        packet_pes.copyright                = buffer[length_flag +6] >> 1 & 0x01;
        packet_pes.original_or_copy         = buffer[length_flag +6] >> 0 & 0x01;
        //can get pts and dts info
        packet_pes.PTS_DTS_flags                = buffer[length_flag +7] >> 6 & 0x03;
        packet_pes.ESCR_flag                    = buffer[length_flag +7] >> 5 & 0x01;
        packet_pes.ES_rate_flag                 = buffer[length_flag +7] >> 4 & 0x01;
        packet_pes.DSM_trick_mode_flag          = buffer[length_flag +7] >> 3 & 0x01;
        packet_pes.additional_copy_info_flag    = buffer[length_flag +7] >> 2 & 0x01;
        packet_pes.PES_CRC_flag                 = buffer[length_flag +7] >> 1 & 0x01;
        packet_pes.PES_extension_flag           = buffer[length_flag +7] >> 0 & 0x01;

        packet_pes.PES_header_data_length           = buffer[length_flag +8];

        #if 0
        printf("packet_pes.PTS_DTS_flags = %d\n",packet_pes.PTS_DTS_flags);
        printf("packet_pes.ESCR_flag = %d\n",packet_pes.ESCR_flag);
        printf("packet_pes.ES_rate_flag = %d\n",packet_pes.ES_rate_flag);
        printf("packet_pes.DSM_trick_mode_flag = %d\n",packet_pes.DSM_trick_mode_flag);
        printf("packet_pes.additional_copy_info_flag = %d\n",packet_pes.additional_copy_info_flag);
        printf("packet_pes.PES_CRC_flag = %d\n",packet_pes.PES_CRC_flag);
        printf("packet_pes.PES_extension_flag = %d\n",packet_pes.PES_extension_flag);
        #endif

        length_flag +=9;
//        printf("packet_pes.PTS_DTS_flags = %d\n",packet_pes.PTS_DTS_flags);

        if(packet_pes.PTS_DTS_flags == 0x02)
        {
            packet_pes.PTS_32_30 = ( buffer[length_flag] >> 1 ) & 0x07;
            packet_pes.PTS_29_15 = ((buffer[length_flag +1] << 7) | (buffer[length_flag +2] >> 1)) & 0x7FFF;
            packet_pes.PTS_14_0  = ((buffer[length_flag +3] << 7) | (buffer[length_flag +4] >> 1)) & 0x7FFF;
            length_flag += 5;
            #if 0
            if(fb_v == fb)
            {
                dts = packet_pes.PTS_32_30 << 30 | packet_pes.PTS_29_15 << 15 | packet_pes.PTS_14_0;
                dts /= 90;
                if(dts_old != dts)
                {
                    times_frame++;
                    times2 = 0;
                    dts_old = dts;
                }
                printf("fb = %x  # %d   ## %d ## %d dts = %d\n",fb,times++,times_frame,++times2,dts);
            }
            #endif

        }
        else if(packet_pes.PTS_DTS_flags == 0x03)
        {
            packet_pes.PTS_32_30 = ( buffer[length_flag] >> 1 ) & 0x07;
            packet_pes.PTS_29_15 = ((buffer[length_flag +1] << 7) | (buffer[length_flag +2] >> 1)) & 0x7FFF;
            packet_pes.PTS_14_0  = ((buffer[length_flag +3] << 7) | (buffer[length_flag +4] >> 1)) & 0x7FFF;
            //check table for analysis
            length_flag += 10;
            #if 0
            if(fb_v == fb)
            {
                dts = packet_pes.PTS_32_30 << 30 | packet_pes.PTS_29_15 << 15 | packet_pes.PTS_14_0;
                dts /= 90;
                if(dts_old != dts)
                {
                    times_frame++;
                    times2 = 0;
                    printf("time = *%d*\n",dts-dts_old);
                    dts_old = dts;
                }
                printf("fb = %x  # %d   ## %d ## %d dts = %d\n",fb,times++,times_frame,++times2,dts);
            }
            #endif
        }


    //    printf("buffer[length_flag +12] = 0x%x\n",buffer[length_flag +12]);
    //    printf("buffer[length_flag +13] = 0x%x\n",buffer[length_flag +13]);
    //    printf("buffer[length_flag +14] = 0x%x\n",buffer[length_flag +14]);
    //    printf("length_flag +12 = %d\n",length_flag +12);
     //   for  (i=0;i<N;i++)
        {
        //    data_byte                 //8
            //Чصʣಿ֣ΪPES飬PSIһЩԶݡ
        }
        //fwrite(&buffer[length_flag],184-length_flag,1,fb);
        memcpy(out, &buffer[length_flag], 184-length_flag);
        return (184-length_flag);
    }

    return 0;
}

static char* yc_hls_get_next_line(char* inputLine)
{
	char *ptr;

	for (ptr = inputLine; *ptr != '\0'; ++ptr)
	{
		if (*ptr == '\r' || *ptr == '\n')
		{
			*ptr++ = '\0';
			while (*ptr == '\r' || *ptr == '\n') *ptr++ = '\0';
			if (ptr[0] == '\0') ptr = NULL; // special case for end
			break;
		}
	}

	if (inputLine[0] == '\0' || inputLine[0] == '\r' || inputLine[0] == '\n')
	    return NULL;

	return ptr;
}

static int yc_hls_prase_list(yc_hls_s *pstHls, char *pcPlaylist)
{
    char *next;
    char *pos;
    int best  = 0;
    int bandw = 0;
    int i;

    while (NULL != (next = yc_hls_get_next_line(pcPlaylist)))
    {
        if (0 == strncmp(pcPlaylist, "#EXTINF:", 8))
        {
            pcPlaylist = next;
            next = yc_hls_get_next_line(pcPlaylist);

            if (pstHls->index_count >= HLS_PLAY_LIST_INDEX_MAX)
            {
                yc_hls_printf("playlist index too much.\r\n");
                return YC_ERROR_FAILED;
            }

            pstHls->index_url[pstHls->index_count] = strdup(pcPlaylist);
            if (NULL == pstHls->index_url[pstHls->index_count])
            {
                yc_hls_printf("malloc play list failed [%u]\r\n", pstHls->index_count);
                return YC_ERROR_MEM;
            }

            pstHls->index_count++;
        }
        else if (0 == strncmp(pcPlaylist, "#EXT-X-STREAM-INF:", 18))
        {
            pos = strstr(pcPlaylist, "BANDWIDTH=");
            if (NULL == pos)
            {
                yc_hls_printf("prase bandwidth failed.\r\n");
                if (pstHls->url2)
                    yc_free(pstHls->url2);
                return YC_ERROR_FAILED;
            }
            pos += 10;
            bandw = atoi(pos);
            if (best < bandw)
            {
                pcPlaylist = next;
                next = yc_hls_get_next_line(pcPlaylist);
                best = bandw;
                if (pstHls->url2)
                    yc_free(pstHls->url2);
                pstHls->url2 = strdup(pcPlaylist);
                if (!pstHls->url2)
                {
                    yc_hls_printf("malloc bandwithd failed [%d]\r\n", best);
                    return YC_ERROR_MEM;
                }
            }
        }

        pcPlaylist = next;
        if (!pcPlaylist)
            break;
    }

    if(pstHls->index_url_last)
    {
        for(i = 0; i < pstHls->index_count; i++)
        {
            if (0 == strcmp(pstHls->index_url_last, pstHls->index_url[i]))
            {
                pstHls->curr_index = i + 1;
                yc_hls_printf("eq0 %s, %s, %u, %d\r\n", pstHls->index_url_last, pstHls->index_url[i], pstHls->curr_index, i);
            }
        }
    }

    if (best)
        yc_hls_printf("select bandwidth is [%d]: %s\r\n", best, pstHls->url2);
    else
        yc_hls_printf("prase play list total [%u]\r\n", pstHls->index_count);

    return YC_ERROR_SUCCESS;
}

static void yc_hls_free_list(yc_hls_s *pstHls)
{
    uint i;

    for (i = 0; i < pstHls->index_count; i++)
    {
        if (NULL != pstHls->index_url[i])
        {
            yc_free(pstHls->index_url[i]);
            pstHls->index_url[i] = NULL;
        }
    }

    pstHls->index_count = 0;

    return;
}

static int yc_hls_get_playlist(yc_hls_s *pstHls)
{
    int   iRet;
    char *pcPlaylist  = NULL;

    if (pstHls->url2)
        iRet = yc_httpc_get_request(pstHls->url2, 0, &pstHls->pstHttp);
    else
        iRet = yc_httpc_get_request(pstHls->url, 0, &pstHls->pstHttp);

    if (YC_ERROR_SUCCESS != iRet)
    {
        return iRet;
    }

    pcPlaylist = yc_malloc(pstHls->pstHttp->content_len);
    if (NULL == pcPlaylist)
    {
        return YC_ERROR_MEM;
    }

    memset(pcPlaylist, 0, pstHls->pstHttp->content_len);
    iRet = yc_httpc_get_data(pstHls->pstHttp, pcPlaylist, pstHls->pstHttp->content_len);
    if (iRet <= 0)
    {
        yc_free(pcPlaylist);
        return YC_ERROR_FAILED;
    }

    iRet = yc_hls_prase_list(pstHls, pcPlaylist);
    yc_free(pcPlaylist);

    if (YC_ERROR_SUCCESS == iRet)
    {
        if (false == pstHls->pstHttp->is_long_conn)
        {
            yc_httpc_close(pstHls->pstHttp);
            pstHls->pstHttp = NULL;
        }
    }

    return iRet;
}

static void yc_hls_parse_suffix(char *url, char *suffix)
{
    int i;

    for (i = strlen(url); i >= 0; i--)
    {
        if ('.' == url[i])
        {
            strcpy(suffix, &url[i]);
            break;
        }
    }

    return;
}

static int yc_hls_parse_ts(IN yc_hls_s *pstHls,
                           OUT char *pcVedio, INOUT uint *puiVedioLen,
                           OUT yc_hls_media_e *peVedioType,
                           OUT char *pcAudio, INOUT uint *puiAudioLen,
                           OUT yc_hls_media_e *peAudioType)
{
    int ret;
    int vedio_read_len = 0;
    int audio_read_len = 0;
	unsigned char *ts_buf;

    if (pstHls->ts_remain_len)
    {
        if (pstHls->ts_is_audio)
        {
            if (*puiAudioLen > pstHls->ts_remain_len)
            {
                memcpy(pcAudio, pstHls->ts_buf + pstHls->ts_read_len, pstHls->ts_remain_len);
                audio_read_len = pstHls->ts_remain_len;
                pstHls->ts_read_len  += pstHls->ts_remain_len;
                pstHls->ts_remain_len = 0;
            }
            else
            {
                memcpy(pcAudio, pstHls->ts_buf + pstHls->ts_read_len, *puiAudioLen);
                pstHls->ts_read_len   += *puiAudioLen;
                pstHls->ts_remain_len -= *puiAudioLen;
                *puiVedioLen = 0;
                *peVedioType = pstHls->eVedioType;
                *peAudioType = pstHls->eAudioType;
                return YC_ERROR_SUCCESS;
            }
        }
        else
        {
            if (*puiVedioLen > pstHls->ts_remain_len)
            {
                memcpy(pcVedio, pstHls->ts_buf + pstHls->ts_read_len, pstHls->ts_remain_len);
                vedio_read_len = pstHls->ts_remain_len;
                pstHls->ts_read_len  += pstHls->ts_remain_len;
                pstHls->ts_remain_len = 0;
            }
            else
            {
                memcpy(pcVedio, pstHls->ts_buf + pstHls->ts_read_len, *puiVedioLen);
                pstHls->ts_read_len   += *puiVedioLen;
                pstHls->ts_remain_len -= *puiVedioLen;
                *puiAudioLen = 0;
                *peVedioType = pstHls->eVedioType;
                *peAudioType = pstHls->eAudioType;
                return YC_ERROR_SUCCESS;
            }
        }


    }

	ts_buf = yc_malloc(TS_FRAME_LEN);
	if (NULL == ts_buf)
	{
        yc_hls_printf("failed to malloc tsbuf\r\n");
        return YC_ERROR_MEM;
	}

    while (1)
    {
        memset(ts_buf, 0, TS_FRAME_LEN);
        ret = yc_httpc_get_data(pstHls->pstHttp, (char *)ts_buf, TS_FRAME_LEN);
        if (ret <= 0)
        {
            yc_free(ts_buf);
            return ret;
        }

        pstHls->remain_len -= ret;//TS_FRAME_LEN

        adjust_TS_packet_header(pstHls->ts, ts_buf);

        //pid0 ͨpatҳpmtpid
        if (pstHls->ts->PID == 0)
        {
            adjust_PAT_table(pstHls->ts, &pstHls->ts->pat, ts_buf + TS_HEADER_LEN);
        }
        else if (pstHls->ts->PID  == pstHls->ts->pat.program_map_PID)
        {
            adjust_PMT_table(pstHls->ts, &pstHls->ts->pmt, ts_buf + TS_HEADER_LEN);
        }
        else if (pstHls->ts->PID == pstHls->ts->video_pid)
        {
            //memset(m3u8->ts_buf, 0, TS_FRAME_LEN);
            pstHls->ts_read_len = 0;
            pstHls->ts_remain_len = adjust_video_table(pstHls->ts, ts_buf + TS_HEADER_LEN, pstHls->ts_buf);
            if (3 == pstHls->ts->stream_type)
                pstHls->eVedioType = YC_HLS_MEDIA_MP3;
            else if (15 == pstHls->ts->stream_type)
                pstHls->eVedioType = YC_HLS_MEDIA_AAC;
            else if (27 == pstHls->ts->stream_type)
                pstHls->eVedioType = YC_HLS_MEDIA_MP4;
            if (((int)(*puiAudioLen) - vedio_read_len) > pstHls->ts_remain_len)
            {
                memcpy(pcAudio + vedio_read_len, pstHls->ts_buf, pstHls->ts_remain_len);
                vedio_read_len += pstHls->ts_remain_len;
                pstHls->ts_remain_len = 0;
            }
            else
            {
                memcpy(pcAudio + vedio_read_len, pstHls->ts_buf, (int)(*puiAudioLen) - vedio_read_len);
                pstHls->ts_read_len = (int)(*puiAudioLen) - vedio_read_len;
                vedio_read_len += pstHls->ts_read_len;
                pstHls->ts_remain_len -= pstHls->ts_read_len;
                pstHls->ts_is_audio = 0;
                if (pstHls->remain_len < TS_FRAME_LEN)
                {
                    yc_hls_printf("remain < 188: %u\r\n", pstHls->remain_len);

                    pstHls->remain_len = 0;
                    if (pstHls->index_url_last)
                        yc_free(pstHls->index_url_last);
                    pstHls->index_url_last = strdup(pstHls->index_url[pstHls->curr_index]);
                    pstHls->curr_index++;
                    if (false == pstHls->pstHttp->is_long_conn)
                    {
                        yc_httpc_close(pstHls->pstHttp);
                        pstHls->pstHttp = NULL;
                    }
                }
                break;
            }
        }
        else if (pstHls->ts->PID == pstHls->ts->audio_pid)
        {
            //memset(m3u8->ts_buf, 0, TS_FRAME_LEN);
            pstHls->ts_read_len = 0;
            pstHls->ts_remain_len = adjust_video_table(pstHls->ts, ts_buf + TS_HEADER_LEN, pstHls->ts_buf);
            if (3 == pstHls->ts->stream_type)
                pstHls->eAudioType = YC_HLS_MEDIA_MP3;
            else if (15 == pstHls->ts->stream_type)
                pstHls->eAudioType = YC_HLS_MEDIA_AAC;
            else if (27 == pstHls->ts->stream_type)
                pstHls->eAudioType = YC_HLS_MEDIA_MP4;
            if (((int)(*puiAudioLen) - audio_read_len) > pstHls->ts_remain_len)
            {
                memcpy(pcAudio + audio_read_len, pstHls->ts_buf, pstHls->ts_remain_len);
                audio_read_len += pstHls->ts_remain_len;
                pstHls->ts_remain_len = 0;
            }
            else
            {
                memcpy(pcAudio + audio_read_len, pstHls->ts_buf, (int)(*puiAudioLen) - audio_read_len);
                pstHls->ts_read_len = (int)(*puiAudioLen) - audio_read_len;
                audio_read_len += pstHls->ts_read_len;
                pstHls->ts_remain_len -= pstHls->ts_read_len;
                pstHls->ts_is_audio = 1;
                if (pstHls->remain_len < TS_FRAME_LEN)
                {
                    yc_hls_printf("remain < 188: %u\r\n", pstHls->remain_len);

                    pstHls->remain_len = 0;
                    if (pstHls->index_url_last)
                        yc_free(pstHls->index_url_last);
                    pstHls->index_url_last = strdup(pstHls->index_url[pstHls->curr_index]);
                    pstHls->curr_index++;
                    if (false == pstHls->pstHttp->is_long_conn)
                    {
                        yc_httpc_close(pstHls->pstHttp);
                        pstHls->pstHttp = NULL;
                    }
                }
                break;
            }
        }
        else
        {
            yc_hls_printf("error pid %u\n", pstHls->ts->PID);
        }

        if (pstHls->remain_len < TS_FRAME_LEN)
        {
            yc_hls_printf("remain < 188: %u\r\n", pstHls->remain_len);

            pstHls->remain_len = 0;
            if (pstHls->index_url_last)
               yc_free(pstHls->index_url_last);
            pstHls->index_url_last = strdup(pstHls->index_url[pstHls->curr_index]);
            pstHls->curr_index++;
            if (false == pstHls->pstHttp->is_long_conn)
            {
                yc_httpc_close(pstHls->pstHttp);
                pstHls->pstHttp = NULL;
            }
            break;
        }
    }

    yc_free(ts_buf);

    *puiVedioLen = vedio_read_len;
    *puiAudioLen = audio_read_len;
    *peVedioType = pstHls->eVedioType;
    *peAudioType = pstHls->eAudioType;

    return YC_ERROR_SUCCESS;
}

static int __yc_hls_read(IN yc_hls_s *pstHls,
                         OUT char *pcVedio, INOUT uint *puiVedioLen,
                         OUT yc_hls_media_e *peVedioType,
                         OUT char *pcAudio, INOUT uint *puiAudioLen,
                         OUT yc_hls_media_e *peAudioType)
{
    int ret;
    char suffix[8] = {0};

    ret = yc_httpc_get_request(pstHls->index_url[pstHls->curr_index], 0, &pstHls->pstHttp);
    if (ret)
        return ret;

    yc_hls_parse_suffix(pstHls->index_url[pstHls->curr_index], suffix);

    if (0 == strcmp(suffix, ".mp3"))
	{
        pstHls->eVedioType = YC_HLS_MEDIA_MP3;
        pstHls->eAudioType = YC_HLS_MEDIA_UNKNOWN;
	}
	else if (0 == strcmp(suffix, ".aac"))
	{
        pstHls->eVedioType = YC_HLS_MEDIA_AAC;
        pstHls->eAudioType = YC_HLS_MEDIA_UNKNOWN;
	}
    else if (0 == strcmp(suffix, ".mp4"))
	{
        pstHls->eVedioType = YC_HLS_MEDIA_MP4;
        pstHls->eAudioType = YC_HLS_MEDIA_UNKNOWN;
	}
	else if (0 == strcmp(suffix, ".ts"))
	{
	    if (NULL == pstHls->ts)
	    {
            pstHls->ts = yc_malloc(sizeof(TS_packet_header));
            if (NULL == pstHls->ts)
            {
        		yc_hls_printf("failed to malloc ts hdr.\n");
                return YC_ERROR_MEM;
        	}

        	pstHls->ts_buf = yc_malloc(TS_FRAME_LEN);
            if (NULL == pstHls->ts_buf)
            {
        		yc_hls_printf("failed to malloc ts buf.\n");
                return YC_ERROR_MEM;
        	}

        	memset(pstHls->ts_buf, 0, TS_FRAME_LEN);
        	pstHls->ts_read_len = 0;
      	    pstHls->ts_remain_len = 0;
    	}

      	memset(pstHls->ts, 0, sizeof(TS_packet_header));
	}

    if (pstHls->ts)
    {
        pstHls->remain_len = pstHls->pstHttp->content_len;
        ret = yc_hls_parse_ts(pstHls,
                              pcVedio, puiVedioLen, peVedioType,
                              pcAudio, puiAudioLen, peAudioType);
        return ret;
    }

    if (*puiVedioLen < pstHls->pstHttp->content_len)
    {
        ret = yc_httpc_get_data(pstHls->pstHttp, pcVedio, *puiVedioLen);
        if (ret > 0)
        {
            pstHls->remain_len = pstHls->pstHttp->content_len - ret;
            *puiVedioLen = ret;
            *puiAudioLen = 0;
            *peVedioType = pstHls->eVedioType;
            *peAudioType = pstHls->eAudioType;
            ret = YC_ERROR_SUCCESS;
        }
    }
    else
    {
        ret = yc_httpc_get_data(pstHls->pstHttp, pcVedio, pstHls->pstHttp->content_len);
        if (ret > 0)
        {
            if (pstHls->index_url_last)
                yc_free(pstHls->index_url_last);
            pstHls->index_url_last = strdup(pstHls->index_url[pstHls->curr_index]);
            pstHls->curr_index++;
            if (false == pstHls->pstHttp->is_long_conn)
            {
                yc_httpc_close(pstHls->pstHttp);
                pstHls->pstHttp = NULL;
            }
            *puiVedioLen = ret;
            *puiAudioLen = 0;
            *peVedioType = pstHls->eVedioType;
            *peAudioType = pstHls->eAudioType;
            ret = YC_ERROR_SUCCESS;
        }
    }

    return ret;
}

yc_hls_s *yc_hls_open(IN const char *pcUrl)
{
    int iRet;
    yc_hls_s *pstHls;
    yc_httpc_handle_s *pstHttp;
    char *pcPlaylist = NULL;

    pstHls = yc_malloc(sizeof(yc_hls_s));
    if (NULL == pstHls)
        return NULL;

    iRet = yc_httpc_get_request(pcUrl, 0, &pstHttp);
    if (YC_ERROR_SUCCESS != iRet)
    {
        yc_free(pstHls);
        return NULL;
    }

    pcPlaylist = yc_malloc(pstHttp->content_len);
    if (NULL == pcPlaylist)
    {
        yc_httpc_close(pstHttp);
        yc_free(pstHls);
        return NULL;
    }

    memset(pcPlaylist, 0, pstHttp->content_len);
    iRet = yc_httpc_get_data(pstHttp, pcPlaylist, pstHttp->content_len);
    if (iRet <= 0)
    {
        yc_httpc_close(pstHttp);
        yc_free(pcPlaylist);
        yc_free(pstHls);
        return NULL;
    }

    iRet = yc_hls_prase_list(pstHls, pcPlaylist);
    yc_free(pcPlaylist);

    if (YC_ERROR_SUCCESS != iRet)
    {
        yc_httpc_close(pstHttp);
        yc_free(pstHls);
        return NULL;
    }
    else
    {
        if (false == pstHttp->is_long_conn)
        {
            yc_httpc_close(pstHttp);
            pstHttp = NULL;
        }
    }

    pstHls->pstHttp = pstHttp;

    return pstHls;
}

int yc_hls_read(IN yc_hls_s *pstHls,
                OUT char *pcVedio, INOUT uint *puiVedioLen,
                OUT yc_hls_media_e *peVedioType,
                OUT char *pcAudio, INOUT uint *puiAudioLen,
                OUT yc_hls_media_e *peAudioType)
{
    int ret = 0;

    if (0 == pstHls->remain_len)
    {
        if (pstHls->curr_index >= pstHls->index_count)
        {
redo:
            yc_hls_free_list(pstHls);
            pstHls->curr_index = 0;
            ret = yc_hls_get_playlist(pstHls);
        }

        if (0 == ret)
        {
            if (pstHls->curr_index >= pstHls->index_count)/* skip repeat */
              goto redo;

            ret = __yc_hls_read(pstHls,
                                pcVedio, puiVedioLen, peVedioType,
                                pcAudio, puiAudioLen, peAudioType);
        }
    }
    else
    {
        if (pstHls->ts)
        {
            ret = yc_hls_parse_ts(pstHls,
                                  pcVedio, puiVedioLen, peVedioType,
                                  pcAudio, puiAudioLen, peAudioType);
        }
        else if (*puiVedioLen < pstHls->remain_len)
        {
            ret = yc_httpc_get_data(pstHls->pstHttp, pcVedio, *puiVedioLen);
            if (ret > 0)
            {
                pstHls->remain_len -= ret;
                *puiVedioLen = ret;
                *puiAudioLen = 0;
                *peVedioType = pstHls->eVedioType;
                *peAudioType = pstHls->eAudioType;
                ret = YC_ERROR_SUCCESS;
            }
        }
        else
        {
            ret = yc_httpc_get_data(pstHls->pstHttp, pcVedio, pstHls->remain_len);
            if (ret > 0)
            {
                pstHls->remain_len = 0;
                if (pstHls->index_url_last)
                    yc_free(pstHls->index_url_last);
                pstHls->index_url_last = strdup(pstHls->index_url[pstHls->curr_index]);
                pstHls->curr_index++;
                if (false == pstHls->pstHttp->is_long_conn)
                {
                    yc_httpc_close(pstHls->pstHttp);
                    pstHls->pstHttp = NULL;
                }
                *puiVedioLen = ret;
                *puiAudioLen = 0;
                *peVedioType = pstHls->eVedioType;
                *peAudioType = pstHls->eAudioType;
                ret = YC_ERROR_SUCCESS;
            }
        }
    }

    return ret;
}

void yc_hls_close(IN yc_hls_s *pstHls)
{
    yc_hls_free_list(pstHls);

    if (pstHls->index_url_last)
        yc_free(pstHls->index_url_last);

    if (pstHls->ts_buf)
        yc_free(pstHls->ts_buf);

    if (pstHls->ts)
        yc_free(pstHls->ts);

    if (pstHls->url2)
        yc_free(pstHls->url2);

    if (pstHls->url)
        yc_free(pstHls->url);

    if (NULL != pstHls->pstHttp)
        yc_httpc_close(pstHls->pstHttp);

    yc_free(pstHls);

    return;
}

