#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>

#include "../include/yc_opt.h"
#if YC_OPT_32BIT_SYSTEM
#include <sys/epoll.h>

#include "../include/yc_basetype.h"
#include "../include/yc_epoll.h"
#include "../include/yc_debug.h"


/* epoll event һ8ֽڵϣ32λϵͳø */
struct s_epoll_context{
    int iFd;
    yc_epoll_event_proc_callback pfCallback;
};

static void yc_epoll_check_callback_ret(IN int iEpFd,
                                        IN int iEventFd,
                                        IN yc_epoll_event_proc_callback pfCallback,
                                        IN uint uiRet)
{
    uint uiEvent = 0;
    int iErr;

    if (uiRet & EPOLLIN)
        uiEvent |= EPOLLIN;
    if (uiRet & EPOLLOUT)
        uiEvent |= EPOLLOUT;
    if (uiRet & EPOLLRDHUP)
        uiEvent |= EPOLLRDHUP;
    if (uiRet & EPOLLPRI)
        uiEvent |= EPOLLPRI;
    if (uiRet & EPOLLERR)
        uiEvent |= EPOLLERR;
    if (uiRet & EPOLLHUP)
        uiEvent |= EPOLLHUP;
    if (uiRet & EPOLLET)
        uiEvent |= EPOLLET;
    if (uiRet & EPOLLONESHOT)
        uiEvent |= EPOLLONESHOT;

    if (uiEvent)
    {
        iErr = yc_epoll_mod(iEpFd, iEventFd, uiEvent, pfCallback);
        if (YC_ERROR_SUCCESS != iErr)
        {
            YC_DBG_PRINT("epoll_mod[%d]-[%d] error.\r\n", iEpFd, iEventFd);
        }
    }

    return;
}

int yc_epoll_create(IN int iSize)
{
    int iRet = YC_ERROR_SUCCESS;

    iRet = epoll_create(iSize);
    if (-1 == iRet)
    {
        iRet = YC_ERROR_FAILED;
    }

    return iRet;
}

int yc_epoll_add(IN int iEpFd,
                 IN int iEventFd,
                 IN uint uiEvent,
                 IN yc_epoll_event_proc_callback pfCallback)
{
    int iRet = YC_ERROR_FAILED;
    struct epoll_event stEvent;
    struct s_epoll_context stContext;

    YC_DBGASSERT(NULL != pfCallback);

    memset(&stEvent, 0, sizeof(struct epoll_event));
    memset(&stContext, 0, sizeof(struct s_epoll_context));

    stEvent.events = uiEvent;

    stContext.iFd = iEventFd;
    stContext.pfCallback = pfCallback;

    memcpy(&stEvent.data, &stContext, sizeof(epoll_data_t));

    iRet = epoll_ctl(iEpFd, EPOLL_CTL_ADD, iEventFd, &stEvent);
    if (0 == iRet)
    {
        iRet = YC_ERROR_SUCCESS;
    }

    return iRet;
}

int yc_epoll_mod(IN int iEpFd,
                 IN int iEventFd,
                 IN uint uiEvent,
                 IN yc_epoll_event_proc_callback pfCallback)
{
    int iRet = YC_ERROR_FAILED;
    struct epoll_event stEvent;
    struct s_epoll_context stContext;

    YC_DBGASSERT(NULL != pfCallback);

    memset(&stEvent, 0, sizeof(struct epoll_event));
    memset(&stContext, 0, sizeof(struct s_epoll_context));

    stEvent.events = uiEvent;

    stContext.iFd = iEventFd;
    stContext.pfCallback = pfCallback;

    memcpy(&stEvent.data, &stContext, sizeof(epoll_data_t));

    iRet = epoll_ctl(iEpFd, EPOLL_CTL_MOD, iEventFd, &stEvent);
    if (0 == iRet)
    {
        iRet = YC_ERROR_SUCCESS;
    }

    return iRet;
}

int yc_epoll_del(IN int iEpFd, IN int iEventFd)
{
    int iRet = YC_ERROR_FAILED;
    struct epoll_event stEvent;

    iRet = epoll_ctl(iEpFd, EPOLL_CTL_DEL, iEventFd, &stEvent);/* 2.6.9ں֮ǰstEventȻԵܱΪNULL */
    if (0 == iRet)
    {
        iRet = YC_ERROR_SUCCESS;
    }

    return iRet;
}

void yc_epoll_wait(IN int iEpFd, IN uint uiMaxEvent)
{
    uint uiCnt;
    uint uiRet;
    int iRet = YC_ERROR_SUCCESS;
    struct epoll_event *pstEvent;
    struct s_epoll_context *pstContext;

    pstEvent = yc_malloc(uiMaxEvent * sizeof(struct epoll_event));
    if (NULL == pstEvent)
    {
        return;
    }

    memset(pstEvent, 0, uiMaxEvent * sizeof(struct epoll_event));

    for ( ; ; )
    {
        iRet = epoll_wait(iEpFd, pstEvent, uiMaxEvent, -1);/* -1ʾȴ */

        /* EpFdЧMaxEventΪ0ʱ˳epollȴ */
        if ((-1 == iRet) && ((EINVAL == errno) || (EBADF == errno)))
        {
            break;
        }

    	for(uiCnt = 0; uiCnt < iRet; uiCnt++)
    	{
    	    if ((pstEvent[uiCnt].events & EPOLLERR) ||
    		    (pstEvent[uiCnt].events & EPOLLHUP) ||
    		    (pstEvent[uiCnt].events & EPOLLRDHUP))
    		{
                YC_DBG_PRINT("epoll_wait[%d]-[%d] error.\r\n", iEpFd, pstEvent[uiCnt].data.fd);
                //close(pstEvent[uiCnt].data.fd);
    		}
            pstContext = (struct s_epoll_context *)&pstEvent[uiCnt].data;
            uiRet = pstContext->pfCallback(pstContext->iFd, pstEvent[uiCnt].events);
            yc_epoll_check_callback_ret(iEpFd, pstContext->iFd, pstContext->pfCallback, uiRet);
    	}
    }

    yc_free(pstEvent);
    return;
}

int yc_epoll_destroy(IN int iEpFd)
{
    int iRet = YC_ERROR_FAILED;

    iRet = close(iEpFd);
    if (0 == iRet)
    {
        iRet = YC_ERROR_SUCCESS;
    }

    return iRet;
}

#endif

