#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "../include/yc_opt.h"
#include "../include/yc_basetype.h"
#include "../include/yc_debug.h"
#include "../include/yc_conf.h"

/* ===============Ҫ================= */
/* ļСλ: ֽ */
#define FILE_SIZE_MAX  1024

/* ÿһе󳤶ȣλ: ֽ */
#define LINE_LEN_MAX   256

/* ֵ󳤶ȣλ: ֽ */
#define VALUE_LEN_MAX  64
/* ======================================== */

/* ״̬ */
#define FLAG_START     0
#define FLAG_APP       1
#define FLAG_KEY       2
#define FLAG_NOTHING   3

/* ļжȡַݣɹERROR_SUCCESSʧܷERROR_FAILED */
int yc_conf_get_key_4str(IN  const char *pcFile,
                         IN  const char *pcAppName,
                         IN  const char *pcKeyName,
                         OUT char       *pcKeyValue)
{
    int   iRet    = YC_ERROR_FAILED;
    char *pcPos   = NULL;
    FILE *pstFile = NULL;
    char *acBuf   = NULL;
    char *szAppName  = NULL;
    char *szKeyName  = NULL;
    char *szKeyValue = NULL;
    uchar ucFlag     = FLAG_START;

    szAppName = yc_malloc(LINE_LEN_MAX);
    if (NULL == szAppName)
    {
        return YC_ERROR_MEM;
    }

    szKeyName = yc_malloc(LINE_LEN_MAX);
    if (NULL == szAppName)
    {
        yc_free(szAppName);
        return YC_ERROR_MEM;
    }

    szKeyValue = yc_malloc(LINE_LEN_MAX);
    if (NULL == szAppName)
    {
        yc_free(szKeyName);
        yc_free(szAppName);
        return YC_ERROR_MEM;
    }

    acBuf = yc_malloc(LINE_LEN_MAX);
    if (NULL == szAppName)
    {
        yc_free(szKeyValue);
        yc_free(szKeyName);
        yc_free(szAppName);
        return YC_ERROR_MEM;
    }

    /* ļ */
    pstFile = fopen(pcFile, "r");
    if (NULL == pstFile)
    {
        yc_free(acBuf);
        yc_free(szKeyValue);
        yc_free(szKeyName);
        yc_free(szAppName);
        return YC_ERROR_FAILED;
    }

    /* ļͷ */
    rewind(pstFile);

    if (NULL != pcAppName)
    {
        /* ƴӲҵ */
        szAppName[0] = '\0';
        sprintf(szAppName, "[%s]", pcAppName);
        ucFlag = FLAG_START;
    }
    else
    {
        ucFlag = FLAG_APP;
    }

    /* дļжȡ */
    while(NULL != fgets(acBuf, LINE_LEN_MAX, pstFile))
    {
        /* Ȳappname */
        if (FLAG_START == ucFlag)
        {
            if (0 == strncmp(szAppName, acBuf, strlen(szAppName)))
            {
                ucFlag = FLAG_APP;
                continue;
            }
        }

        /* ٲkeyname */
        if (FLAG_APP == ucFlag)
        {
            /* ע */
            if ('#' == acBuf[0])
            {
                continue;
            }

            if (NULL != pcAppName)
            {
                /* һappname֮ǰûҵkeyname˵key */
                if ('[' == acBuf[0])
                {
                    break;
                }
            }

            /* =Ϊÿ */
            pcPos = strchr(acBuf, '=');
            if (NULL != pcPos)
            {
                szKeyName[0] = '\0';
                szKeyValue[0] = '\0';

                /* keyname= */
                sscanf(acBuf, "%[^=]", szKeyName);
                if (0 == strncmp(pcKeyName, szKeyName, strlen(pcKeyName)))
                {
                    /* ʱҵkeynamekeyvalueн */
                    sscanf(pcPos + 1, "%[^\n]", szKeyValue);
					/* пĻз\r\nϲֻȥ\nԻҪǷȥ\r */
					if ('\r' == szKeyValue[strlen(szKeyValue) - 1])
					{
						szKeyValue[strlen(szKeyValue) - 1] = '\0';
					}
                    ucFlag = FLAG_KEY;
                    break;
                }
            }
        }
    }

    /* رļ */
    iRet = fclose(pstFile);

    /* ֻйرճɹ  ҵkeynamekeyvalueɹ */
    if ((YC_ERROR_SUCCESS == iRet) && (FLAG_KEY == ucFlag))
    {
        strcpy(pcKeyValue, szKeyValue);
        iRet = YC_ERROR_SUCCESS;
    }
    else
    {
        iRet = YC_ERROR_FAILED;
    }

    yc_free(acBuf);
    yc_free(szKeyValue);
    yc_free(szKeyName);
    yc_free(szAppName);

    return iRet;
}

/* ļжȡݣɹERROR_SUCCESSʧܷERROR_FAILED */
int yc_conf_get_key_4int(IN  const char *pcFile,
                         IN  const char *pcAppName,
                         IN  const char *pcKeyName,
                         OUT int        *piKeyValue)
{
    int iRet = YC_ERROR_FAILED;
    char *szKeyValue = NULL;

    szKeyValue = yc_malloc(VALUE_LEN_MAX);
    if (NULL == szKeyValue)
        return YC_ERROR_MEM;

    szKeyValue[0] = '\0';
    iRet = yc_conf_get_key_4str(pcFile, pcAppName, pcKeyName, szKeyValue);
    if (YC_ERROR_SUCCESS == iRet)
    {
        /* ַתΪ */
        *piKeyValue = atoi(szKeyValue);
    }

    yc_free(szKeyValue);

    return iRet;
}

/* ļжȡݣɹERROR_SUCCESSʧܷERROR_FAILED */
int yc_conf_get_key_4long(IN  const char *pcFile,
                          IN  const char *pcAppName,
                          IN  const char *pcKeyName,
                          OUT long       *plKeyValue)
{
    int iRet = YC_ERROR_FAILED;
    char *szKeyValue = NULL;

    szKeyValue = yc_malloc(VALUE_LEN_MAX);
    if (NULL == szKeyValue)
        return YC_ERROR_MEM;

    szKeyValue[0] = '\0';
    iRet = yc_conf_get_key_4str(pcFile, pcAppName, pcKeyName, szKeyValue);
    if (YC_ERROR_SUCCESS == iRet)
    {
        /* ַתΪ */
        *plKeyValue = atol(szKeyValue);
    }

    yc_free(szKeyValue);

    return iRet;
}

/* ļжȡݣɹERROR_SUCCESSʧܷERROR_FAILED */
int yc_conf_get_key_4double(IN  const char *pcFile,
                            IN  const char *pcAppName,
                            IN  const char *pcKeyName,
                            OUT double     *pdKeyValue)
{
    int iRet = YC_ERROR_FAILED;
    char *szKeyValue = NULL;

    szKeyValue = yc_malloc(VALUE_LEN_MAX);
    if (NULL == szKeyValue)
        return YC_ERROR_MEM;

    szKeyValue[0] = '\0';
    iRet = yc_conf_get_key_4str(pcFile, pcAppName, pcKeyName, szKeyValue);
    if (YC_ERROR_SUCCESS == iRet)
    {
        /* ַתΪ */
        *pdKeyValue = atof(szKeyValue);
    }

    yc_free(szKeyValue);

    return iRet;
}

/* ַݴļɹERROR_SUCCESSʧܷERROR_FAILED */
int yc_conf_set_key_4str(IN const char *pcFile,
                         IN const char *pcAppName,
                         IN const char *pcKeyName,
                         IN const char *pcKeyValue)
{
    int   iRet    = YC_ERROR_FAILED;
    char *pcPos   = NULL;
    FILE *pstFile = NULL;
    char *acBuf   = NULL;
    char *szAppName  = NULL;
    char *szKeyName  = NULL;
    char *szKeyValue = NULL;
    char *szBakfName = NULL;
    char *acTotalFileBuf = NULL;
    uchar ucFlag = FLAG_START;
    uint  uiPos  = 0;

    szAppName = yc_malloc(LINE_LEN_MAX);
    if (NULL == szAppName)
    {
        return YC_ERROR_MEM;
    }

    szKeyName = yc_malloc(LINE_LEN_MAX);
    if (NULL == szKeyName)
    {
        yc_free(szAppName);
        return YC_ERROR_MEM;
    }

    szKeyValue = yc_malloc(LINE_LEN_MAX);
    if (NULL == szKeyValue)
    {
        yc_free(szKeyName);
        yc_free(szAppName);
        return YC_ERROR_MEM;
    }

    acBuf = yc_malloc(LINE_LEN_MAX);
    if (NULL == acBuf)
    {
        yc_free(szKeyValue);
        yc_free(szKeyName);
        yc_free(szAppName);
        return YC_ERROR_MEM;
    }

    acTotalFileBuf = yc_malloc(FILE_SIZE_MAX);
    if (NULL == acTotalFileBuf)
    {
        yc_free(acBuf);
        yc_free(szKeyValue);
        yc_free(szKeyName);
        yc_free(szAppName);
        return YC_ERROR_MEM;
    }

    /* ļ */
    pstFile = fopen(pcFile, "r");
    if (NULL == pstFile)
    {
        yc_free(acTotalFileBuf);
        yc_free(acBuf);
        yc_free(szKeyValue);
        yc_free(szKeyName);
        yc_free(szAppName);
        return YC_ERROR_FAILED;
    }

    /* ļͷ */
    rewind(pstFile);

    if (NULL != pcAppName)
    {
        /* ƴӲҵ */
        szAppName[0] = '\0';
        sprintf(szAppName, "[%s]", pcAppName);
        ucFlag = FLAG_START;
    }
    else
    {
        ucFlag = FLAG_APP;
    }

    /* дļжȡ */
    while(NULL != fgets(acBuf, LINE_LEN_MAX, pstFile))
    {
        /* Ȳappnameٲkeyname */
        if(FLAG_START== ucFlag)
        {
            strcat(acTotalFileBuf, acBuf);

            /* Ƿappname */
            if (0 == strncmp(szAppName, acBuf, strlen(szAppName)))
            {
                ucFlag = FLAG_APP;
                continue;
            }
        }
        else
        {
            if (NULL != pcAppName)
            {
                /* appnameڴkeynameʧ */
                if (('[' == acBuf[0]) && (FLAG_KEY != ucFlag))
                {
                    break;
                }
            }

            /* =Ϊÿ */
            pcPos = strchr(acBuf, '=');
            if (NULL != pcPos)
            {
                szKeyName[0] = '\0';
                szKeyValue[0] = '\0';

                /* keyname= */
                sscanf(acBuf, "%[^=]", szKeyName);
                if (0 == strncmp(pcKeyName, szKeyName, strlen(pcKeyName)))
                {
                    /* ʱҵkeynamekeyvalueн */
                    sscanf(pcPos + 1, "%[^\n]", szKeyValue);

                    /* keyvalueԭͬ */
                    if (0 == strcmp(szKeyValue, pcKeyValue))
                    {
                        ucFlag = FLAG_NOTHING;
                        break;
                    }
                    else
                    {
                        acBuf[0] = '\0';
                        /* ƴװݣĩβҪӻз */
                        sprintf(acBuf, "%s=%s\n", szKeyName, pcKeyValue);
                        ucFlag = FLAG_KEY;
                    }
                }
            }

            /* µappname/ƥkeyname׷ӵ */
            strcat(acTotalFileBuf, acBuf);
        }
    }

    yc_free(acBuf);
    yc_free(szKeyValue);
    yc_free(szKeyName);
    yc_free(szAppName);

    /* رļ */
    iRet = fclose(pstFile);

    /* رճɹ  ֻмֵݸıܱ */
    if ((YC_ERROR_SUCCESS == iRet) && (FLAG_KEY == ucFlag))
    {
        szBakfName = yc_malloc(LINE_LEN_MAX);
        if (NULL == szBakfName)
        {
            yc_free(acTotalFileBuf);
            return YC_ERROR_MEM;
        }

        /* ݾļ "ļ.bak" */
        szBakfName[0] = '\0';
        sprintf(szBakfName, "%s.bak", pcFile);
        iRet = rename(pcFile, szBakfName);
        if (YC_ERROR_SUCCESS != iRet)
        {
            yc_free(szBakfName);
            yc_free(acTotalFileBuf);
            return YC_ERROR_FAILED;
        }

        pstFile = fopen(pcFile, "w+");
        if (NULL == pstFile)
        {
            rename(szBakfName, pcFile);
            yc_free(szBakfName);
            yc_free(acTotalFileBuf);
            return YC_ERROR_FAILED;
        }

        /* Ҫ¼ļͷ(֪Ϊlinuxļͷ) */
        for (uiPos = 0; uiPos < strlen(acTotalFileBuf) + 1; uiPos++)
        {
            /* ҵһ[ΪļĿʼ */
            if ('[' == acTotalFileBuf[uiPos])
            {
                break;
            }
        }

        fputs(acTotalFileBuf + uiPos, pstFile);

        iRet = fclose(pstFile);
        if (YC_ERROR_SUCCESS != iRet)
        {
            remove(pcFile);
            rename(szBakfName, pcFile);
            iRet = YC_ERROR_FAILED;
        }

        yc_free(szBakfName);
    }
    else if((YC_ERROR_SUCCESS == iRet) && (FLAG_NOTHING == ucFlag))
    {
        iRet = YC_ERROR_SUCCESS;
    }
    else
    {
        iRet = YC_ERROR_FAILED;
    }

    yc_free(acTotalFileBuf);

    return iRet;
}

/* ݴļɹERROR_SUCCESSʧܷERROR_FAILED */
int yc_conf_set_key_4int(IN const char *pcFile,
                         IN const char *pcAppName,
                         IN const char *pcKeyName,
                         IN const int   iKeyValue)
{
    int iRet = YC_ERROR_FAILED;
    char *szKeyValue = NULL;

    szKeyValue = yc_malloc(VALUE_LEN_MAX);
    if (NULL == szKeyValue)
        return YC_ERROR_MEM;

    szKeyValue[0] = '\0';
    sprintf(szKeyValue, "%d", iKeyValue);

    iRet = yc_conf_set_key_4str(pcFile, pcAppName, pcKeyName, szKeyValue);

    yc_free(szKeyValue);

    return iRet;
}

/* ݴļɹERROR_SUCCESSʧܷERROR_FAILED */
int yc_conf_set_key_4long(IN const char *pcFile,
                          IN const char *pcAppName,
                          IN const char *pcKeyName,
                          IN const long  lKeyValue)
{
    int iRet = YC_ERROR_FAILED;
    char *szKeyValue = NULL;

    szKeyValue = yc_malloc(VALUE_LEN_MAX);
    if (NULL == szKeyValue)
        return YC_ERROR_MEM;

    szKeyValue[0] = '\0';
    sprintf(szKeyValue, "%ld", lKeyValue);

    iRet = yc_conf_set_key_4str(pcFile, pcAppName, pcKeyName, szKeyValue);

    yc_free(szKeyValue);

    return iRet;
}

/* ݴļɹERROR_SUCCESSʧܷERROR_FAILED */
int yc_conf_set_key_4double(IN const char  *pcFile,
                            IN const char  *pcAppName,
                            IN const char  *pcKeyName,
                            IN const double dKeyValue)
{
    int iRet = YC_ERROR_FAILED;
    char *szKeyValue = NULL;

    szKeyValue = yc_malloc(VALUE_LEN_MAX);
    if (NULL == szKeyValue)
        return YC_ERROR_MEM;

    szKeyValue[0] = '\0';
    sprintf(szKeyValue, "%g", dKeyValue);

    iRet = yc_conf_set_key_4str(pcFile, pcAppName, pcKeyName, szKeyValue);

    yc_free(szKeyValue);

    return iRet;
}

