#include <stdio.h>
#include <fcntl.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "../include/yc_opt.h"
#if !YC_WINDOWS_LITE
#include <linux/in.h>

#include "../include/yc_basetype.h"
#include "../include/yc_cioctl.h"
#include "../include/yc_socket.h"
#include "../include/yc_debug.h"


#define CIOCTL_DEVICE_PATH_LEN      20
#define CIOCTL_RCV_TIMEOUT          10

static int g_iCioctlFd = -1;
static yc_socket_server_s *g_pstSocket = NULL;
#if YC_CIOCTL_CFG_ASYN
static int g_iSocketId4Asyn = -1;
#endif

static void cioctl_socket_rcv_callback(IN int iSockfd,         IN void *pArg,
                                       IN const void *pData,   IN uint uiDataLen,
                                       IN const char *pcSrcIP, IN ushort usSrcPort)
{
	char *pcBuf = NULL;
	char *pcRcvBuf = NULL;
	int iRet = YC_ERROR_FAILED;
	unsigned char ucIsAsyn = 0;
	unsigned int uiInDataLen = 0;
	unsigned int uiOutBufLen = 0;
	unsigned int uiOutDatalen = 0;

	YC_DBGASSERT(NULL != pData);

	/* TLV: pos 1b, cmd 4b, pcbuflen 4b, indatalen 4b, indata, outbuflen 4b, outdatalen 4b, outdata */
	pcBuf= (char *)pData;
    ucIsAsyn = *(unsigned char *)pcBuf;

    if (1 == ucIsAsyn)
    {
        /* TLV: pos 1b, cmd 4b, indata */
#if YC_CIOCTL_CFG_ASYN
        yc_cioctl_asyn(*(unsigned int *)(pcBuf + sizeof(unsigned char)), YC_CIOCTL_LOCAL,
                    pcBuf + sizeof(unsigned char) + sizeof(unsigned int),
                    uiDataLen - sizeof(unsigned char) - sizeof(unsigned int));
#endif
    }
    else
    {
        /* TLV: pos 1b, cmd 4b, pcbuflen 4b, indatalen 4b, indata, outbuflen 4b, outdatalen 4b, outdata */
        uiInDataLen = *(unsigned int *)(pcBuf + sizeof(unsigned char) + sizeof(unsigned int) + sizeof(unsigned int));
	    uiOutBufLen = *(unsigned int *)(pcBuf + sizeof(unsigned char) + sizeof(unsigned int) + sizeof(unsigned int) + sizeof(unsigned int) + uiInDataLen);

    	/* TLV: errcode 4b, data */
    	pcRcvBuf = (char *)yc_malloc(sizeof(unsigned int) + uiOutBufLen);
    	if (NULL == pcRcvBuf)
    	{
    		yc_socket_send(iSockfd, &iRet, sizeof(unsigned int), pcSrcIP, usSrcPort);
    		return;
    	}

    	memset(pcRcvBuf, 0, sizeof(unsigned int) + uiOutBufLen);
    	iRet = yc_cioctl(*(unsigned int *)pcBuf, YC_CIOCTL_LOCAL,
       				     pcBuf + sizeof(unsigned int) + sizeof(unsigned int) + sizeof(unsigned int),
          				 uiInDataLen,
          				 pcRcvBuf + sizeof(unsigned int),
          				 uiOutBufLen,
          				 &uiOutDatalen);
       	if (YC_ERROR_SUCCESS == iRet)
       	{
    		*(unsigned int *)pcRcvBuf = YC_ERROR_SUCCESS;
       	}
       	else
       	{
    		*(unsigned int *)pcRcvBuf = YC_ERROR_FAILED;
       	}

    	yc_socket_send(iSockfd, pcRcvBuf, sizeof(unsigned int) + uiOutDatalen, pcSrcIP, usSrcPort);

    	yc_free(pcRcvBuf);
    }

	return;
}

int yc_cioctl_init(void)
{
    int iCioctlFd = -1;
    int iSocketId = -1;
#if YC_CIOCTL_CFG_ASYN
    int iSocketId4Asyn = -1;
#endif
    int iCioctlDeviceLen = 0;
    char acCioctlDevice[CIOCTL_DEVICE_PATH_LEN];

    memset(acCioctlDevice, 0, CIOCTL_DEVICE_PATH_LEN);
    iCioctlDeviceLen = sprintf(acCioctlDevice, "/dev/%s", YC_CIOCTL_DEVICE_NAME);
    if (iCioctlDeviceLen > CIOCTL_DEVICE_PATH_LEN)
    {
        YC_DBG_PRINT("cioctl_sprintf failed.\r\n");
        return YC_ERROR_FAILED;
    }

    iCioctlFd = open(acCioctlDevice, O_RDWR);
    if (-1 == iCioctlFd)
    {
        YC_DBG_PERROR("cioctl_open");
        return YC_ERROR_FAILED;
    }

#if YC_CIOCTL_CFG_ASYN
    iSocketId4Asyn = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
    if (-1 == iSocketId4Asyn)
    {
        YC_DBG_PERROR("cioctl_asyn_socket");
        close(iCioctlFd);
        return YC_ERROR_FAILED;
    }
#endif

	g_pstSocket = yc_udp_server_create(CIOCTL_LOCAL_PORT, cioctl_socket_rcv_callback, NULL);
	if (YC_ERROR_FAILED == iSocketId)
	{
	    YC_DBG_PRINT("cioctl_socket failed.\r\n");
		close(iCioctlFd);
#if YC_CIOCTL_CFG_ASYN
		close(iSocketId4Asyn);
#endif
		return YC_ERROR_FAILED;
	}

    g_iCioctlFd = iCioctlFd;
#if YC_CIOCTL_CFG_ASYN
    g_iSocketId4Asyn = iSocketId4Asyn;
#endif

    return YC_ERROR_SUCCESS;
}


void yc_cioctl_fini(void)
{
#if YC_CIOCTL_CFG_ASYN
	if (-1 != g_iSocketId4Asyn)
    {
        close(g_iSocketId4Asyn);
        g_iSocketId4Asyn = -1;
    }
#endif

    if (NULL != g_pstSocket)
	{
		yc_udp_server_destroy(g_pstSocket);
        g_pstSocket = NULL;
	}

    if (-1 != g_iCioctlFd)
    {
        close(g_iCioctlFd);
        g_iCioctlFd = -1;
    }

    return;
}

int yc_cioctl(IN uint uiCmd,     IN const char *pcDstIP,
              IN void *pInData,  IN uint uiInDataLen,
              OUT void *pOutBuf, IN uint uiOutBufLen,
              OUT uint *puiOutDataLen)
{
	char *pcPos = NULL;
	char *pcBuf = NULL;
	char *pcRcvBuf = NULL;
    int iRet = YC_ERROR_FAILED;
	unsigned int uiBufLen = 0;
	unsigned int uiPosLen = 0;
	unsigned int uiCmdLen = 0;
	unsigned int  uiRcvLen = 0;

    if (((NULL == pOutBuf) && (0 != uiOutBufLen)) ||
        ((NULL != pOutBuf) && (0 == uiOutBufLen)))
    {
        YC_DBG_PRINT("%s: yc_cioctl para invalid.\r\n", __FUNCTION__);
        return YC_ERROR_FAILED;
    }

    if (-1 == g_iCioctlFd)
    {
    	YC_DBG_PRINT("%s: yc_cioctl not init.\r\n", __FUNCTION__);
        return YC_ERROR_FAILED;
    }

	if (YC_CIOCTL_LOCAL != pcDstIP)
	{
	    uiPosLen = sizeof(unsigned char);
		uiCmdLen = sizeof(unsigned int);
		pcRcvBuf = (char *)yc_malloc(sizeof(unsigned int) + uiOutBufLen);
		if (NULL == pcRcvBuf)
		{
			return YC_ERROR_FAILED;
		}
	}

	/* local   TLV:                 pcbuflen 4b, indatalen 4b, indata, outbuflen 4b, outdatalen 4b, outdata */
	/* network TLV: pos 1b, cmd 4b, pcbuflen 4b, indatalen 4b, indata, outbuflen 4b, outdatalen 4b, outdata */
	uiBufLen = sizeof(unsigned int) + sizeof(unsigned int) + uiInDataLen +\
			   sizeof(unsigned int) + sizeof(unsigned int) + uiOutBufLen;
	pcBuf = (char *)yc_malloc(uiPosLen + uiCmdLen + uiBufLen);
	if (NULL == pcBuf)
	{
		YC_DBG_PRINT("%s: failed to malloc buf.\r\n", __FUNCTION__);
		if (NULL != pcRcvBuf)
		{
			yc_free(pcRcvBuf);
		}
        return YC_ERROR_FAILED;
	}

	memset(pcBuf, 0, uiPosLen + uiCmdLen + uiBufLen);
	pcPos = pcBuf;

	if (YC_CIOCTL_LOCAL != pcDstIP)
	{
	    *(unsigned char*)pcPos = 0;
		pcPos += uiPosLen;
		*(unsigned int*)pcPos = uiCmd;
		pcPos += uiCmdLen;
	}

	memcpy((unsigned int*)pcPos, &uiBufLen, sizeof(unsigned int));/* ںҲmemcpy */
	pcPos += sizeof(unsigned int);
	*(unsigned int*)pcPos = uiInDataLen;
	pcPos += sizeof(unsigned int);
	memcpy(pcPos, pInData, uiInDataLen);
	pcPos += uiInDataLen;
	*(unsigned int*)pcPos = uiOutBufLen;

	if (YC_CIOCTL_LOCAL != pcDstIP)
	{
		memset(pcRcvBuf, 0, sizeof(unsigned int) + uiOutBufLen);
		iRet = yc_udp_send_and_rcv(CIOCTL_RCV_TIMEOUT,
   								   pcDstIP, CIOCTL_LOCAL_PORT,
   								   pcBuf, uiBufLen,
   								   pcRcvBuf, &uiRcvLen);
		if (YC_ERROR_SUCCESS == iRet)
		{
			if (uiRcvLen > sizeof(unsigned int) + uiOutBufLen)
			{
				iRet = YC_ERROR_FAILED;
			}
			else
			{
				/* TLV: errcode 4b, data */
				if (YC_ERROR_SUCCESS == *(unsigned int *)pcRcvBuf)
				{
				    if ((NULL == pOutBuf) || (0 == uiOutBufLen))
        		    {
                        iRet = YC_ERROR_SUCCESS;
        		    }
        		    else
				    {
    				    if (uiOutBufLen >= (uiRcvLen - sizeof(unsigned int)))
    				    {
    				        if (NULL != puiOutDataLen)
    			            {
        					    *puiOutDataLen = uiRcvLen - sizeof(unsigned int);
        					}
        					memcpy(pOutBuf, pcRcvBuf + sizeof(unsigned int), uiRcvLen - sizeof(unsigned int));
    					}
    					else
    					{
                            iRet = YC_ERROR_FAILED;
    					}
					}
				}
				else
				{
					iRet = YC_ERROR_FAILED;
				}
			}
		}
	}
	else
	{
		iRet = ioctl(g_iCioctlFd, uiCmd, pcBuf);
	    if (0 != iRet)
	    {
	        iRet = YC_ERROR_FAILED;
	    }
	    else
		{
		    if ((NULL == pOutBuf) || (0 == uiOutBufLen))
		    {
                iRet = YC_ERROR_SUCCESS;
		    }
		    else
		    {
    			pcPos = pcBuf + sizeof(unsigned int) + sizeof(unsigned int) + uiInDataLen + sizeof(unsigned int);

    			if (uiOutBufLen >= *(unsigned int *)pcPos)
    			{
    			    if (NULL != puiOutDataLen)
    			    {
        			    *puiOutDataLen = *(unsigned int *)pcPos;
        			}
        			memcpy(pOutBuf, pcPos + sizeof(unsigned int), *(unsigned int *)pcPos);
        			iRet = YC_ERROR_SUCCESS;
    			}
    			else
    			{
                    iRet = YC_ERROR_FAILED;
    			}
			}
		}
	}

	yc_free(pcBuf);
	if (NULL != pcRcvBuf)
	{
		yc_free(pcRcvBuf);
	}

    return iRet;
}

#if YC_CIOCTL_CFG_ASYN
int yc_cioctl_asyn(IN uint uiCmd,    IN const char *pcDstIP,
                   IN void *pInData, IN uint uiInDataLen)
{
    char *pcPos = NULL;
    char *pcBuf = NULL;
    unsigned int uiBufLen = 0;
    int iRet = YC_ERROR_FAILED;

    /* TLV: pos-1b, cmd-4b, indata*/
    uiBufLen = sizeof(unsigned char) + sizeof(unsigned int) + uiInDataLen;
    pcBuf = (char *)yc_malloc(uiBufLen);
    if (NULL == pcBuf)
    {
        return YC_ERROR_FAILED;
    }

    memset(pcBuf, 0, uiBufLen);
    pcPos = pcBuf;

    *(unsigned char *)pcPos = 1;
    pcPos += sizeof(unsigned char);
    *(unsigned int *)pcPos = uiCmd;
    pcPos += sizeof(unsigned int);
    memcpy(pcPos, pInData, uiInDataLen);

    if (YC_CIOCTL_LOCAL != pcDstIP)
    {
        iRet = yc_udp_send(pcDstIP, CIOCTL_LOCAL_PORT, pcBuf, uiBufLen);
    }
    else
    {
        iRet = setsockopt(g_iSocketId4Asyn, IPPROTO_IP,
                          YC_CIOCTL_SOCKET_OPS_SET,
                          pcBuf, sizeof(unsigned int) + uiInDataLen);
        if (0 == iRet)
        {
            iRet = YC_ERROR_SUCCESS;
        }
        else
        {
            iRet = YC_ERROR_FAILED;
        }
    }

    yc_free(pcBuf);

    return iRet;
}
#endif /* YC_CIOCTL_CFG_ASYN */
#endif /* YC_WINDOWS_LITE */

