#include <string.h>
#include "wm_include.h"
#include "libcli.h"

struct my_context {
  int value;
  char *message;
};

#define MODE_CONFIG_INT 10

int cmd_test(struct cli_def *cli, const char *command, char *argv[], int argc) {
  int i;
  cli_print(cli, "called %s with \"%s\"", __func__, command);
  cli_print(cli, "%d arguments:", argc);
  for (i = 0; i < argc; i++) cli_print(cli, "        %s", argv[i]);

  return CLI_OK;
}

int cmd_set(struct cli_def *cli, UNUSED(const char *command), char *argv[], int argc) {
  if (argc < 2 || strcmp(argv[0], "?") == 0) {
    cli_print(cli, "Specify a variable to set");
    return CLI_OK;
  }

  if (strcmp(argv[1], "?") == 0) {
    cli_print(cli, "Specify a value");
    return CLI_OK;
  }

  if (strcmp(argv[0], "regular_interval") == 0) {
    unsigned int sec = 0;
    if (!argv[1] && !*argv[1]) {
      cli_print(cli, "Specify a regular callback interval in seconds");
      return CLI_OK;
    }
    sscanf(argv[1], "%u", &sec);
    if (sec < 1) {
      cli_print(cli, "Specify a regular callback interval in seconds");
      return CLI_OK;
    }
    cli_print(cli, "Regular callback interval is now %d seconds", sec);
    return CLI_OK;
  }

  cli_print(cli, "Setting \"%s\" to \"%s\"", argv[0], argv[1]);
  return CLI_OK;
}

int cmd_config_int(struct cli_def *cli, UNUSED(const char *command), char *argv[], int argc) {
  if (argc < 1) {
    cli_print(cli, "Specify an interface to configure");
    return CLI_OK;
  }

  if (strcmp(argv[0], "?") == 0)
    cli_print(cli, "  test0/0");

  else if (strcasecmp(argv[0], "test0/0") == 0)
    cli_set_configmode(cli, MODE_CONFIG_INT, "test");
  else
    cli_print(cli, "Unknown interface %s", argv[0]);

  return CLI_OK;
}

int cmd_config_int_exit(struct cli_def *cli, UNUSED(const char *command), UNUSED(char *argv[]), UNUSED(int argc)) {
  cli_set_configmode(cli, MODE_CONFIG, NULL);
  return CLI_OK;
}

int cmd_show_regular(struct cli_def *cli, UNUSED(const char *command), char *argv[], int argc) {
  cli_print(cli, "cli_regular() has run times");
  return CLI_OK;
}

int cmd_debug_regular(struct cli_def *cli, UNUSED(const char *command), char *argv[], int argc) {
  cli_print(cli, "cli_regular() debugging is .");
  return CLI_OK;
}

int cmd_context(struct cli_def *cli, UNUSED(const char *command), UNUSED(char *argv[]), UNUSED(int argc)) {
  struct my_context *myctx = (struct my_context *)cli_get_context(cli);
  cli_print(cli, "User context has a value of %d and message saying %s", myctx->value, myctx->message);
  return CLI_OK;
}

void pc(UNUSED(struct cli_def *cli), const char *string) {
  printf("%s\n", string);
}

void UserMain(void)
{
    struct cli_command *c;
    struct cli_def *cli;

    // Prepare a small user context
    char mymessage[] = "I contain user data!";
    struct my_context myctx;
    myctx.value = 5;
    myctx.message = mymessage;

    cli = cli_init(TLS_UART_0);
    cli_set_banner(cli, "w60x wifi router");
    cli_set_hostname(cli, "w60x");
  cli_register_command(cli, NULL, "test", cmd_test, PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL);
  cli_register_command(cli, NULL, "simple", NULL, PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL);
  cli_register_command(cli, NULL, "simon", NULL, PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL);
  cli_register_command(cli, NULL, "set", cmd_set, PRIVILEGE_PRIVILEGED, MODE_EXEC, NULL);
  c = cli_register_command(cli, NULL, "show", NULL, PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL);
  cli_register_command(cli, c, "regular", cmd_show_regular, PRIVILEGE_UNPRIVILEGED, MODE_EXEC,
                       "Show the how many times cli_regular has run");
  cli_register_command(cli, c, "counters", cmd_test, PRIVILEGE_UNPRIVILEGED, MODE_EXEC,
                       "Show the counters that the system uses");
  cli_register_command(cli, c, "junk", cmd_test, PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL);
  cli_register_command(cli, NULL, "interface", cmd_config_int, PRIVILEGE_PRIVILEGED, MODE_CONFIG,
                       "Configure an interface");
  cli_register_command(cli, NULL, "exit", cmd_config_int_exit, PRIVILEGE_PRIVILEGED, MODE_CONFIG_INT,
                       "Exit from interface configuration");
  cli_register_command(cli, NULL, "address", cmd_test, PRIVILEGE_PRIVILEGED, MODE_CONFIG_INT, "Set IP address");
  c = cli_register_command(cli, NULL, "debug", NULL, PRIVILEGE_UNPRIVILEGED, MODE_EXEC, NULL);
  cli_register_command(cli, c, "regular", cmd_debug_regular, PRIVILEGE_UNPRIVILEGED, MODE_EXEC,
                       "Enable cli_regular() callback debugging");

  // Set user context and its command
  cli_set_context(cli, (void *)&myctx);
  cli_register_command(cli, NULL, "context", cmd_context, PRIVILEGE_UNPRIVILEGED, MODE_EXEC,
                       "Test a user-specified context");

    cli_print_callback(cli, pc);

    cli_loop(cli, TLS_UART_0);

    cli_done(cli);
}

