#include "wm_include.h"

#define DEMO_TASK_PRIO              32
#define DEMO_TASK_STK_SIZE          2048

#define DEMO_TASK_MSG_QUEUE_SIZE    4

#define DEMO_KEY                    WM_IO_PB_07

#define DEMO_KEY_USE_EX             0
#define DEMO_KEY_DELAY_TIME         250 /* 250tick = 500ms */

#define DEMO_MSG_KEY_PRESS          0x1

static tls_os_queue_t *demo_task_msg_queue = NULL;

static OS_STK demo_task_stk[DEMO_TASK_STK_SIZE / sizeof(OS_STK)];

static void demo_key_callback(void *ctx)
{
	u8 ret;
	enum tls_io_name pin;

	pin = (enum tls_io_name)(unsigned long)ctx;

	ret = tls_get_gpio_irq_status(pin);
	//printf("key status %hhu.\n", ret);
	if (ret) /* ʵԼio״̬޸״̬ж */
	{
		tls_clr_gpio_irq_status(pin);
        tls_os_queue_send(demo_task_msg_queue, (void *)DEMO_MSG_KEY_PRESS, 0);
	}

	return;
}

static void demo_key_event(void)
{
    int key_state = 0;
	int key_count = 0;
#if DEMO_KEY_USE_EX
	u32 curr_time;
	static u8  last_key_cnt  = 0;
	static u32 last_key_time = 0;
#endif

    do {
	    tls_os_time_delay(2);
	    key_count++;
	    key_state = tls_gpio_read(DEMO_KEY);
	} while(!key_state && (key_count <= 750)); /* ʵԼio״̬޸״̬жϣݶ3Ϊ750 * 2 tick = 1500 * 2 ms = 3s */

	//printf("key pressed %g seconds\r\n", (double)key_count * 2 * 2 / 1000);

	if ((key_count <= 250) && (key_count >= 5)) /* 20ms-1s */
	{
	    printf("key press short.\n"); /* ݵİһ°ť */

#if DEMO_KEY_USE_EX
        curr_time = tls_os_get_time();
        if ((curr_time - last_key_time) <= DEMO_KEY_DELAY_TIME)
        {
            if (1 == last_key_cnt)
            {
                printf("press thrid.\r\n"); /* ݵİ°ť */
            }
            else
            {
                printf("press second.\r\n"); /* ݵİ°ť */
                last_key_cnt++;
            }
        }
        else
        {
            last_key_cnt = 0;
        }

	    last_key_time = curr_time;
#endif
	}
	else if (key_count >= 750) /* >=3s */
	{
        printf("key press long.\n"); /* һ°ť */
	}

    return;
}

static void demo_key_init(void)
{
    /* ʵԼio״̬޸ */
    tls_gpio_cfg(DEMO_KEY, WM_GPIO_DIR_INPUT, WM_GPIO_ATTR_FLOATING);
  	tls_gpio_isr_register(DEMO_KEY, demo_key_callback, (void *)DEMO_KEY);
	tls_gpio_irq_enable(DEMO_KEY, WM_GPIO_IRQ_TRIG_FALLING_EDGE);

    return;
}

static void demo_task_entry(void *sdata)
{
    int   ret = WM_FAILED;
	void *msg = NULL;

    demo_key_init();

	for( ; ; )
	{
        ret = tls_os_queue_receive(demo_task_msg_queue, (void **)&msg, 0, 0);
        if (!ret)
        {
            switch((u32)msg)
        	{
                case DEMO_MSG_KEY_PRESS:
                {
                    demo_key_event();
                    break;
                }
                default:
        		{
        			break;
                }
            }
		}
	}
}

void UserMain(void)
{
	printf("\n gpio key demo\n");

    tls_os_queue_create(&demo_task_msg_queue, DEMO_TASK_MSG_QUEUE_SIZE);
    tls_os_task_create(NULL, "demo_task", demo_task_entry, NULL, (void *)demo_task_stk, DEMO_TASK_STK_SIZE, DEMO_TASK_PRIO, 0);
}

