
#define DS18B20_PIN   11
#define DS18B20_PIN_OUTP TLS_GPIO_DIR_OUTPUT
#define DS18B20_PIN_INP  TLS_GPIO_DIR_INPUT
#define HIGH 1
#define LOW 0

static unsigned char data[2];

static void DS18b20_delay(unsigned int time)
{
	unsigned int value=1;
	unsigned int RegValue;

	if(time < 5)	//5us֮ڲʱ,Ѿʱ
		return;
	RegValue = *(unsigned int *)(HR_CLK_DIV_CTL);
	//printf("\nRegVal=%d\n",RegValue&0x0000000f);
	switch(RegValue & 0x0000000F)
	{
		case 0x03:	//160M
			value = time*40;
			break;
		case 0x06:	//80M
			value = time*20;
			break;
		case 0x0c:	//40M
			value = time*10;
			break;
	}
	while(value --);
}

static unsigned char DS18b20_reset (void) 
{ 
    // GPIOB0ģʽ 
    tls_gpio_cfg(DS18B20_PIN, DS18B20_PIN_OUTP, TLS_GPIO_ATTR_FLOATING); 
     
    // 18B20һأָߵƽ״̬Լ100΢ 
    tls_gpio_write(DS18B20_PIN, HIGH); 
    DS18b20_delay(100); 
     
    // 18B20һ½أֵ͵ƽ״̬Լ600΢ 
    tls_gpio_write(DS18B20_PIN, LOW); 
    DS18b20_delay(600); 
     
    // 18B20һأʱͷDS18B20 
    tls_gpio_write(DS18B20_PIN, HIGH); 
    DS18b20_delay(100); 
     
    // ϶ǸDS18B20һλ 
    // ͨٴGPIOB1ų״̬Լ⵽DS18B20Ƿλɹ 
    tls_gpio_cfg(DS18B20_PIN, DS18B20_PIN_INP, TLS_GPIO_ATTR_FLOATING); 
     
    // ͷź״̬Ϊߵƽλʧ 
    if(tls_gpio_read(DS18B20_PIN)){ printf("DS18b20 reset failed.\r\n"); return 1;} 


    return 0; 
}  

static void DS18b20_write_byte (unsigned char byte) 
{ 
    unsigned char i; 
    // GPIOB1Ϊģʽ 
    tls_gpio_cfg(DS18B20_PIN, DS18B20_PIN_OUTP, TLS_GPIO_ATTR_FLOATING); 


    // д1ʱ϶ 
    //     ڵ͵ƽ1΢뵽15΢֮ 
    //     Ȼٱڸߵƽ15΢뵽60΢֮ 
    //     ״̬: 1΢ĵ͵ƽȻٱ60΢ĸߵƽ 
    // 
    // д0ʱ϶ 
    //     ڵ͵ƽ15΢뵽60΢֮ 
    //     Ȼٱڸߵƽ1΢뵽15΢֮ 
    //     ״̬: 60΢ĵ͵ƽȻٱ1΢ĸߵƽ 
    for (i = 0; i < 8; i++) 
    { 
        tls_gpio_write(DS18B20_PIN, LOW); DS18b20_delay(1); 
        if(byte & HIGH) 
        { 
             // byteD0λ1д1 
             // д1ʱ϶򣬵ƽڴ˴תΪ 
             tls_gpio_write(DS18B20_PIN, HIGH); 
        } 
        else  
        { 
             // byteD0λ0д0 
             // д0ʱ϶򣬵ƽڱΪ 
             // tls_gpio_write(DS18B20_PIN, LOW); 
        } 
        // ƽ״̬60΢ 
        DS18b20_delay(60); 


        tls_gpio_write(DS18B20_PIN, HIGH); 
        DS18b20_delay(15); 


        byte >>= 1; 
    } 
    tls_gpio_write(DS18B20_PIN, HIGH); 
}  


static unsigned char DS18b20_read_byte (void) 
{ 
    unsigned char i = 0; 
    unsigned char byte = 0; 
    // 1ʱ϶ 
    //     ״̬ڵ͵ƽ״̬1΢뵽15΢֮ 
    //     Ȼ䵽ߵƽ״̬ұ15΢뵽60΢֮ 
    //      ΪDS18B20һ1ź 
    //     : 1΢ĵ͵ƽȻٱ60΢ĸߵƽ 
    // 
    // 0ʱ϶ 
    //     ״̬ڵ͵ƽ״̬15΢뵽30΢֮ 
    //     Ȼ䵽ߵƽ״̬ұ15΢뵽60΢֮ 
    //     ΪDS18B20һ0ź 
    //     : 15΢ĵ͵ƽȻٱ46΢ĸߵƽ 
    for (i = 0; i < 8; i++) 
    { 
        tls_gpio_cfg(DS18B20_PIN, DS18B20_PIN_OUTP, TLS_GPIO_ATTR_FLOATING);  
        tls_gpio_write(DS18B20_PIN, LOW); 


        DS18b20_delay(1); 
        byte >>= 1; 


        tls_gpio_write(DS18B20_PIN, HIGH); 
        tls_gpio_cfg(DS18B20_PIN, DS18B20_PIN_INP, TLS_GPIO_ATTR_FLOATING); 


        // Ϊ͵ƽ֮1΢֮ڱΪ 
        // ΪDS18B20յһ1ź 
        // ˰byteD7Ϊá1 
        if (tls_gpio_read(DS18B20_PIN)) byte |= 0x80; 
        DS18b20_delay(60); 
    } 
    return byte;        
} 


static void DS18b20_proc(void)          
{ 
    while(DS18b20_reset()); 
     
    DS18b20_delay(120); 
     
    DS18b20_write_byte(0xcc); 
    DS18b20_write_byte(0x44); 
     
    DS18b20_delay(5); 
     
    while(DS18b20_reset()); 
    DS18b20_delay(200); 
     
    DS18b20_write_byte(0xcc); 
    DS18b20_write_byte(0xbe); 
     
    data[0] = DS18b20_read_byte(); 
    data[1] = DS18b20_read_byte(); 
}  


static void DS18b20_read(void) 
{
    unsigned short temp=0;
    double result=0; 

    DS18b20_proc(); 
    temp=((unsigned short)data[1])<<8; 
    temp|=(unsigned short)data[0];
    result=0.0625*((double)temp); 

    printf("temp is %g\r\n", result);
     
    return; 
}
