# Contributing to Eclipse Wakaama

Thanks for your interest in this project.

## Project description

Wakaama provides APIs for a server application to send commands to registered
LWM2M Clients. On client applications, Wakaama checks received commands for
syntax and access rights and then dispatches them to the relevant objects.

* https://projects.eclipse.org/projects/iot.wakaama

## Developer resources

The project maintains the following source code repositories

* https://github.com/eclipse/wakaama

This project uses GitHub issues to track ongoing development and issues.

Be sure to search for existing bugs before you create another one. Remember that
contributions are always welcome!

### Making your changes

Every commit you make in your patch or pull request MUST be "signed off".
You do this by adding the `-s` flag when you make the commit(s), e.g.

`git commit -s -m "Shave the yak some more"`

* Fork the repository on GitHub
* Create a new branch for your changes
* Make your changes
* Make sure you include tests
* Make sure the test suite passes after your changes
* Commit your changes into that branch
* Use descriptive and meaningful commit messages
* Make sure you use the `-s` flag when committing as explained above.
* Push your changes to your branch in your forked repository

### Submitting the changes

Submit a pull request via the normal GitHub UI.

### After submitting

Do not use your branch for any other development, otherwise further changes that you make will be visible in the PR.

## Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Contact

Contact the project developers via the project's "dev" list.

* https://dev.eclipse.org/mailman/listinfo/wakaama-dev

