#ifndef __YC_SOCKET_H__
#define __YC_SOCKET_H__

/***************************************************************
 *              socket׽ַװӿ                           *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2014 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


/* ======================== 1.socket/ӿ ======================== */

/*****************************************************************************
   (Prototype)    : yc_udp_send
 (Description)  : udp
 (Input)        : pcDstIP        Ŀipַ
                          usDstPort      ĿĶ˿
                          pData          Ҫ͵
                          uiDataLen      Ҫ͵ݳ
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_udp_send(IN const char *pcDstIP, IN ushort usDstPort,
                IN const void *pData,   IN uint   uiDataLen);

/*****************************************************************************
   (Prototype)    : yc_tcp_send
 (Description)  : tcp
 (Input)        : pcDstIP        Ŀipַ
                          usDstPort      ĿĶ˿
                          pData          Ҫ͵
                          uiDataLen      Ҫ͵ݳ
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_tcp_send(IN char *pcDstIP,     IN ushort usDstPort,
                IN const void *pData, IN uint uiDataLen);

/*****************************************************************************
   (Prototype)    : yc_udp_send_and_rcv
 (Description)  : udpݣȴջӦݣ
                          ǰҪдpuiOutDataLenΪЧֵ
 (Input)        : uiTimeOut       ճʱʱ䣬λ룬Ϊ0ȴ
                          pcDstIP         Ŀipַ
                          usDstPort       ĿĶ˿
                          pInData         Ҫ͵
                          uiDataLen       Ҫ͵ݳ
 (Output)       : pOutData        ջ
                          puiOutDataLen   ջ/յݳ
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    YC_ERROR_TIMEOUT    ʱ(recv timeout)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_udp_send_and_rcv(IN uint uiTimeOut,
                        IN const char *pcDstIP, IN ushort usDstPort,
                        IN const void *pInData, IN uint uiDataLen,
                        OUT void *pOutData,     INOUT uint *puiOutDataLen);

/*****************************************************************************
   (Prototype)    : yc_tcp_send_and_rcv
 (Description)  : tcpݣȴջӦݣ
                          ǰҪдpuiOutDataLenΪЧֵ
 (Input)        : uiTimeOut       ճʱʱ䣬λ룬Ϊ0ȴ
                          pcDstIP         Ŀipַ
                          usDstPort       ĿĶ˿
                          pInData         Ҫ͵
                          uiDataLen       Ҫ͵ݳ
 (Output)       : pOutData        ջ
                          puiOutDataLen   ջ/յݳ
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    YC_ERROR_TIMEOUT    ʱ(recv timeout)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_tcp_send_and_rcv(IN uint uiTimeOut,
                        IN char *pcDstIP,       IN ushort usDstPort,
                        IN const void *pInData, IN uint uiDataLen,
                        OUT void *pOutData,     INOUT uint *puiOutDataLen);


/* =========================== 2.ͨsocketӿ ============================ */

/*****************************************************************************
   (Prototype)    : yc_socket_send
 (Description)  : 
 (Input)        : iSocketID      socketļ
                          pData          Ҫ͵
                          uiDataLen      Ҫ͵ݳ
                          pcDstIP        ĿipַNULL
                          usDstPort      ĿĶ˿ڣ0
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_socket_send(IN int iSocketID,
                   IN const void *pData,   IN uint uiDataLen,
                   IN const char *pcDstIP, IN ushort usDstPort);

/*****************************************************************************
   (Prototype)    : yc_socket_recv
 (Description)  : 
 (Input)        : iSocketID      socketļ
                          uiWaitTime     ճʱʱ
                          uiBufferLen    ջ
 (Output)       : pBuffer        ջ
                          pcSrcIP        ԴipַNULL
                          pusSrcPort     Դ˿ڣ0
   ֵ(Return Value) : int        >0         յݳ(length)
                                    <=0         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_socket_recv(IN int iSocketID,  IN uint uiWaitTime,
                   OUT void *pBuffer, IN uint uiBufferLen,
                   OUT char *pcSrcIP, OUT ushort *pusSrcPort);

/*****************************************************************************
   (Prototype)    : yc_socket_set_blocking
 (Description)  : socketǷ
 (Input)        : iSocketID      socketļ
                          bIsBlock       Ƿ
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    YC_ERROR_FAILED     ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_socket_set_blocking(IN int iSocketID,  IN bool_t bIsBlock);

/*****************************************************************************
   (Prototype)    : yc_socket_connect
 (Description)  : tcp
 (Input)        : pcDstIP       Ŀĵַ
                          usDstPort     ĿĶ˿
                          uiWaitTime    ӳʱʱ䣬λ, Ϊ0ʹĬֵ
 (Output)       : (None)
   ֵ(Return Value) : int       >=0     socketļ(socket fd)
                                     <0     ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_socket_connect(IN const char *pcDstIP,
                      IN ushort usDstPort,
                      IN uint uiWaitTime);

/* =========================== 3.UDP serverӿ ============================ */

typedef struct tagSocket_server_ctx yc_socket_server_ctx_s;

typedef struct tagSocket_server{
    int iSockfd;
    yc_socket_server_ctx_s *ctx;
}yc_socket_server_s;

/*****************************************************************************
   (Prototype)    : yc_udp_server_rcv_pf
 (Description)  : udpݻص
 (Input)        : iSockfd        udpsocketļ
                          pArg           udpݻص˽в
                          pData          յ
                          uiDataLen      յݳ
                          pcSrcIP        Դipַ
                          usSrcPort      Դ˿
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
typedef void (*yc_udp_server_rcv_pf)(IN int iSockfd,         IN void *pArg,
                                     IN const void *pData,   IN uint uiDataLen,
                                     IN const char *pcSrcIP, IN ushort usSrcPort);

/*****************************************************************************
   (Prototype)    : yc_udp_server_create
 (Description)  : һudp
 (Input)        : usLocalPort       ض˿
                          pfRcvCallback     udpݻص
                          pArg              udpݻص˽в
 (Output)       : (None)
   ֵ(Return Value) : yc_socket_server_s*   !NULL    ɹ(success)
                                                 NULL    ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
yc_socket_server_s *yc_udp_server_create(IN ushort usLocalPort,
                                         IN yc_udp_server_rcv_pf pfRcvCallback,
                                         IN void *pArg);

/*****************************************************************************
   (Prototype)    : yc_udp_server_destroy
 (Description)  : رһudp
 (Input)        : pstHandle       udp
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_udp_server_destroy(IN yc_socket_server_s *pstHandle);


/* =========================== 4.TCP serverӿ ============================ */

/*****************************************************************************
   (Prototype)    : tcp_server_rcv_pf
 (Description)  : tcpݻص
 (Input)        : iSocketID        ͻsocketļ
                          pArg             ݽջص˽в
                          pData            յ
                          uiDataLen        յݳȣΪ0˵ͻж(ֶرոsocket)
                          pcSrcIP          Դipַ
                          usSrcPort        Դ˿
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
typedef void (*tcp_server_rcv_pf)(IN int iSocketID,       IN void *pArg,
                                  IN const void *pData,   IN unsigned int uiDataLen,
                                  IN const char *pcSrcIP, IN unsigned short usSrcPort);

/*****************************************************************************
   (Prototype)    : yc_tcp_server_create
 (Description)  : һtcp
                          ÿ30Զ̽ͻǷ
                          رһͻyc_tcp_server_close_client
 (Input)        : usLocalPort       ض˿
                          pfRcvCallback     tcpݻص
                          pArg              tcpݻص˽в
 (Output)       : (None)
   ֵ(Return Value) : yc_socket_server_s*   !NULL    ɹ(success)
                                                 NULL    ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
yc_socket_server_s *yc_tcp_server_create(IN unsigned short usLocalPort,
                                         IN tcp_server_rcv_pf pfRcvCallback,
                                         IN void *pArg);

/*****************************************************************************
   (Prototype)    : yc_tcp_server_destroy
 (Description)  : رһtcpرշرпͻ
 (Input)        : pstHandle       tcp
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_tcp_server_destroy(IN yc_socket_server_s *pstHandle);

/*****************************************************************************
   (Prototype)    : yc_tcp_server_close_client
 (Description)  : رһtcpͻ
 (Input)        : pstHandle       tcp
                          iClientFd       ͻsocketļ
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_tcp_server_close_client(IN yc_socket_server_s *pstHandle,
                               IN int iClientFd);

/*****************************************************************************
   (Prototype)    : yc_tcp_server_show_client
 (Description)  : ӡȫtcpͻ
 (Input)        : pstHandle       tcp
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_tcp_server_show_client(IN const yc_socket_server_s *pstHandle);


/* ===================== 5.UNIX׽ֶ/ӿ ===================== */

/*****************************************************************************
   (Prototype)    : yc_unix_dgram_send
 (Description)  : 
 (Input)        : pcName         Ŀ
                          pData          Ҫ͵
                          uiDataLen      Ҫ͵ݳ
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_unix_dgram_send(IN const char *pcName,
                       IN const void *pData, IN uint uiDataLen);

/*****************************************************************************
   (Prototype)    : yc_unix_stream_send
 (Description)  : 
 (Input)        : pcName         Ŀ
                          pData          Ҫ͵
                          uiDataLen      Ҫ͵ݳ
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_unix_stream_send(IN const char *pcName,
                        IN const void *pData, IN uint uiDataLen);

/*****************************************************************************
   (Prototype)    : yc_unix_dgram_send_and_rcv
 (Description)  : ݣȴջӦݣ
                          ǰҪдpuiOutDataLenΪЧֵ
 (Input)        : pcName          Ŀ
                          uiTimeOut       ճʱʱ䣬λ룬Ϊ0ȴ
                          pInData         Ҫ͵
                          uiDataLen       Ҫ͵ݳ
 (Output)       : pOutData        ջ
                          puiOutDataLen   ջ/յݳ
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    YC_ERROR_TIMEOUT    ʱ(recv timeout)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_unix_dgram_send_and_rcv(IN const char *pcName,  IN uint uiTimeOut,
                               IN const void *pInData, IN uint uiDataLen,
                               OUT void *pOutData,     INOUT uint *puiOutDataLen);

/*****************************************************************************
   (Prototype)    : yc_unix_stream_send_and_rcv
 (Description)  : ݣȴջӦݣ
                          ǰҪдpuiOutDataLenΪЧֵ
 (Input)        : pcName          Ŀ
                          uiTimeOut       ճʱʱ䣬λ룬Ϊ0ȴ
                          pInData         Ҫ͵
                          uiDataLen       Ҫ͵ݳ
 (Output)       : pOutData        ջ
                          puiOutDataLen   ջ/յݳ
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    YC_ERROR_TIMEOUT    ʱ(recv timeout)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_unix_stream_send_and_rcv(IN const char *pcName,  IN uint uiTimeOut,
                                IN const void *pInData, IN uint uiDataLen,
                                OUT void *pOutData,     INOUT uint *puiOutDataLen);


/* ====================== 6.UNIX׽ͨ/ӿ ====================== */

/*****************************************************************************
   (Prototype)    : yc_unix_socket_send
 (Description)  : 
 (Input)        : iSocketID      socketļ
                          pcName         Ŀ
                          pData          Ҫ͵
                          uiDataLen      Ҫ͵ݳ
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_unix_socket_send(IN int iSocketID, IN const char *pcName,
                        IN const void *pData, IN uint uiDataLen);

/*****************************************************************************
   (Prototype)    : yc_unix_socket_recv
 (Description)  : 
 (Input)        : iSocketID      socketļ
                          uiWaitTime     ճʱʱ
                          uiBufferLen    ջ
 (Output)       : pBuffer        ջ
                          pcSrcName      ԴƣNULL
   ֵ(Return Value) : int        >0         յݳ(length)
                                    <=0         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_unix_socket_recv(IN int iSocketID,  IN uint uiWaitTime,
                        OUT void *pBuffer, IN uint uiBufferLen,
                        OUT char *pcSrcName);


/* ================== 7.ӵUNIX׽serverӿ ===================== */

/*****************************************************************************
   (Prototype)    : yc_unix_server_rcv_pf
 (Description)  : unixݻص
 (Input)        : iSockfd          ͻsocketļ
                          pcName           Դ
                          pArg             ݻص˽в
                          pData            յ
                          uiDataLen        յݳȣΪ0˵ͻж(ֶرոsocket)
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
typedef void (*yc_unix_server_rcv_pf)(IN int iSockfd,
                                      IN const char *pcName,
                                      IN void *pArg,
                                      IN const void *pData, IN uint uiDataLen);

/*****************************************************************************
   (Prototype)    : yc_unix_dgram_server_create
 (Description)  : unix
 (Input)        : pcName            
                          pfRcvCallback     unixݻص
                          pArg              unixݻص˽в
 (Output)       : (None)
   ֵ(Return Value) : yc_socket_server_s*   !NULL    ɹ(success)
                                                 NULL    ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
yc_socket_server_s *yc_unix_dgram_server_create(IN const char *pcName,
                                                IN yc_unix_server_rcv_pf pfRcvCallback,
                                                IN void *pArg);

/*****************************************************************************
   (Prototype)    : yc_unix_dgram_server_destroy
 (Description)  : رһunix
 (Input)        : pstHandle       unix
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_unix_dgram_server_destroy(IN yc_socket_server_s *pstHandle);


/* =================== 8.ӵUNIX׽serverӿ ==================== */

/*****************************************************************************
   (Prototype)    : yc_unix_stream_server_create
 (Description)  : unix
                          رһͻyc_unix_stream_server_close_client
 (Input)        : pcName            
                          pfRcvCallback     unixݻص
                          pArg              unixݻص˽в
 (Output)       : (None)
   ֵ(Return Value) : yc_socket_server_s*   !NULL    ɹ(success)
                                                 NULL    ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
yc_socket_server_s *yc_unix_stream_server_create(IN const char *pcName,
                                                 IN yc_unix_server_rcv_pf pfRcvCallback,
                                                 IN void *pArg);

/*****************************************************************************
   (Prototype)    : yc_unix_stream_server_destroy
 (Description)  : رһunixرշرпͻ
 (Input)        : pstHandle       unix
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_unix_stream_server_destroy(IN yc_socket_server_s *pstHandle);

/*****************************************************************************
   (Prototype)    : yc_unix_stream_server_close_client
 (Description)  : رһunixͻ
 (Input)        : pstHandle       unix
                          iClientFd       ͻsocketļ
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_unix_stream_server_close_client(IN yc_socket_server_s *pstHandle,
                                       IN int iClientFd);

/*****************************************************************************
   (Prototype)    : yc_unix_stream_server_show_client
 (Description)  : ӡȫunixͻ
 (Input)        : pstHandle       unix
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/10/12
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_unix_stream_server_show_client(IN const yc_socket_server_s *pstHandle);

#endif /* __YC_SOCKET_H__ */

