#ifndef __YC_SDB_H__
#define __YC_SDB_H__

/***************************************************************
 *             򵥵ݶȡ/ӿ                         *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2014 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


typedef enum tagSdb_db_type{
    YC_SDB_DB_TYPE_CONF = 0,  /* ÿ⣬һֱ */
    YC_SDB_DB_TYPE_RUN,       /* п⣬ϵͳᱻ */
}YC_SDB_DB_TYPE_E;


/*****************************************************************************
   (Prototype)    : yc_sdb_init
 (Description)  : ʼݿ⣬ʼ
 (Input)        : enDbType      ݿ
 (Output)       : (None)
   ֵ(Return Value) : int   YC_ERROR_SUCCESS    ɹ(success)
                                other               ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/12/28
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_sdb_init(IN YC_SDB_DB_TYPE_E enDbType);

/*****************************************************************************
   (Prototype)    : yc_sdb_fini
 (Description)  : ȥʼݿ⣬ʱҪȥʼ
 (Input)        : enDbType      ݿ
 (Output)       : (None)
   ֵ(Return Value) : int   YC_ERROR_SUCCESS    ɹ(success)
                                other               ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/12/28
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_sdb_fini(IN YC_SDB_DB_TYPE_E enDbType);

/*****************************************************************************
   (Prototype)    : yc_sdb_create
 (Description)  : ݿ⣬Ҫһ
 (Input)        : enDbType      ݿ
                          pcDbName      ݿ
 (Output)       : (None)
   ֵ(Return Value) : int   YC_ERROR_SUCCESS      ɹ(success)
                                ERROR_ALREADY_EXIST   Ѿ(exist)
                                other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/12/28
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_sdb_create(IN YC_SDB_DB_TYPE_E enDbType, IN const char *pcDbName);

/*****************************************************************************
   (Prototype)    : yc_sdb_destroy
 (Description)  : ɾݿ⣬ݱɾ
 (Input)        : enDbType      ݿ
                          pcDbName      ݿ
 (Output)       : (None)
   ֵ(Return Value) : int   YC_ERROR_SUCCESS      ɹ(success)
                                other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/12/28
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_sdb_destroy(IN YC_SDB_DB_TYPE_E enDbType, IN const char *pcDbName);

/*****************************************************************************
   (Prototype)    : yc_sdb_save
 (Description)  : ݣ
                          ݽkey-valueķʽڿҪ֤keyΨһ
 (Input)        : enDbType      ݿ
                          pcDbName      ݿ
                          pcKey         key
                          pData         
                          uiDataLen     ݳ
 (Output)       : (None)
   ֵ(Return Value) : int   YC_ERROR_SUCCESS      ɹ(success)
                                other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/12/28
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_sdb_save(IN YC_SDB_DB_TYPE_E enDbType,
                IN const char *pcDbName,
                IN const char *pcKey,
                IN const void *pData,
                IN uint uiDataLen);

/*****************************************************************************
   (Prototype)    : yc_sdb_delete
 (Description)  : ɾݣݽkeyΪΨһɾ
 (Input)        : enDbType      ݿ
                          pcDbName      ݿ
                          pcKey         key
 (Output)       : (None)
   ֵ(Return Value) : int   YC_ERROR_SUCCESS      ɹ(success)
                                other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/12/28
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_sdb_delete(IN YC_SDB_DB_TYPE_E enDbType,
                  IN const char *pcDbName,
                  IN const char *pcKey);

/*****************************************************************************
   (Prototype)    : yc_sdb_get
 (Description)  : ݣݽkey-valueķʽ
 (Input)        : enDbType      ݿ
                          pcDbName      ݿ
                          pcKey         key
 (Output)       : pData         ȡ
                          puiDataLen    ȡݳ
   ֵ(Return Value) : int   YC_ERROR_SUCCESS      ɹ(success)
                                other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/12/28
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_sdb_get(IN YC_SDB_DB_TYPE_E enDbType,
               IN const char *pcDbName,
               IN const char *pcKey,
               OUT void *pData,
               OUT uint *puiDataLen);

#endif /* __YC_SDB_H__ */

