#ifndef __YC_RTSP_H__
#define __YC_RTSP_H__

/***************************************************************
 *          Real Time Streaming Protocol                       *
 *            ʵʱݶȡӿ                         *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2016 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


typedef struct tagRtsp_Prvi yc_rtsp_priv_s;

typedef struct tagRtp_Exthead{
    ushort profile;
    ushort length;
}yc_rtp_ext_head_s;

typedef struct tagRtp_Packet{
    uchar csrc_count:   4;
    uchar extension:    1;
    uchar padding:      1;
    uchar version:      2;
    uchar payload_type: 7;
    uchar maker:        1;
    ushort seq_no;
    uint   timestamp;
    uint   ssrc;
    /* ccrc 0~15 */
    /* ext */
    /* payload */
    /* pading 0-... */
}yc_rtp_packet_s;

typedef struct tagRtsp_Media
{
	char *media_name;
	char *codec_name;
	char *control_path;
	ushort client_port;
	uchar  payload_type;
	uint   channel_num;
	uint   timestamp_frequency;
    uint64 time_len;

	struct tagRtsp_Media *next;
} yc_rtsp_media_s;

typedef struct tagRtsp_Handle{
    yc_rtsp_media_s *media;

    yc_rtsp_priv_s  *prvi;  /* resved */
}yc_rtsp_s;

/*****************************************************************************
   (Prototype)    : yc_rtsp_connect
 (Description)  : RTSP
 (Input)        : pcUrl             RTSPַ
 (Output)       : (None)
   ֵ(Return Value) : yc_rtsp_s *       !NULL        ɹ(success)
                                             NULL        ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/9/10
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
yc_rtsp_s *yc_rtsp_connect(IN const char *pcUrl);

/*****************************************************************************
   (Prototype)    : yc_rtsp_close
 (Description)  : رRTSP
 (Input)        : pRtsp    RTSP
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/9/10
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_rtsp_close(IN yc_rtsp_s *pRtsp);

/*****************************************************************************
   (Prototype)    : yc_rtsp_play
 (Description)  : Ͳ
 (Input)        : pRtsp    RTSP
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/9/10
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_rtsp_play(IN yc_rtsp_s *pRtsp);

/*****************************************************************************
   (Prototype)    : yc_rtsp_pause
 (Description)  : ͣ
 (Input)        : pRtsp    RTSP
 (Output)       : (None)
   ֵ(Return Value) : int       YC_ERROR_SUCCESS    ɹ(success)
                                    (other)         ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/9/10
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_rtsp_pause(IN yc_rtsp_s *pRtsp);

/*****************************************************************************
   (Prototype)    : yc_rtsp_read
 (Description)  : ȡRTP
 (Input)        : pRtsp    RTSP
 (Output)       : ppData   ָRTPЯЧݣΪ
                          ppRtp    ָRTPͷΪ
   ֵ(Return Value) : int        >0          Чݳ(payload length)
                                    <=0          ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2014/9/10
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_rtsp_read(IN yc_rtsp_s *pRtsp, OUT char **ppData, OUT yc_rtp_packet_s **ppRtp);

#endif /* __YC_RTSP_H__ */

