#ifndef __YC_HTTPC_H__
#define __YC_HTTPC_H__

/***************************************************************
 *              http client ؽӿ                           *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2016 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/

typedef struct tagHttpc_private yc_httpc_prvi_s;

typedef struct tagHttpc_handle{
    uint content_len;        /* Ҫܳ */

    bool_t is_accept_range;  /* Ƿֶ֧ϵ */
    bool_t is_long_conn;     /* Ƿֳ֧ */

    yc_httpc_prvi_s *pri;    /* ˽ݣϵͳ */
}yc_httpc_handle_s;

/*****************************************************************************
   (Prototype)    : yc_httpc_get_request
 (Description)  : http get,
                          ֳ֧ӵķظãҪȹر´
 (Input)        : pcUrl             ַ
                          uiOffset          ƫλãҪڶϵ
 (Output)       : pstHttpHandle     httpcһεñָNULL
   ֵ(Return Value) : int    YC_ERROR_SCUCCESS       ɹ(success)
                                 other                   ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/8/13
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_httpc_get_request(IN const char *pcUrl,
                         IN uint uiOffset,
                         INOUT yc_httpc_handle_s **pstHttpHandle);

/*****************************************************************************
   (Prototype)    : yc_httpc_get_data
 (Description)  : 
 (Input)        : pstHttpc          httpc
                          uiBufLen          ݶȡС
 (Output)       : pcBuf             ݶȡ
   ֵ(Return Value) : int        >0     ʵʶȡݳ(actually length)
                                    <=0     ȡʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/8/13
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_httpc_get_data(IN yc_httpc_handle_s *pstHttpc,
                      OUT char *pcBuf, IN uint uiBufLen);

/*****************************************************************************
   (Prototype)    : yc_httpc_put_request
 (Description)  : http put,
                          ֳ֧ӵķظãҪȹر´
 (Input)        : pcUrl             ַ
                          pcName            putĿ
                          uiDataLen         Ҫϴݳ
 (Output)       : pstHttpHandle     httpcһεñָNULL
   ֵ(Return Value) : int    YC_ERROR_SCUCCESS       ɹ(success)
                                 other                   ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/3
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_httpc_put_request(IN const char *pcUrl,
                         IN const char *pcName,
                         IN uint uiDataLen,
                         INOUT yc_httpc_handle_s **pstHttpHandle);

/*****************************************************************************
   (Prototype)    : yc_httpc_put_data
 (Description)  : ϴ
 (Input)        : pstHttpc          httpc
                          pData             Ҫϴ
                          uiDataLen         ݳ
 (Output)       : (None)
   ֵ(Return Value) : int    YC_ERROR_SCUCCESS       ɹ(success)
                                 other                   ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/9/3
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_httpc_put_data(IN yc_httpc_handle_s *pstHttpc,
                      IN const void *pData, IN uint uiDataLen);

/*****************************************************************************
   (Prototype)    : yc_httpc_close
 (Description)  : ر
 (Input)        : pstHttpc          httpc
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2016/8/13
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_httpc_close(IN yc_httpc_handle_s *pstHttpc);

#endif /* __YC_HTTPC_H__ */

