#ifndef __YC_EPOLL_H__
#define __YC_EPOLL_H__

/***************************************************************
 *                  simple epoll                               *
 *         32λϵͳ(only for 32bit os)                 *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2015 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


/*
 Լ¼:
 #include <sys/epoll.h>
 EPOLLIN      - read
 EPOLLOUT     - write
 EPOLLRDHUP   - connection closed
 EPOLLPRI     - read(urgent data)
 EPOLLERR     - error
 EPOLLHUP     - happened hang up
 EPOLLET      - the edge triggered (default is level triggered)
 EPOLLONESHOT - the one-shot behavior
*/


/*****************************************************************************
   (Prototype)    : yc_epoll_event_proc_callback
 (Description)  : epoll¼֮ص,
                          ݷֵԶ޸epoll¼Ϊ0κ޸
 (Input)        : iEventFd      ļ
                          uiEvent       ¼
 (Output)       : (None)
   ֵ(Return Value) : uint       epoll¼(EPOLLIN/EPOLLOUT/...)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/3/21
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
typedef uint (*yc_epoll_event_proc_callback)(IN int iEventFd, IN uint uiEvent);

/*****************************************************************************
   (Prototype)    : yc_epoll_create
 (Description)  : epollļ
 (Input)        : iSize      ɼļĿ
 (Output)       : (None)
   ֵ(Return Value) : int        >=0                ļ(epoll fd)
                                     YC_ERROR_FAILED    ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/3/21
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_epoll_create(IN int iSize);

/*****************************************************************************
   (Prototype)    : yc_epoll_destroy
 (Description)  : رepollļ
 (Input)        : iEpFd      Ҫرյepollļ
 (Output)       : (None)
   ֵ(Return Value) : int        YC_ERROR_SUCCESS      ɹ(success)
                                     YC_ERROR_FAILED       ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/3/21
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_epoll_destroy(IN int iEpFd);

/*****************************************************************************
   (Prototype)    : yc_epoll_add
 (Description)  : Ҫfd뵽epoll
 (Input)        : iEpFd         epollļ
                          iEventFd      Ҫļ
                          uiEvent       Ҫ¼
                          pfCallback    epoll¼֮ص
 (Output)       : (None)
   ֵ(Return Value) : int        YC_ERROR_SUCCESS      ɹ(success)
                                     other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/3/21
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_epoll_add(IN int iEpFd,
                 IN int iEventFd,
                 IN uint uiEvent,
                 IN yc_epoll_event_proc_callback pfCallback);

/*****************************************************************************
   (Prototype)    : yc_epoll_del
 (Description)  : fdepollɾ
 (Input)        : iEpFd         epollļ
                          iEventFd      Ҫɾļ
 (Output)       : (None)
   ֵ(Return Value) : int        YC_ERROR_SUCCESS      ɹ(success)
                                     other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/3/21
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_epoll_del(IN int iEpFd, IN int iEventFd);

/*****************************************************************************
   (Prototype)    : yc_epoll_mod
 (Description)  : ޸Ѿfd
 (Input)        : iEpFd         epollļ
                          iEventFd      ļ
                          uiEvent       ¼
                          pfCallback    epoll¼֮ص
 (Output)       : (None)
   ֵ(Return Value) : int        YC_ERROR_SUCCESS      ɹ(success)
                                     other                 ʧ(fail)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/3/21
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
int yc_epoll_mod(IN int iEpFd,
                 IN int iEventFd,
                 IN uint uiEvent,
                 IN yc_epoll_event_proc_callback pfCallback);

/* 
   ERROR_SUCCESSepoll fdرշERROR_FAILED */
/*****************************************************************************
   (Prototype)    : yc_epoll_wait
 (Description)  : ȴ¼Ĳýӿڻ߳̽ѯ
                          yc_epoll_destroyɹرiEpFdʹýӿ˳
 (Input)        : iEpFd         epollļ
                          uiMaxEvent    ¼Ŀ
 (Output)       : (None)
   ֵ(Return Value) : (None)

 ޸ʷ(History)      :
  1.    (Date)         : 2015/3/21
        (Author)       : yichen
    ޸(Modification) : ɺ(Created function)

*****************************************************************************/
void yc_epoll_wait(IN int iEpFd, IN uint uiMaxEvent);

#endif /* __YC_EPOLL_H__ */

