#ifndef __YC_BASETYPE_H__
#define __YC_BASETYPE_H__

/***************************************************************
 *           Ͷӿ                    *
 *                                                             *
 *                                                             *
 *               yichen@wdyichen.cn                            *
 *       copyright (c) 2014 www.wdyichen.cn                    *
 *                                                             *
 ***************************************************************/


/* ==========1.ݽṹ========== */
#define YC_ERROR_SUCCESS 	                 0
#define YC_ERROR_FAILED 	                -1
#define YC_ERROR_MEM 	                    -3
#define YC_ERROR_TIMEOUT                    -4
#define YC_ERROR_NOT_SUPPORT                -5
#define YC_ERROR_PARAM                      -6
#define YC_ERROR_EMPTY                      -7
#define YC_ERROR_FULL                       -8
#define YC_ERROR_NOT_EXIST                  -9
#define YC_ERROR_ALREADY_EXIST              -10
#define YC_ERROR_EOF                        -11

#define YC_ERROR_EXIT                       -0xAA3FF

#define YC_INVALID_HANDLE 	                ((void *)-1)


/* ==================== */
/*
 ϵͳͷļѾ˺ܶ:
 #include <stdint.h>
 #include <sys/types.h>
*/

#ifndef uint64
#define uint64  uint64_t
#endif

#ifndef int64
#define int64   int64_t
#endif

#ifndef uchar
#define uchar   unsigned char
#endif

/* ĳЩϵͳboolĶ */
#ifndef bool_t
typedef unsigned char bool_t;
#endif

#ifndef true
#define true    ((bool_t) 1)
#endif

#ifndef false
#define false   ((bool_t) 0)
#endif


/* ==========2.ɶǿ========== */
/* Բ */
#ifndef YC_IGNOPARA
#define YC_IGNOPARA(x)	((x) = (x))
#endif

/* IN OUT INOUT */
#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

#ifndef INOUT
#define INOUT
#endif


/* ==========3.========== */
#ifdef YC_DEBUG
#define YC_DBG_PRINT(fmt,arg...) printf(fmt,##arg)
#define YC_DBG_PERROR(note)      perror(note)

#ifdef KERNEL
#define YC_DBG_PRINK(fmt,arg...) printk(fmt,##arg)
#else
#define YC_DBG_PRINK(fmt,arg...)
#endif

#else
#define YC_DBG_PRINT(fmt,arg...)
#define YC_DBG_PERROR(note)

#ifdef KERNEL
#define YC_DBG_PRINK(fmt,arg...)
#endif
#endif


/* ==========4.Զԣʧʱֹ========== */
#ifdef YC_DEBUG
#define YC_DBGASSERT(expression) \
		if(!(expression))\
		{\
			printf("Assertion failed (%s), in file: %s, function: %s, line: %d.\r\n", \
			#expression, __FILE__, __FUNCTION__, __LINE__);\
		}
#else
#define YC_DBGASSERT(expression)
#endif


/* ==========5.container_of========== */
#undef offsetof
#ifdef __compiler_offsetof
#define offsetof(TYPE,MEMBER) __compiler_offsetof(TYPE,MEMBER)
#else
#define offsetof(TYPE, MEMBER) ((size_t) &((TYPE *)0)->MEMBER)
#endif

#ifndef container_of
#define container_of(ptr, type, member) ({			\
	    const typeof(((type *)0)->member) * __mptr = (ptr);	\
	    (type *)((char *)__mptr - offsetof(type, member)); })
#endif


/* ==========6.ȽϴС========== */
#ifndef YC_MAX
#define YC_MAX(x, y)  ((x) > (y) ? (x) : (y))
#endif

#ifndef YC_MIN
#define YC_MIN(x, y)  ((x) > (y) ? (y) : (x))
#endif

#endif  /* __YC_BASETYPE_H__ */

