#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>

#include "include/yc_basetype.h"
#include "include/yc_socket.h"
#include "include/yc_conf.h"
#include "include/yc_cli.h"
#include "include/yc_bt.h"

static yc_socket_server_s *g_udpsv = NULL;

static void t_udp_server_rcv_pf(IN int iSockfd,         IN void *pArg,
                                IN const void *pData,   IN uint uiDataLen,
                                IN const char *pcSrcIP, IN ushort usSrcPort)
{
    printf("[%d]<%s:%hu> %u: %s\r\n", iSockfd, pcSrcIP, usSrcPort, uiDataLen, (char *)pData);
}

static int cli_cmd_bt_callback(IN void *pPriv, IN char *pcArg)
{
    yc_bt_print();

    return YC_ERROR_SUCCESS;
}

int main(IN int argc, IN char *argv[])
{
    int  iPort;
    char acShellName[16];

    YC_IGNOPARA(argc);
    YC_IGNOPARA(argv);

	system("clear");

    acShellName[0] = '\0';
    yc_conf_get_key_4str("example.conf", "shell", "name", acShellName);
    yc_conf_get_key_4int("example.conf", "socket", "port", &iPort);

    printf("get config name = %s, port = %d\r\n", acShellName, iPort);

    g_udpsv = yc_udp_server_create(iPort, t_udp_server_rcv_pf, NULL);

    yc_cli_create(acShellName);

    yc_cli_add_cmd("bt", cli_cmd_bt_callback, NULL);

    yc_cli_run(false);

	yc_cli_destroy();

    if (NULL != g_udpsv)
    {
        yc_udp_server_destroy(g_udpsv);
        g_udpsv = NULL;
    }

    return YC_ERROR_SUCCESS;
}

